 /*
  * Khoros: $Id: lvheq.c,v 1.1 1991/05/10 15:41:54 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lvheq.c,v 1.1 1991/05/10 15:41:54 khoros Exp $";
#endif

 /*
  * $Log: lvheq.c,v $
 * Revision 1.1  1991/05/10  15:41:54  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lvheq.c
 >>>>
 >>>>      Program Name: vheq
 >>>>
 >>>> Date Last Updated: Thu Mar 28 00:03:02 1991 
 >>>>
 >>>>          Routines: lvheq - the library call for vheq
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lvheq - library call for vheq
*
* Purpose:
*    
*    Performs histogram equalization of a BYTE grey-level image.
*    
*    
* Input:
*    
*    image          points to the input xvimage structure
*    
*    pneg           a flag set (equal 1) if a photonegative output  is
*                   desired.
*    
*    
* Output:
*    
*    image          points to the xvimage structure that contains  the
*                   result of the operation.
*    
*    Return Value:  1 on success, 0 on failure.
*    
*    
*
* Written By: Scott Wilson
*    
*    Replaced call to lvhremap with inline code. c.gage  2/25/91
*    
*    
****************************************************************/


/* -library_def */
int
lvheq(image,pneg)
struct xvimage *image;
int   pneg;
/* -library_def_end */

/* -library_code */
  {
    int  i, j, nc, nr, lvinvert();
    unsigned int hist[256], map[256], k;
    unsigned char map1[256], *c, *p;
    float f;
 
    if (image->data_storage_type != VFF_TYP_1_BYTE)
      {
        (void) fprintf(stderr,"\n\nlvheq:   ");
        (void) fprintf(stderr,"sorry can only operate on byte images.\n\n");
        return(0);
      }

    nr = image->col_size;
    nc = image->row_size;

    /* Form histogram */
    bzero(hist,sizeof(unsigned int)*256);
    c = (unsigned char *)(image->imagedata);
    for (i=0; i<image->row_size*image->col_size; i++) hist[*c++]++;

    /* Integrate the histogram to get the equalization map */
    k = 0;
    for (i = 0; i < 256; i++)
      {
        k += hist[i];
        map[i] = k ;
      }

    /* Compute scale factor */
    if (map[255] == 0.0) 
      {
        (void) fprintf(stderr,"\n\nlvheq:   ");
        (void) fprintf(stderr,"Cumlative distribution is zero.\n");
        (void) fprintf(stderr,"Can't equalize a zero image.\n\n");
        return(0);
      }

    f = 255.0/map[255];
    
    /* scale the cumulative distribution */
    for (i = 0; i < 256; i++) 
        map1[i] = map[i] * f;

    /* Re-map the image to equalize */
    p = (unsigned char *)(image->imagedata);
    for (i = 0; i < nc; i++)
    {
        for (j = 0; j < nr; j++)
        {
            *p = map1[*p];
             p++;
        }
    }

    if(pneg)
    {
        if( !lvinvert(image) )
        {
            (void) fprintf(stderr,"lvinvert Failed\n");
           return(0);
        }
    }
 
        
    return(1);
}
/* -library_code_end */
