 /*
  * Khoros: $Id: lvfloor.c,v 1.1 1991/05/10 15:41:54 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lvfloor.c,v 1.1 1991/05/10 15:41:54 khoros Exp $";
#endif

 /*
  * $Log: lvfloor.c,v $
 * Revision 1.1  1991/05/10  15:41:54  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lvfloor.c
 >>>>
 >>>>      Program Name: vfloor
 >>>>
 >>>> Date Last Updated: Wed Mar 27 23:57:29 1991 
 >>>>
 >>>>          Routines: lvfloor - the library call for vfloor
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lvfloor - library call for vfloor
*
* Purpose:
*    
*    Clip the lowest levels of an image to a constant value.
*    
*    
* Input:
*    
*         1. - image - pointer to image to be clipped (floored)
*    
*    
* Output:
*    
*         1. - the input image is modifed (overwritten) and returned.
*    
*         lvfloor returns 1 upon success and 0 otherwise.
*    
*    
*
* Written By: Scott Wilson
*    
*    Ron E. Neher
*    
*    
****************************************************************/


/* -library_def */
int
lvfloor(image,value)
struct xvimage *image;
float value;
/* -library_def_end */

/* -library_code */
{
    int    *i, j, k;
    short  *s;
    float  *f, fv;
    unsigned char *c;

    switch (image->data_storage_type)
      {
        case VFF_TYP_BIT :
          (void) fprintf(stderr,"lvfloor: Don't know how to floor BIT images\n");
          return(0);
          break;
        case VFF_TYP_1_BYTE : 
          k = image->row_size*image->col_size * image->num_data_bands;
          c = (unsigned char *)(image->imagedata);
          for (j=0; j<k; j++)
            {
              if ((float)(*c) < value) *c = value;
              c++;
            }
          break;
        case VFF_TYP_2_BYTE :
          k = image->row_size*image->col_size * image->num_data_bands;
          s = (short *)(image->imagedata);
          for (j=0; j<k; j++)
            {
              if ((float)(*s) < value) *s = value;
              s++;
            }
          break;
        case VFF_TYP_4_BYTE :
          k = image->row_size*image->col_size * image->num_data_bands;
          i = (int *)(image->imagedata);
          for (j=0; j<k; j++)
            {
              if ((float)(*i) < value) *i = value;
              i++;
            }   
          break;
        case VFF_TYP_FLOAT :
          k = image->row_size*image->col_size * image->num_data_bands;
          f = (float *)(image->imagedata);
          for (j=0; j<k; j++)
            {
              if (*f < value) *f = value;
              f++;
            }   
          break;
        case VFF_TYP_COMPLEX :
          k = image->row_size*image->col_size * image->num_data_bands;

          f = (float *)(image->imagedata);
          for (j=0; j<k; j++)
            {
              fv =sqrt((double)((*f * *f) + (*(f+1) * *(f+1))));
              if (fv < value) { *f = value; *(f+1) = 0.0; }
              f += 2;  
            }
          break;
        default:
          (void) fprintf(stderr,"lvfloor: Unknown data storage type, %d\n",image->data_storage_type);
          return(0);
          break;
      }
      return(1);

}
/* -library_code_end */
