 /*
  * Khoros: $Id: lvcltrans.c,v 1.1 1991/05/10 15:41:54 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lvcltrans.c,v 1.1 1991/05/10 15:41:54 khoros Exp $";
#endif

 /*
  * $Log: lvcltrans.c,v $
 * Revision 1.1  1991/05/10  15:41:54  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lvcltrans.c
 >>>>
 >>>>      Program Name: vcltrans
 >>>>
 >>>> Date Last Updated: Tue Mar  5 22:21:42 1991 
 >>>>
 >>>>          Routines: lvcltrans - the library call for vcltrans
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
#include "vipl/lvcltrans.h"
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lvcltrans - library call for vcltrans
*
* Purpose:
*    
*    Tristimulus to tristimulus color space conversions
*    
*    
* Input:
*    
*    img            input image  of type xvimage
*    
*    type           output image colormap type.
*    
*    type_flg       if set the conversion is "type" otherwise  defalut
*                   is RGB.
*    
*    norm           normalization/scale factor.
*    
*    norm_flg       if set use "norm" else use 255.0.
*    
*    trmatrix       specifies a 3x3 user defined conversion matrix.
*    
*    mflg           if set  use  trmatrix,  else  use  "type"  as  the
*                   conversion type.
*    
*    
* Output:
*    
*    img            overwrites the input image  with  new  image  data
*                   and colormap type.
*    
*    
*
* Written By: Donna Koechner, Tom Sauer
*    
*    
****************************************************************/


/* -library_def */
int
lvcltrans (img, type, type_flg, norm, norm_flg, mflg, trmatrix)

struct xvimage *img,
               *trmatrix;
int     type,
        type_flg,
        norm_flg,
        mflg;
float   norm;
/* -library_def_end */

/* -library_code */
{

    float  *ptr1,
           *ptr2,
           *ptr3,
           *matptr,
            gen_matrix[3][3];

    register
    float   tmp1,
            tmp2,
            tmp3;

    int     i,j,
            model,
            trrow,
            trcol,
            nc,
            nr;

    char *program = "lvcltrans";

    if (!norm_flg)
        norm = 255.0; /* default normalization/scale factor */
    if (!type_flg)
        type = 1; /* default conversion to RGB */

    if (!propertype (program, img, VFF_TYP_FLOAT, FALSE)) {
        (void) fprintf (stderr, "lvcltrans: ERROR image must be ");
        (void) fprintf (stderr, "of data type FLOAT\n");
        return (0);
    }

      /* can only have one image*/

    if (! (proper_num_images(program,img,1,FALSE))) {
         (void) fprintf(stderr,
                 "%s: ERROR All inputs must contain only one image\n"
                 , program);
          return(0);
     }

      /* can only have three data bands */

     if (! (proper_num_bands(program,img,3,FALSE))) {
          (void) fprintf(stderr,
                  "%s: ERROR input image must contain three data band\n"
                  , program);
           return(0);
      }

      /* must have map enable set to OPTIONAL */

     if (! (proper_map_enable(program,img,VFF_MAP_OPTIONAL,FALSE))) {
          (void) fprintf(stderr,
                  "%s: ERROR input must have map enable type OPTIONAL\n"
                  ,program);
           return(0);
      }

    nr = img -> col_size;
    nc = img -> row_size;

    if (mflg) {  /* use the input image trmatrix as the conversion matrix */

                /* conversion matrix must be float */
        if (!propertype (program, trmatrix, VFF_TYP_FLOAT, FALSE)) {
            (void) fprintf (stderr,
                    "lvcltrans: ERROR Conversion matrix image must be ");
            (void) fprintf (stderr, "of data type FLOAT\n");
            return (0);
        }

                /* conversion matrix must be 3x3 */
        if (!propersize (program, trmatrix, 3, 3, FALSE)) {
            (void) fprintf (stderr,
                    "lvcltrans: ERROR conversion matrix  must be ");
            (void) fprintf (stderr, "of size 3x3\n");
            return (0);
        }


      /* can only have one data band */

    if (! (proper_num_images(program,trmatrix,1,FALSE))) {
         (void) fprintf(stderr,
                 "%s: ERROR All inputs must contain only one image\n"
                 , program);
          return(0);
     }

      /* can only have one data band */

     if (! (proper_num_bands(program,trmatrix,1,FALSE))) {
          (void) fprintf(stderr,
                  "%s: ERROR All inputs must contain only one data band\n"
                  , program);
           return(0);
      }

      /* must have map enable set to OPTIONAL */

     if (! (proper_map_enable(program,trmatrix,VFF_MAP_OPTIONAL,FALSE))) {
          (void) fprintf(stderr,
                  "%s: ERROR input must have map enable type OPTIONAL\n"
                  ,program);
           return(0);
      }
           /* point to input image data */
        ptr1 = (float *) &img -> imagedata[0];
        ptr2 = (float *) &img -> imagedata[nr * nc * sizeof (float)];
        ptr3 = (float *) &img -> imagedata[2 * nr * nc * sizeof (float)];

        trrow = trmatrix->col_size;
        trcol = trmatrix->row_size;

                /* need the conversion matrix to be in a 3x3 array, this is
                   for use in the #define conversion statements */

        matptr = (float *) trmatrix -> imagedata;

        for ( i = 0; i < trrow; i++) {
           for ( j = 0; j < trcol; j++) {
              gen_matrix[i][j] = *matptr;
              matptr++;
           }
        }

            /* perform the conversion */
        for (i = 0; i < nr * nc; i++) {
            tmp1 = *ptr1/norm; /* first normalize/scale */
            tmp2 = *ptr2/norm;
            tmp3 = *ptr3/norm;
            *ptr1 = TRANS1 (tmp1, tmp2, tmp3, gen_matrix); /*actual conversion*/
            *ptr2 = TRANS2 (tmp1, tmp2, tmp3, gen_matrix);
            *ptr3 = TRANS3 (tmp1, tmp2, tmp3, gen_matrix);
            ++ptr1; ++ptr2; ++ptr3;
        }
                /* new colormap model is GENERIC */
        img -> color_space_model = VFF_CM_GENERIC;
    }


    else { /* the mflg was not set, so use "type" as the resulting conversion */

        model = img -> color_space_model;

                /* input image must be RGB, CMY, YIQ, XYZ, UVW */

        if (model != VFF_CM_ntscRGB &&
                model != VFF_CM_genericRGB &&
                model != VFF_CM_ntscCMY &&
                model != VFF_CM_ntscYIQ &&
                model != VFF_CM_cieXYZ &&
                model != VFF_CM_cieUVW) {
            (void) fprintf (stderr, "lvcltrans: ERROR Input image must be\n");
            (void) fprintf (stderr, 
                     "of multi-spectral typentscRGB, genericRGB, ntscYIQ,\n"); 
            (void) fprintf(stderr,"cieXYZ, cieUVW, or ntscCMY\n");
            return (0);
        }

        ptr1 = (float *) & img -> imagedata[0];
        ptr2 = (float *) & img -> imagedata[nr * nc * sizeof (float)];
        ptr3 = (float *) & img -> imagedata[2 * nr * nc * sizeof (float)];

         /* first switch on the input colormap model, then swtich on
            the output colormap model */
        switch (img -> color_space_model) {
            case VFF_CM_ntscRGB: 
            case VFF_CM_genericRGB: 
                switch (type) {
                    case 1:     /* convert to NTSC: RGB */
                        img -> color_space_model = VFF_CM_ntscRGB;
                        break;  /* RGB to RGB -- no conversion necessary */
                    case 2:     /* convert to generic: RGB */
                        img -> color_space_model = VFF_CM_genericRGB;
                        break;  /* RGB to RGB -- no conversion necessary */
                    case 3:     /* convert to NTSC: YIQ */
                        for (i = 0; i < nr * nc; i++) {
                            tmp1 = *ptr1/norm;
                            tmp2 = *ptr2/norm;
                            tmp3 = *ptr3/norm;
                            *ptr1 = TRANS1 (tmp1, tmp2, tmp3, RGBtoYIQ);
                            *ptr2 = TRANS2 (tmp1, tmp2, tmp3, RGBtoYIQ);
                            *ptr3 = TRANS3 (tmp1, tmp2, tmp3, RGBtoYIQ);
                            ++ptr1; ++ptr2; ++ptr3;
                        }
                        img -> color_space_model = VFF_CM_ntscYIQ;
                        break;
                    case 4:     /* convert to NTSC: CMY */
                        for (i = 0; i < nr * nc; i++) {
                            *ptr1 = 1 - (*ptr1/norm); /* CMY = 1 - RGB */
                            *ptr2 = 1 - (*ptr2/norm);
                            *ptr3 = 1 - (*ptr3/norm);
                            ptr1++; ptr2++; ptr3++;
                        }
                        img -> color_space_model = VFF_CM_ntscCMY;
                        break;
                    case 5:     /* convert to CIE: XYZ */
                        for (i = 0; i < nr * nc; i++) {
                            tmp1 = *ptr1/norm;
                            tmp2 = *ptr2/norm;
                            tmp3 = *ptr3/norm;
                            *ptr1 = TRANS1 (tmp1, tmp2, tmp3, RGBtoXYZ);
                            *ptr2 = TRANS2 (tmp1, tmp2, tmp3, RGBtoXYZ);
                            *ptr3 = TRANS3 (tmp1, tmp2, tmp3, RGBtoXYZ);
                            ++ptr1; ++ptr2; ++ptr3;
                        }
                        img -> color_space_model = VFF_CM_cieXYZ;
                        break;
                    case 6:     /* convert to CIE: UVW */
                        for (i = 0; i < nr * nc; i++) {
                            tmp1 = *ptr1/norm;
                            tmp2 = *ptr2/norm;
                            tmp3 = *ptr3/norm;
                            *ptr1 = TRANS1(tmp1, tmp2, tmp3, RGBtoUVW); ptr1++;
                            *ptr2 = TRANS2(tmp1, tmp2, tmp3, RGBtoUVW); ptr2++;
                            *ptr3 = TRANS3(tmp1, tmp2, tmp3, RGBtoUVW); ptr3++;
                        }
                        img -> color_space_model = VFF_CM_cieUVW;
                        break;
                    default: 
                        (void) fprintf (stderr, "lvcltrans: ERROR invalid");
                        (void) fprintf (stderr, "type to convert input image to\n");
                        return (0);
                        break;
                }
                break;
            case VFF_CM_ntscYIQ: 
                switch (type) {
                    case 1:     /* convert to NTSC: RGB */
                    case 2:     /* convert to generic: RGB */
                        for (i = 0; i < nr * nc; i++) {
                            tmp1 = *ptr1/norm;
                            tmp2 = *ptr2/norm;
                            tmp3 = *ptr3/norm;
                            *ptr1 = TRANS1 (tmp1, tmp2, tmp3, YIQtoRGB);
                            *ptr2 = TRANS2 (tmp1, tmp2, tmp3, YIQtoRGB);
                            *ptr3 = TRANS3 (tmp1, tmp2, tmp3, YIQtoRGB);
                            ++ptr1; ++ptr2; ++ptr3;
                        }
                        if (type == 1)
                           img -> color_space_model = VFF_CM_ntscRGB;
                        else
                           img -> color_space_model = VFF_CM_genericRGB;

                        break;
                    case 3:     /* convert to NTSC: YIQ */
                        img -> color_space_model = VFF_CM_ntscYIQ;
                        break;
                    case 4:     /* convert to NTSC: CMY */
                           /* use conversion matrix to RGB then transform
                               the RGB to CMY */
                        for (i = 0; i < nr * nc; i++) {
                            tmp1 = *ptr1/norm;
                            tmp2 = *ptr2/norm;
                            tmp3 = *ptr3/norm;
                            *ptr1 = TRANS1 (tmp1, tmp2, tmp3, YIQtoRGB);
                            *ptr2 = TRANS2 (tmp1, tmp2, tmp3, YIQtoRGB);
                            *ptr3 = TRANS3 (tmp1, tmp2, tmp3, YIQtoRGB);
                            *ptr1 = 1 - *ptr1; /* convert to CMY from RGB */
                            *ptr2 = 1 - *ptr2; /* CMY = 1 - RGB */
                            *ptr3 = 1 - *ptr3;
                            ++ptr1; ++ptr2; ++ptr3;
                        }
                        img -> color_space_model = VFF_CM_ntscCMY;
                        break;
                    case 5:     /* convert to CIE: XYZ */
                        for (i = 0; i < nr * nc; i++) {
                            tmp1 = *ptr1/norm;
                            tmp2 = *ptr2/norm;
                            tmp3 = *ptr3/norm;
                            *ptr1 = TRANS1 (tmp1, tmp2, tmp3, YIQtoXYZ);
                            *ptr2 = TRANS2 (tmp1, tmp2, tmp3, YIQtoXYZ);
                            *ptr3 = TRANS3 (tmp1, tmp2, tmp3, YIQtoXYZ);
                            ++ptr1; ++ptr2; ++ptr3;
                        }
                        img -> color_space_model = VFF_CM_cieXYZ;
                        break;
                    case 6:     /* convert to CIE: UVW */
                        for (i = 0; i < nr * nc; i++) {
                            tmp1 = *ptr1/norm;
                            tmp2 = *ptr2/norm;
                            tmp3 = *ptr3/norm;
                            *ptr1 = TRANS1 (tmp1, tmp2, tmp3, YIQtoUVW);
                            *ptr2 = TRANS2 (tmp1, tmp2, tmp3, YIQtoUVW);
                            *ptr3 = TRANS3 (tmp1, tmp2, tmp3, YIQtoUVW);
                            ++ptr1; ++ptr2; ++ptr3;
                        }
                        img -> color_space_model = VFF_CM_cieUVW;
                        break;
                    default: 
                        (void) fprintf (stderr, "lvcltrans: ERROR invalid");
                        (void) fprintf (stderr, "type to convert input image to\n");
                        return (0);
                        break;
                }
                break;
            case VFF_CM_ntscCMY: 
                  /* for conversion from CMY to YIQ, XYZ, UVW, first
                     must convert to RGB then perform the transformation */
                switch (type) {
                    case 1:     /* convert to NTSC: RGB */
                    case 2:     /* convert to generic: RGB */
                        for (i = 0; i < nr * nc; i++) {
                            *ptr1 = 1 - *ptr1;
                            *ptr2 = 1 - *ptr2;
                            *ptr3 = 1 - *ptr3;
                            ++ptr1;
                            ++ptr2;
                            ++ptr3;
                        }
                        if ( type == 1) 
                           img -> color_space_model = VFF_CM_ntscRGB;
                        else
                           img -> color_space_model = VFF_CM_genericRGB;

                        break;
                    case 3:     /* convert to NTSC: YIQ */
                        for (i = 0; i < nr * nc; i++) {
                            tmp1 = 1 - (*ptr1/norm);
                            tmp2 = 1 - (*ptr2/norm);
                            tmp3 = 1 - (*ptr3/norm);
                            *ptr1 = TRANS1 (tmp1, tmp2, tmp3, RGBtoYIQ);
                            *ptr2 = TRANS2 (tmp1, tmp2, tmp3, RGBtoYIQ);
                            *ptr3 = TRANS3 (tmp1, tmp2, tmp3, RGBtoYIQ);
                            ++ptr1; ++ptr2; ++ptr3;
                        }
                        img -> color_space_model = VFF_CM_ntscYIQ;
                        break;
                    case 4:     /* convert to NTSC: CMY */
                        img -> color_space_model = VFF_CM_ntscCMY;
                        break;
                    case 5:     /* convert to CIE: XYZ */
                        for (i = 0; i < nr * nc; i++) {
                            tmp1 = 1 - (*ptr1/norm);
                            tmp2 = 1 - (*ptr2/norm);
                            tmp3 = 1 - (*ptr3/norm);
                            *ptr1 = TRANS1 (tmp1, tmp2, tmp3, RGBtoXYZ);
                            *ptr2 = TRANS2 (tmp1, tmp2, tmp3, RGBtoXYZ);
                            *ptr3 = TRANS3 (tmp1, tmp2, tmp3, RGBtoXYZ);
                            ++ptr1; ++ptr2; ++ptr3;
                        }
                        img -> color_space_model = VFF_CM_cieXYZ;
                        break;
                    case 6:     /* convert to CIE: UVW */
                        for (i = 0; i < nr * nc; i++) {
                            tmp1 = 1 - (*ptr1/norm);
                            tmp2 = 1 - (*ptr2/norm);
                            tmp3 = 1 - (*ptr3/norm);
                            *ptr1 = TRANS1 (tmp1, tmp2, tmp3, RGBtoUVW);
                            *ptr2 = TRANS2 (tmp1, tmp2, tmp3, RGBtoUVW);
                            *ptr3 = TRANS3 (tmp1, tmp2, tmp3, RGBtoUVW);
                            ++ptr1; ++ptr2; ++ptr3;
                        }
                        img -> color_space_model = VFF_CM_cieUVW;
                        break;
                    default: 
                        (void) fprintf (stderr, "lvcltrans: ERROR invalid");
                        (void) fprintf (stderr, "type to convert input image to\n");
                        return (0);
                        break;
                }
                break;
            case VFF_CM_cieXYZ: 
                switch (type) {
                    case 1:     /* convert to NTSC: RGB */
                    case 2:     /* convert to generic: RGB */
                        for (i = 0; i < nr * nc; i++) {
                            tmp1 = *ptr1/norm;
                            tmp2 = *ptr2/norm;
                            tmp3 = *ptr3/norm;
                            *ptr1 = TRANS1 (tmp1, tmp2, tmp3, XYZtoRGB);
                            *ptr2 = TRANS2 (tmp1, tmp2, tmp3, XYZtoRGB);
                            *ptr3 = TRANS3 (tmp1, tmp2, tmp3, XYZtoRGB);
                            ++ptr1; ++ptr2; ++ptr3;
                        }
                        if ( type == 1)
                           img -> color_space_model = VFF_CM_ntscRGB;
                        else
                           img -> color_space_model = VFF_CM_genericRGB;
                        break;
                    case 3:     /* convert to NTSC: YIQ */
                        for (i = 0; i < nr * nc; i++) {
                            tmp1 = *ptr1/norm;
                            tmp2 = *ptr2/norm;
                            tmp3 = *ptr3/norm;
                            *ptr1 = TRANS1 (tmp1, tmp2, tmp3, XYZtoYIQ);
                            *ptr2 = TRANS2 (tmp1, tmp2, tmp3, XYZtoYIQ);
                            *ptr3 = TRANS3 (tmp1, tmp2, tmp3, XYZtoYIQ);
                            ++ptr1; ++ptr2; ++ptr3;
                        }
                        img -> color_space_model = VFF_CM_ntscYIQ;
                        break;
                    case 4:     /* convert to NTSC: CMY */
                        for (i = 0; i < nr * nc; i++) {
                            tmp1 = *ptr1/norm;
                            tmp2 = *ptr2/norm;
                            tmp3 = *ptr3/norm;
                            *ptr1 = TRANS1 (tmp1, tmp2, tmp3, XYZtoRGB);
                            *ptr2 = TRANS2 (tmp1, tmp2, tmp3, XYZtoRGB);
                            *ptr3 = TRANS3 (tmp1, tmp2, tmp3, XYZtoRGB);
                            *ptr1 = 1 - *ptr1;
                            *ptr2 = 1 - *ptr2;
                            *ptr3 = 1 - *ptr3;
                            ++ptr1; ++ptr2; ++ptr3;
                        }
                        img -> color_space_model = VFF_CM_ntscCMY;
                        break;
                    case 5:     /* convert to CIE: XYZ */
                        img -> color_space_model = VFF_CM_cieXYZ;
                        break;
                    case 6:     /* convert to CIE: UVW */
                        for (i = 0; i < nr * nc; i++) {
                            tmp1 = *ptr1/norm;
                            tmp2 = *ptr2/norm;
                            tmp3 = *ptr3/norm;
                            *ptr1 = TRANS1 (tmp1, tmp2, tmp3, XYZtoUVW);
                            *ptr2 = TRANS2 (tmp1, tmp2, tmp3, XYZtoUVW);
                            *ptr3 = TRANS3 (tmp1, tmp2, tmp3, XYZtoUVW);
                            ++ptr1; ++ptr2; ++ptr3;
                        }
                        img -> color_space_model = VFF_CM_cieUVW;
                        break;
                    default: 
                        (void) fprintf (stderr, "lvcltrans: ERROR invalid");
                        (void) fprintf (stderr, "type to convert input image to\n");
                        return (0);
                        break;
                }
                break;
            case VFF_CM_cieUVW: 
                switch (type) {
                    case 1:     /* convert to NTSC: RGB */
                    case 2:     /* convert to generic: RGB */
                        for (i = 0; i < nr * nc; i++) {
                            tmp1 = *ptr1/norm;
                            tmp2 = *ptr2/norm;
                            tmp3 = *ptr3/norm;
                            *ptr1 = TRANS1 (tmp1, tmp2, tmp3, UVWtoRGB);
                            *ptr2 = TRANS2 (tmp1, tmp2, tmp3, UVWtoRGB);
                            *ptr3 = TRANS3 (tmp1, tmp2, tmp3, UVWtoRGB);
                            ++ptr1; ++ptr2; ++ptr3;
                        }
                        if ( type == 1)
                           img -> color_space_model = VFF_CM_ntscRGB;
                        else
                           img -> color_space_model = VFF_CM_genericRGB;
                        break;
                    case 3:     /* convert to NTSC: YIQ */
                        for (i = 0; i < nr * nc; i++) {
                            tmp1 = *ptr1/norm;
                            tmp2 = *ptr2/norm;
                            tmp3 = *ptr3/norm;
                            *ptr1 = TRANS1 (tmp1, tmp2, tmp3, UVWtoYIQ);
                            *ptr2 = TRANS2 (tmp1, tmp2, tmp3, UVWtoYIQ);
                            *ptr3 = TRANS3 (tmp1, tmp2, tmp3, UVWtoYIQ);
                            ++ptr1; ++ptr2; ++ptr3;
                        }
                        img -> color_space_model = VFF_CM_ntscYIQ;
                        break;
                    case 4:     /* convert to NTSC: CMY */
                        for (i = 0; i < nr * nc; i++) {
                            tmp1 = *ptr1/norm;
                            tmp2 = *ptr2/norm;
                            tmp3 = *ptr3/norm;
                            *ptr1 = TRANS1 (tmp1, tmp2, tmp3, UVWtoRGB);
                            *ptr2 = TRANS2 (tmp1, tmp2, tmp3, UVWtoRGB);
                            *ptr3 = TRANS3 (tmp1, tmp2, tmp3, UVWtoRGB);
                            *ptr1 = 1 - *ptr1;
                            *ptr2 = 1 - *ptr2;
                            *ptr3 = 1 - *ptr3;
                            ++ptr1; ++ptr2; ++ptr3;
                        }
                        img -> color_space_model = VFF_CM_ntscCMY;
                        break;
                    case 5:     /* convert to CIE: XYZ */
                        for (i = 0; i < nr * nc; i++) {
                            tmp1 = *ptr1/norm;
                            tmp2 = *ptr2/norm;
                            tmp3 = *ptr3/norm;
                            *ptr1 = TRANS1 (tmp1, tmp2, tmp3, UVWtoXYZ);
                            *ptr2 = TRANS2 (tmp1, tmp2, tmp3, UVWtoXYZ);
                            *ptr3 = TRANS3 (tmp1, tmp2, tmp3, UVWtoXYZ);
                            ++ptr1; ++ptr2; ++ptr3;
                        }
                        img -> color_space_model = VFF_CM_cieXYZ;
                        break;
                    case 6:     /* convert to CIE: UVW */
                        img -> color_space_model = VFF_CM_cieUVW;
                        break;
                    default: 
                        (void) fprintf (stderr, "lvcltrans: ERROR invalid");
                        (void) fprintf (stderr, 
                                        "type to convert input image to\n");
                        return (0);
                        break;
                }
                break;
            default: 
                (void) fprintf (stderr, "lvcltrans: ERROR invalid");
                (void) fprintf (stderr, "input image colormap model,\n");
                (void) fprintf (stderr, "must be ntscRGB, genericRGB, \n");
                (void) fprintf (stderr, 
                        "ntscCMY, ntscYIQ, cieXYZ,  or cieUVW\n");
                return (0);
                break;
        }
    }

    return (1);
}
/* -library_code_end */
