#! /bin/csh -f

# 
#  Khoros: $Id: ksrcconf_csh.csh,v 1.4 1992/03/20 22:36:08 dkhoros Exp $
#

#
# $Log: ksrcconf_csh.csh,v $
# Revision 1.4  1992/03/20  22:36:08  dkhoros
# VirtualPatch5
#
# 

#
#*----------------------------------------------------------------------
#*
#* Copyright 1991, University of New Mexico.  All rights reserved.
#*
#* Permission to copy and modify this software and its documen-
#* tation only for internal use in your organization is hereby
#* granted, provided that this notice is retained thereon and
#* on all copies.  UNM makes no representations as too the sui-
#* tability and operability of this software for any purpose.
#* It is provided "as is" without express or implied warranty.
#* 
#* UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
#* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
#* NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
#* INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
#* SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
#* IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
#* ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
#* FORMANCE OF THIS SOFTWARE.
#* 
#* No other rights, including for example, the right to redis-
#* tribute this software and its documentation or the right to
#* prepare derivative works, are granted unless specifically
#* provided in a separate license agreement.
#*---------------------------------------------------------------------
#

#include "unmcopyright.h"	 /* Copyright 1991 by UNM */


#  >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
#  >>>>                                                       <<<<
#  >>>>	    file name: ksrcconf_csh                           <<<<
#  >>>>                                                       <<<<
#  >>>>   description: utility for khoros source configuration.
#  >>>>                Used to configure symbolic linked 
#  >>>>                source trees for each architecture
#  >>>>                described in the mach file.            <<<<
#  >>>>                                                       <<<<
#  >>>> modifications: added toolbox support.                 <<<<
#  >>>>                Tom Sauer 9/20/91                      <<<<
#  >>>>                                                       <<<<
#  >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< 
#
# ROUTINE NAME:	ksrcconf_csh
# 
# AUTHORS:	Charlie Gage, Tom Sauer
# 
# DATE:		3/9/90
# 
# DESCRIPTION:	Script used to configure symbolic linked source trees
#		for each architecture described in the mach file.
# 
# MODIFICATIONS:

set noclobber

#  Input Argument Checking
#------------------------------------------------------------
if ($#argv != 2) then
  echo ""
  echo "Invalid number of arguments detected."
  echo "Please invoke this script from the C driver program."
  echo ""
  exit 0
endif

# Set up environment variables
#----------------------------------------------------------
if (! $?KHOROS_HOME ) then
   echo ""
   echo "ksrcconf: Error KHOROS_HOME environment variable is not set"
   echo ""
   exit 0
endif

set path = ( . $KHOROS_HOME/bin $path /usr/local/bin /usr/ucb \
             /usr/bin /bin /usr/local/etc/ /usr/etc /etc )

#Get the arguments from the driver program
#-----------------------------------------------------
# The arguments are:
#  SOURCE  MACH
#
#  SOURCE (argument 1) specifies the location of the source file
#          The only acceptable input to this argument is a
#          full path to the source file which is provided by the
#          C driver program, and any other ktool script that
#          calls this script.
#
#  MACH (argument 2) specifies a location to a specified mach file
#                    that is different from the default location.
#                    The default path is provided by the C driver
#                    program if no path is given.  The default path
#                    is also used if any ktool script calls this 
#                    script with "_NULL_".
#      (default location: $KHOROS_HOME/repos/config/src_conf/default_mach)
#
#
set SOURCE = $1
set MACH = $2

umask 002
set PWD = `pwd`

set FULLHOST = `hostname`

if ($MACH == "_NULL_") then
    if (-f $KHOROS_HOME/repos/config/src_conf/default_mach.{$FULLHOST}) then
       set MACH = $KHOROS_HOME/repos/config/src_conf/default_mach.{$FULLHOST}
    else if (-f $KHOROS_HOME/repos/config/src_conf/default_mach) then
	set MACH = $KHOROS_HOME/repos/config/src_conf/default_mach
    else
        echo ""
        echo "ksrcconf: The default mach file:"
	echo "$MACH"
	echo "does not exist."
        echo "Please either specify a Toolbox name or if you are"
	echo "configuring KHOROS_HOME, check the mach files" 
        echo "in $KHOROS_HOME/repos/config/src_conf"
        echo "For more information please Khoros Manual Vol 1, Ch. 9"
        echo ""
        exit 1
    endif
else if (-f $MACH.{$FULLHOST} ) then
	set MACH = $MACH.{$FULLHOST}
    else if (! -f $MACH ) then
           echo ""
           echo "ksrcconf: Error, the mach file '$MACH' for the toolbox"
	   echo "specified was not found. Please create a mach file"
	   echo "in $MACH"
	   echo "for the specified toolbox."
           echo ""
           exit 1
    endif
endif

# source the mach file determined in the chaos above

set MACH = `eval echo $MACH`
source $MACH
echo "using '$MACH' file"

if (! -d $SOURCE) then
    echo ""
    echo "ksrcconf: Error, SOURCE directory invalid."
    echo ""
    goto cleanup
endif

if ($KHOROS_USER == "") then
   echo ""
   echo "ksrcconf: KHOROS_USER environment variable not set."
   echo " Please check your mach file:"
   echo " $MACH for this variable."
   echo ""
   goto cleanup
endif


#  Read the default_mach file and get appropriate info
#-------------------------------------------------

set NUM_MACHINES = $#KHOROS_MACHINES
set NUM_DIR = $#KHOROS_MACH_DIR
set NUM_SRC = $#KHOROS_SRC_TOP

if ( ($NUM_MACHINES != $NUM_DIR) && ($NUM_MACHINES != $NUM_SRC) || $NUM_DIR < 1 ) then
   echo ""
   echo "ksrcconf: Error, incorrect number of entries in the MACH file:"
   echo "$MACH"
   echo " Please check that the number of entries in each field"
   echo " is the same (ie. number of entires must correspond)."
   echo "Note, klnfile should only be called if srcmachs are being used."
   echo ""
   goto cleanup
endif

if (! -d $LOCAL_SRC_TOP) then
      echo ""
      echo "ksrcconf: Error, The LOCAL_SRC_TOP field is not set"
      echo "Please set this field in the mach file located in:"
      echo "$MACH"
      goto cleanup
endif


# Check to see if .rhosts file exists, if not then
# copy over the .rhosts.bk to .rhosts for the rsh to work
#-----------------------------------------------------
if ( ! -e ~$KHOROS_USER/.rhosts && $NUM_MACHINES > 0) then
  if ( ! -e ~$KHOROS_USER/.rhosts.bk) then
     echo "Please set up a .rhost file in ~$KHOROS_USER"
     goto cleanup
  else
   echo ""
   echo "Copying ~$KHOROS_USER/.rhosts.bk to ~$KHOROS_USER/.rhosts"
   echo ""
   \cp ~$KHOROS_USER/.rhosts.bk ~$KHOROS_USER/.rhosts
 endif
endif

set FULLPATH = $SOURCE

# foreach directory in $KHOROS_MACH_DIR/srcxxx, make the symbolic links
#---------------------------------------------------------------------------

  if ($FULLPATH != $LOCAL_SRC_TOP) then
     set RELPATH = `echo $FULLPATH | sed -e "s|$LOCAL_SRC_TOP/||"`
  else
      set RELPATH
  endif

  if (! -d $LOCAL_SRC_TOP/$RELPATH) then
        echo ""
        echo "ksrcconf: The source directory:"
        echo "		$LOCAL_SRC_TOP/$RELPATH" 
	echo "is invalid. Please check that the fields in the mach file:"
	echo "$MACH"
	echo "are correct."
        echo ""
        goto cleanup
  endif


  @ i = 1
  foreach machine ($KHOROS_MACHINES)
    if ($RELPATH == "") then
        set DESTDIR = $KHOROS_MACH_DIR[$i]
        set HOMEDIR = $KHOROS_SRC_TOP[$i]
    else
        set DESTDIR = $KHOROS_MACH_DIR[$i]/$RELPATH
        set HOMEDIR = $KHOROS_SRC_TOP[$i]/$RELPATH
    endif
    echo ""
    echo "ksrcconf: Making links in $KHOROS_MACH_DIR[$i]"
    echo ""
    rsh $machine -l $KHOROS_USER \
         "umask 002; \
         touch /tmp/make.$$; \
         echo "Making links on $machine in: $DESTDIR" >>& /tmp/make.$$; \
         klndir_csh $HOMEDIR $DESTDIR  >>& /tmp/make.$$; \
         cd $DESTDIR >>& /tmp/make.$$; \
         make Makefile >>& /tmp/make.$$; \
         make depend >>& /tmp/make.$$; \
         mail -s '"Results from ksrcconf for $machine"' $KHOROS_MAIL < /tmp/make.$$ ; \
         \rm -f /tmp/make.$$" &

   @ i++
   sleep 5
  end
endif

cleanup:
# Clean up variables
#--------------------------------------------------

if (-e ~{$KHOROS_USER}/.rhosts) then
   \mv ~{$KHOROS_USER}/.rhosts ~{$KHOROS_USER}/.rhosts.bk
endif

unset KHOROS_USER
unset KHOROS_MACHINES
unset KHOROS_MACH_DIR
unset KHOROS_SRC_TOP
unset LOCAL_SRC_TOP

exit 0  # normal exit
