 /*
  * Khoros: $Id: helppage.c,v 1.2 1991/10/02 00:01:06 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: helppage.c,v 1.2 1991/10/02 00:01:06 khoros Exp $";
#endif

 /*
  * $Log: helppage.c,v $
 * Revision 1.2  1991/10/02  00:01:06  khoros
 * HellPatch2
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: helppage.c
 >>>>
 >>>>      Program Name: helppage
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	A utility for Updating/Creating Help Pages for Cantata.
 >>>>	
 >>>>	

 >>>>            Author: Tom Sauer and Charlie Gage
 >>>>
 >>>> Date Last Updated: Wed Sep 25 22:10:48 1991
 >>>>
 >>>>          Routines: main- the main program for helppage
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "helppage.h"


/****************************************************************
 *
 * Routine Name:  main program for helppage
 *
 *       Input:  
 *
 *          -i  input Man (1) file    -OR-
 *          -all  Format All Man (1) pages
 *
 *          [-toolbox] Toolbox name
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
char *inputpath, machpath[MAXPATHLEN];
char *vexpandpath(), *vbasename();
char buffer[BUFSIZE];
char *script_file, *toolboxpath, *toolbox, *all_flg, *cptr;
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
if (check_args()) exit(1);

if ( (!helppage->i_flag && !helppage->all_flag) || (helppage->i_flag && helppage->all_flag) )
{
    (void)fprintf(stderr,"Must select either -i OR -all option.\n");
    exit(0);
}

if ( (helppage->i_flag) && (!helppage->all_flag) )
{
  if ((inputpath = vexpandpath(helppage->i_file, NULL, NULL)) == NULL)
  {
    (void)fprintf(stderr,"Invalid path obtained for the input file.\n");
    exit(0);
  }
  all_flg = "0";
}
else
{
  inputpath = VStrcpy("_NULL_");
}

if ( (helppage->all_flag) && (helppage->all_logic == 1) && (!helppage->i_flag) )
{
   all_flg = "1";
   inputpath = VStrcpy("_NULL_");
}
else if (!helppage->i_flag)
{
   (void)fprintf(stderr,"Must select either -i OR -all option.\n");
   (void)fprintf(stderr,"The only valid argument for -all is 1 (TRUE)\n");
   exit(0);
}

if (helppage->toolbox_flag)
{
  toolboxpath = vtoolbox_path(helppage->toolbox_string);
  if (toolboxpath == NULL)
  {
     fprintf(stderr, "%s:  The toolbox name '%s' is not a valid toolbox.\n",
             program, helppage->toolbox_string);
     exit(0);
  }

  toolbox = vlower_string(helppage->toolbox_string, NULL);
        
  sprintf(machpath, "%s/%s/%s_mf", toolboxpath, MACH_FILE_PATH, toolbox);

}
else
{
  sprintf(machpath, "_NULL_");
}


/* Assign a filename to the shell script file */
script_file = VStrcpy("helppage_csh"); 

/* Build the buffer for the system call */ 
(void) sprintf(buffer,"%s %s %s %s", script_file, inputpath, all_flg, machpath);

/* System off the helppage_csh script */
system(buffer);

/* -main_before_lib_call_end */

/* -main_library_call */
/* -main_library_call_end */

/* -main_after_lib_call */
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for helppage 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "helppage :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tA utility for Updating/Creating Help Pages for Cantata.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr, "\n");
	fprintf(stderr,"\t-i  input Man (1) file  (infile) -OR- \n");
	fprintf(stderr,"\t-all  Format All Man (1) pages  (boolean) \n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-toolbox]  Toolbox name (string) [null]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for helppage\n");
	fprintf(stderr, "\t[-U] Gives the usage for helppage\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called helppage.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses helppage.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for helppage
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input Man (1) file \n        {infile}: "; 
char	*all_pstr = 
	"\nEnter: (all) Format All Man (1) pages \n        {boolean, (y/n)  [no] }: "; 
char	*toolbox_pstr = 
	"\nEnter: (toolbox) Toolbox name \n        {string}: "; 
char	*toolbox_def = NULL;
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "helppage", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "helppage.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "helppage: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "helppage.ans");
		}

	     }

	}

	/*
	 * allocate the helppage structure
	 */
	helppage = (helppage_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (helppage_struct));

	/*
	 * get required mutually exclusive groups for helppage
	 */
	if (prompt_flag == TRUE)
	{
		   fprintf(stderr, "\nThe following prompts are mutually exclusive.\n");
		   fprintf(stderr, "\nHit <cr> until the desired prompt appears.\n");
	   ok = FALSE;
	   while(!ok)
	   {
		helppage->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(helppage->i_file))
;

    		if(!( (helppage->i_flag)))
		    helppage->all_flag = vget_logic(fid, prompt_flag,
		    "-all", all_pstr, &(helppage->all_logic), 0);

		if((helppage->i_flag)|| 
		    (helppage->all_flag))
		    ok = TRUE;
		else
		{
		   fprintf(stderr, "Error: You MUST specify one of :\n");
		    fprintf(stderr, " -i  -all \n");
		}
	   }
		   fprintf(stderr, "\n ------\n");
	}
	else
	{
		count = 0;
		if(helppage->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(helppage->i_file))
)
		    count++;

		if(helppage->all_flag = vget_logic(fid, prompt_flag,
		    "-all", all_pstr, &(helppage->all_logic), 0))
		    count++;

		if (count == 0)
		{
		    fprintf(stderr, "Error: You MUST specify one of :\n");
		    fprintf(stderr, " -i  -all \n");
		    gw_usage();
		    exit(1);
		}

		else if (count > 1)
		{
		    fprintf(stderr, "Error: You may specify ONLY ONE of :\n");
		    fprintf(stderr, " -i  -all \n");
		    gw_usage();
		    exit(1);
		}

	}

	/*
	 * get optional arguments for helppage
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	helppage->toolbox_flag = vget_string(fid, prompt_flag,
	"-toolbox", toolbox_pstr, &(helppage->toolbox_string),
	toolbox_def);

	if (prompt_flag == FALSE)
	{
	    if ((helppage->toolbox_flag == 1)&&(helppage->toolbox_string == NULL))
    	{
		fprintf(stderr, "helppage:\n");
		fprintf(stderr, "you must specify a name following '-toolbox'\n");
		gw_usage();
		exit(1);
		}
	}

}



