 /*
  * Khoros: $Id: check.c,v 1.2 1991/10/01 23:54:23 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: check.c,v 1.2 1991/10/01 23:54:23 khoros Exp $";
#endif

 /*
  * $Log: check.c,v $
 * Revision 1.2  1991/10/01  23:54:23  khoros
 * HellPatch2
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: check.c
 >>>>
 >>>>      Program Name: check
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	checks the dates on a program and prog file
 >>>>	
 >>>>	

 >>>>            Author: Danielle Argiro & Per Lysne
 >>>>
 >>>> Date Last Updated: Sat Sep 28 19:05:31 1991
 >>>>
 >>>>          Routines: main- the main program for check
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "check.h"


/****************************************************************
 *
 * Routine Name:  main program for check
 *
 *       Input:  
 *       -name  name of program to check 
 *
 *
 *       [-config] use configuration file?
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
char *script_file;
char *name, *config_flg;
char buffer[BUFSIZE];
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
if (check_args()) exit(1);

name = VStrcpy(check->name_string);

if ((check->config_logic) == 1)
   config_flg = "1";
else
   config_flg = "0";

/* Assign a filename to the shell script file */
script_file = "check_csh";

/* Build the buffer for the system call */
(void) sprintf(buffer, "%s %s %s\n", script_file, name, config_flg);

system(buffer);
/* -main_before_lib_call_end */

/* -main_library_call */
/* -main_library_call_end */

/* -main_after_lib_call */
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for check 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "check :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tchecks the dates on a program and prog file\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
fprintf(stderr, "\n\tThis program will check dates of files generated by and \n");
fprintf(stderr, "\tused by ghostreader & ghostwriter.  It will attempt to \n"); 
fprintf(stderr, "\tadvice as to which program (ghostreader or ghostwriter) \n");
fprintf(stderr, "\tshould be used first before making program modifications.\n\n");
/* -usage_additions_end */

	fprintf(stderr,"\t-name  name of program to check  (string)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-config]  use configuration file? (boolean) [false]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for check\n");
	fprintf(stderr, "\t[-U] Gives the usage for check\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called check.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses check.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for check
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*name_pstr = 
	"\nEnter: (name) name of program to check \n        {string}: "; 
char	*name_def = NULL;
char	*config_pstr = 
	"\nEnter: (config) use configuration file? \n        {boolean, (y/n)  [no] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "check", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "check.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "check: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "check.ans");
		}

	     }

	}

	/*
	 * allocate the check structure
	 */
	check = (check_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (check_struct));

	/*
	 * get required arguments for check
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(check->name_flag = vget_string(fid, prompt_flag,
			"-name", name_pstr, &(check->name_string),
			name_def)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(check->name_flag))
		{
		    fprintf(stderr, "\t\tname is required, please re-enter: \n");
		    check->name_flag = vget_string(fid, prompt_flag,
		    "-name", name_pstr, &(check->name_string),
		    name_def);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-name' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for check
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	check->config_flag = vget_logic(fid, prompt_flag,
	"-config", config_pstr, &(check->config_logic), 0);


}



