#! /bin/csh -f

# 
#  Khoros: $Id: vman.csh,v 1.6 1992/03/25 17:29:40 dkhoros Exp $
#

#
# $Log: vman.csh,v $
# Revision 1.6  1992/03/25  17:29:40  dkhoros
# VirtualPatch5
#
# Revision 1.4  1992/01/17  00:43:07  dkhoros
# HellPatch4
#
# Revision 1.3  1991/12/18  08:55:33  dkhoros
# HellPatch3
#
# 

#
#*----------------------------------------------------------------------
#*
#* Copyright 1990, University of New Mexico.  All rights reserved.
#*
#* Permission to copy and modify this software and its documen-
#* tation only for internal use in your organization is hereby
#* granted, provided that this notice is retained thereon and
#* on all copies.  UNM makes no representations as too the sui-
#* tability and operability of this software for any purpose.
#* It is provided "as is" without express or implied warranty.
#* 
#* UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
#* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
#* NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
#* INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
#* SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
#* IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
#* ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
#* FORMANCE OF THIS SOFTWARE.
#* 
#* No other rights, including for example, the right to redis-
#* tribute this software and its documentation or the right to
#* prepare derivative works, are granted unless specifically
#* provided in a separate license agreement.
#*---------------------------------------------------------------------
#

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */


#  >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
#  >>>>						       <<<<
#  >>>>	    file name: vman.csh			       <<<<
#  >>>>						       <<<<
#  >>>>   description: utility for khoros man pages
#  >>>>						       <<<<
#  >>>> modifications:					      <<<<
#  >>>>						       <<<<
#  >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< 

# FILE NAME:	vman.csh
# 
# AUTHORS:	Ron E. Neher & Tom Sauer
# 
# DATE:		2/10/88
# 
# DESCRIPTION:	a simple script that calls nroff to get an
#		khoros release 3 man page.  It will also printout
#		(via eroff) a man page.
# 
# MODIFICATIONS:
#	    Tue Jun  5 09:36:01 MDT 1990 - Tom Sauer
#	     vman will check the dates between man? and cat?, if man? is greater
#		then the man page is automatically reformatted. 
#	    3/19/91 - C.Gage modified to search in both KHOROS_HOME
#		      and KHOROS_CONTRIB for man pages.
#	     12/10/91 - removed KHOROS_CONTRIB
#	     12/10/91 - vman will check to make sure cat{1,3,n} is read
#			and writeable before continuing.
#	     1/9/91   - delete need for cat? directories and add complete
#			support for n man pages when -p used. (JMAS)
#		      - Added $NROFF variable. (JMAS)
#	     1/10/91  - added error checking on -k option (JMAS)
#		      - removed multiple if's by adding a foreach (JMAS)
#		      - allowed for multiple man pages to be specified (JMAS)
#	     2/12/92  - cd'ed the the man directory so the .so's will work
#			for relative paths (JMAS)
#		

if (! $?KHOROS_HOME ) then
   echo ""
   echo "vman: Error KHOROS_HOME environment variable is not set"
   echo ""
   exit 0 
endif

set include_list = ""

if ($?KHOROS_TOOLBOX) then
     set include_list = ( `cat $KHOROS_TOOLBOX | awk -F: '{ printf "%s/man  ", $2 }' ` )
     set include_list = `eval echo $include_list`
endif

set MANPATHS = ( $KHOROS_HOME/man $include_list )


set MANMACRO = "$KHOROS_HOME/man/utils/tmac/tmac.anc"

# NOTE: The formatter for printing is set for eroff.  You may
#	need to change this to the formatter of your choice.
#	For example, you may want to set FMT_ER to psroff.
#--------------------------------------------------------------
set FMT_ER = \ptroff
# NOTE: May want to define the exact path to nroff if it is some where strange.
#
#--------------------------------------------------------------
set NROFF = \nroff

if ( $?PAGER ) then
   set MORE = "$PAGER -s "
else
   set MORE = "more -s "
   set morepager
endif

set not_found = 1
set k_flg = 0
set p_flg = 0
set r_flg = 0
set sec_flg = 0
set name_flg = 0
set spname_sw = ""
set done = 0
@ i = 0
@ j = 1

umask 111

while ($#argv)
  switch($argv[1])
      case -p:
  	set p_sw = $argv[1]
  	set p_flg = 1
  	breaksw
      case -k:
  	set k_sw = $argv[1]
  	set k_flg = 1
  	breaksw
      case -r:
  	set r_sw = $argv[1]
  	set r_flg = 1
  	breaksw
      case -U:
  	goto usage
  	breaksw
      case -V:
  	goto version
  	breaksw
      case -[A-T]*:	# not valid switches
      case -[W-Z]*;
      case -[a-j]*:
      case -[l-o]*:
      case -[q-z]*:
  	goto usage
  	breaksw
      case 1:
      case 3:
      case n:
  	set spsec_sw = $argv[1]
  	set sec_flg = 1
  	breaksw
      default:
  	set spname_sw = `echo $spname_sw $argv[1]`
  	set name_flg = 1
  	breaksw
  endsw
  shift
end

if ($k_flg && $p_flg) goto usage
if ($k_flg && $sec_flg) goto usage
if (! $name_flg) goto usage

foreach name_sw ( $spname_sw )

 foreach MANPATH ($MANPATHS)

    if ( -d $MANPATH ) then
      cd $MANPATH
    endif

    if ($k_flg) then
      if ( -e $MANPATH/whatis ) then
	\grep -i $name_sw $MANPATH/whatis
# NOTE: Gross but it works.  I can not figure out how to do on OR in csh 8^(.
#
	if ( ! $status ) then
	  set not_found = "$not_found && 0"
	else
	  set not_found = "$not_found && 1"
	endif
      endif
    else
# NOTE: Be sure to change this if you add another man section.
#
      if (! $sec_flg) then
	set spsec_sw = `echo 1 3 n`
      endif

      foreach sec_sw ( $spsec_sw )

	if ($p_flg) then
	  set man_file = "$MANPATH/man$sec_sw/$name_sw.$sec_sw"

	  if ( -e $man_file) then
	    set EXIST_FMT = ( `which $FMT_ER` )
	    if ($#EXIST_FMT == 1) then
	      $FMT_ER $MANMACRO $man_file
	    else
# NOTE: You may want to change the name of the printer from lpr 
#	to the one that is used in your system.
##-------------------------------------------------------------
	      $NROFF $MANMACRO $man_file | lpr
	    endif
	    set done = 1
	  endif
	else if (-e $MANPATH/cat$sec_sw/$name_sw.$sec_sw && -e $MANPATH/man$sec_sw/$name_sw.$sec_sw) then
	    set list = `\ls -t $MANPATH/man$sec_sw/$name_sw.$sec_sw $MANPATH/cat$sec_sw/$name_sw.$sec_sw`
	    if ($list[1]:h == "$MANPATH/man$sec_sw") then
	      echo "Reformatting page.  Wait..."
	      if ( -d $MANPATH/cat$sec_sw && -w $MANPATH/cat$sec_sw && \
		   -r $MANPATH/cat$sec_sw && -x $MANPATH/cat$sec_sw ) then
		set out=$MANPATH/cat$sec_sw/$name_sw.$sec_sw
		set removetmp=0
	      else
		set out=/tmp/$name_sw.$sec_sw.$$
		set removetmp=1
	      endif
	      $NROFF $MANMACRO $MANPATH/man$sec_sw/$name_sw.$sec_sw > $out
	      $MORE $out
	      if ( $?morepager && $#spname_sw != 1 && \
		   $#spname_sw != $j && $#MANPATH != $i) then
	  	echo -n "[Hit Return for next man page]"
		set tmp=$<
	      endif
	      if ( $removetmp ) then
		\rm $out
	      endif
	      set done = 1
	   else if (! $r_flg && (-e $MANPATH/cat$sec_sw/$name_sw.$sec_sw)) then
	      $MORE $MANPATH/cat$sec_sw/$name_sw.$sec_sw
	      if ( $?morepager && $#spname_sw != 1 && \
		   $#spname_sw != $j && $#MANPATH != $i) then
		echo -n "[Hit Return for next man page]"
		set tmp=$<
	      endif
	      set done = 1
	   else
	      echo "Reformatting page.  Wait..."
	      if ( -d $MANPATH/cat$sec_sw && -w $MANPATH/cat$sec_sw && \
		   -r $MANPATH/cat$sec_sw && -x $MANPATH/cat$sec_sw ) then
		set out=$MANPATH/cat$sec_sw/$name_sw.$sec_sw
		set removetmp=0
	      else
		set out=/tmp/$name_sw.$sec_sw.$$
		set removetmp=1
	      endif
	      $NROFF $MANMACRO $MANPATH/man$sec_sw/$name_sw.$sec_sw > $out
	      $MORE $out
	      if ( $?morepager && $#spname_sw != 1 && \
		   $#spname_sw != $j && $#MANPATH != $i) then
		echo -n "[Hit Return for next man page]"
		set tmp=$<
	      endif
	      if ( $removetmp ) then
		\rm $out
	      endif
	      set done = 1
	   endif

	else if (-e $MANPATH/cat$sec_sw/$name_sw.$sec_sw) then
	  $MORE $MANPATH/cat$sec_sw/$name_sw.$sec_sw
	  if ( $?morepager && $#spname_sw != 1 && \
	       $#spname_sw != $j && $#MANPATH != $i) then
	    echo -n "[Hit Return for next man page]"
	    set tmp=$<
	  endif
	  set done = 1

	else if (-e $MANPATH/man$sec_sw/$name_sw.$sec_sw) then
	  echo "Reformatting page.  Wait..."
	  if ( -d $MANPATH/cat$sec_sw && -w $MANPATH/cat$sec_sw && \
		 -r $MANPATH/cat$sec_sw && -x $MANPATH/cat$sec_sw ) then
	    set out=$MANPATH/cat$sec_sw/$name_sw.$sec_sw
	    set removetmp=0
	  else
	    set out=/tmp/$name_sw.$sec_sw.$$
	    set removetmp=1
	  endif
	  $NROFF $MANMACRO $MANPATH/man$sec_sw/$name_sw.$sec_sw > $out
	  $MORE $out
	  if ( $?morepager && $#spname_sw != 1 && \
	       $#spname_sw != $j && $#MANPATH != $i) then
	    echo -n "[Hit Return for next man page]"
	    set tmp=$<
	  endif
	  if ( $removetmp ) then
	    \rm $out
	  endif
	  set done = 1
	endif
      end
    endif

    @ i++		  # increment MANPATH counter

  end	    # end of foreach MANPATH loop

  set i = 0

  @ j++		  # increment man counter

  if ( $k_flg && $not_found ) then
    echo ${name_sw}: nothing appropriate
  endif

  set not_found = 1
    
  if (! $done && ! $k_flg) then
    if ($sec_flg) then
      echo "No manual entry for $name_sw in section $sec_sw of the manual."
    else
      echo "No manual entry for $name_sw."
    endif
  endif

  set done = 0

end

cleanup:
    exit 0

usage:
    echo "vman: manual page information for khoros "
    echo ""
    echo "Usage: vman [-r | -U | -V] [section [-p ] | -k ] name"
    echo ""
    echo "  [-r]    reformats the man page"
    echo "  [-p]    sends the man page to a postscript printer"
    echo "  [-k]    searches for a keyword"
    echo "  [-U]    to get this message"
    echo "  [-V]    to find version"
    echo ""
    exit 1	# an error

version:
    source $KHOROS_HOME/repos/config/scripts/script_version
    set VERSION = $KHOROS_VERSION
    set RELEASE = $KHOROS_RELEASE
    echo ""
    echo "vman:  Khoros Release: Version $VERSION.$RELEASE"
    echo ""
    unset KHOROS_VERSION
    unset KHOROS_RELEASE
    exit 0

