 /*
  * Khoros: $Id: lvpolyco.c,v 1.2 1991/10/02 00:03:43 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lvpolyco.c,v 1.2 1991/10/02 00:03:43 khoros Exp $";
#endif

 /*
  * $Log: lvpolyco.c,v $
 * Revision 1.2  1991/10/02  00:03:43  khoros
 * HellPatch2
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lvpolyco.c
 >>>>
 >>>>      Program Name: vpolyco
 >>>>
 >>>> Date Last Updated: Fri Jul 19 15:10:03 1991 
 >>>>
 >>>>          Routines: lvpolyco - the library call for vpolyco
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lvpolyco - library call for vpolyco
*
* Purpose:
*    
* Input:
*    
* Output:
*    
*
* Written By: Scott Wilson
*    
****************************************************************/


/* -library_def */
int
lvpolyco(x,y,xp,yp,xc,yc,n)
float *x,*y,*xp,*yp,*xc,*yc;
int n;
/* -library_def_end */

/* -library_code */
{
  double *m,*bx,*by,*ipvt,px,py;
  int lda,k,info,job;
  int i,j,l,sqrtk;
  char *malloc();
  
  /* Find integer square root of k */
  k = n;
  for (sqrtk=0; sqrtk<1000; sqrtk++) if (k == sqrtk*sqrtk) break;
  if (sqrtk == 1000) 
    {
      fprintf(stderr,"lvpolyco: number of tiepoints must be the square of an integer!\n");
      return(0);
    }

  /* Allocate space for the temp arrays */
  m = (double *)malloc(k*k*sizeof(double));
  bx = (double *)malloc(k*sizeof(double));
  by = (double *)malloc(k*sizeof(double));
  ipvt = (double *)malloc(k*sizeof(double));
  if (m == NULL || bx == NULL || by == NULL || ipvt == NULL)
    {
      fprintf(stderr,"lvpolyco: Unable to allocate space for temporary arrays!\n");
      return(0);
    }

  /* Build the VanDermonde matrix */
  px = 1.0;
  py = 1.0;
  for (i=0; i<k; i++)
    {
      for (j=0; j<sqrtk; j++) 
        {
          for (l=0; l<sqrtk; l++)
            {
              m[i+(sqrtk*j+l)*k] = px*py;
              px *= x[i];
            }
          py *= y[i];
          px = 1.0;
        }
      py = 1.0;
      bx[i] = xp[i];
      by[i] = yp[i];
    }

  for (i=0; i<k; i++)
    {
      printf("%d: ",i);
      for (j=0; j<k; j++) printf("%g ",m[i*k+j]);
      printf("| %g | %g\n",bx[i],by[i]);
    }

  /* Set up the LINPACK parameters */
  lda = k;
  job = 0;

  /* Call DGEFA to get the LU decomposition of M */
  dgefa_(m,&lda,&k,ipvt,&info);

  /* Check for singular matrix */
  if (info != 0)
    {
      fprintf(stderr,"lvpolyco: matrix is singular\n");
      return(0);
    }

  /* Use DGESL to back-solve the triangular system for the coefficients */
  dgesl_(m,&lda,&k,ipvt,bx,&job);
  dgesl_(m,&lda,&k,ipvt,by,&job);

  /* Copy the computed coefficients back to thier homes */
  for (i=0; i<k; i++)
    {
      xc[i] = bx[i];
      yc[i] = by[i];
    }

  free(m);
  free(bx);
  free(by);
  free(ipvt);

  return(1);
}
/* -library_code_end */
