 /*
  * Khoros: $Id: lviff2big.c,v 1.1 1991/05/10 15:43:29 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lviff2big.c,v 1.1 1991/05/10 15:43:29 khoros Exp $";
#endif

 /*
  * $Log: lviff2big.c,v $
 * Revision 1.1  1991/05/10  15:43:29  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lviff2big.c
 >>>>
 >>>>      Program Name: viff2big
 >>>>
 >>>> Date Last Updated: Sat Mar  2 14:15:05 1991 
 >>>>
 >>>>          Routines: lviff2big - the library call for viff2big
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
#include "file_formats/big.h"
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lviff2big - library call for viff2big
*
* Purpose:
*    
*    Converts  VIFF file format to BIG image file format
*    
*    
* Input:
*    
*         struct xvimage *viff_image - input image to be converted
*    
*    
* Output:
*    
*         struct big **big_image - resulting big image.
*    
*    
*
* Written By: Mark Young, Tom Sauer
*    
*    Ghosted By Pascal ADAM   14-JUNE-90
*    
*    
****************************************************************/


/* -library_def */
int lviff2big(viff_image, big_image)

struct  xvimage *viff_image;
struct  big **big_image;
/* -library_def_end */

/* -library_code */
{

    struct big *new_big_image;

    char *program = "lviff2big";
    char *big_ptr, *img_ptr, *big_data;
   
    int nr, nc, bands, big_data_size;
    int i,j,k;
    double records;

    nr = viff_image->col_size;
    nc = viff_image->row_size;
    bands = viff_image->num_data_bands;

        /* check the input viff image to make sure it is in
         * a format that can be converted.
         * Must have 1 IMAGE in the file, must be of data storage
         * type BYTE and must have a map enable of OPTIONAL.
        */

    if (!propertype (program, viff_image, VFF_TYP_1_BYTE, FALSE)) {
        (void) fprintf (stderr,
        "%s: ERROR Input image must be of data type BYTE\n",program);
         return (0);
    }

    if (! (proper_num_images(program,viff_image,1,FALSE))) {
         (void) fprintf(stderr,
                 "%s: ERROR All inputs must contain only one image\n"
                 , program);
          return(0);
    }

    if (! (proper_map_enable(program,viff_image,VFF_MAP_OPTIONAL,FALSE))) {
         (void) fprintf(stderr,
                "%s: ERROR input must have map enable type OPTIONAL\n"
                ,program);
         return(0);
    }

            /* malloc room for the big image structure */

     if ((*big_image = (struct big *)malloc(sizeof(struct big)))==NULL)
     {
        (void) fprintf(stderr,"%s: No space for image, malloc failed!\n");
        return(0);
     }

       /* Allocate space for new big image data */

     records = ceil((double) viff_image->row_size/512.0);
     big_data_size = bands * nr * (int) records * 512 * sizeof(char);

     big_data = (char *)malloc((unsigned int) big_data_size);
     if (big_data == NULL) {
        (void) fprintf(stderr,"%s: insufficient memory available\n", program);
         return(0);
     }

     bzero(big_data, big_data_size);
     new_big_image = *big_image; 

       /* set the header fields */

     if ( bands <= 3) 
          new_big_image->data_type = 'S'; /* SPOT data */
     else
          new_big_image->data_type = 'L'; /* MSS data */
 
     new_big_image->num_channels = bands;   /* number of bands */
     new_big_image->start_line_num = 0;
     new_big_image->start_pixel_num = 0;
     new_big_image->num_lines = viff_image->col_size; /* number rows */
     new_big_image->num_pixels_line = viff_image->row_size; /* num columns */
     new_big_image->records_line = (short) records;   /* num records per line */

     if ( viff_image->comment != NULL)
     {
        strncpy(new_big_image->title, viff_image->comment, 80);
     }

       /* load the data into the big data structure.
        * This uses band-interleaved-by-line format.
        * All lines or rows of data must be on 512
        * byte boundries, so pad to the end of
        * a record if necessary
        */

      big_ptr = big_data;
      img_ptr = viff_image->imagedata;

      for ( i = 0; i < nr; i++) {
        for ( j = 0; j < bands; j++) {
          for ( k = 0; k < nc; k++) {
            *big_ptr = img_ptr[ (j * nr * nc) + k + (i * nc) ];
            big_ptr++;
          }
            /* must pad to 512 byte records */
          big_ptr = big_ptr + (512 * ((int) records) - nc); 
        }
      }


    (*big_image)->imagedata = big_data;
    return(1);

}
/* -library_code_end */
