 /*
  * Khoros: $Id: lelasinfo.c,v 1.1 1991/05/10 15:43:29 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lelasinfo.c,v 1.1 1991/05/10 15:43:29 khoros Exp $";
#endif

 /*
  * $Log: lelasinfo.c,v $
 * Revision 1.1  1991/05/10  15:43:29  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lelasinfo.c
 >>>>
 >>>>      Program Name: elasinfo
 >>>>
 >>>> Date Last Updated: Tue Mar 12 16:08:54 1991 
 >>>>
 >>>>          Routines: lelasinfo - the library call for elasinfo
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
#include "file_formats/elas.h"
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lelasinfo - library call for elasinfo
*
* Purpose:
*    
*    Reads and prints an ELAS file format header.
*    
*    
* Input:
*    
*         ELAS *elas_image - pointer to elas image structure
*    
*         int elas_fid - file descriptor
*    
*         char *input_file - input file name
*    
*    
* Output:
*    
*         FILE *printdev - output ascii file
*    
*    
*
* Written By: Charlie Gage
****************************************************************/


/* -library_def */
int lelasinfo(elas_image, elas_fid, input_file, printdev)

ELAS *elas_image;
int  elas_fid;
char *input_file;
FILE *printdev;
/* -library_def_end */

/* -library_code */
{
  char *program = "lelasinfo";
   
  (void) fprintf(printdev,"\nFile Name: %s\n", input_file);
  (void) fprintf(printdev,"\nFile Type: ELAS image file\n");
  (void) fprintf(printdev,"Number of bytes in header: %d\n", elas_image->num_hdr_bytes);
  (void) fprintf(printdev,"Number of bytes per record: %d\n", elas_image->num_bytes_record);
  (void) fprintf(printdev,"Initial line (IL): %d\n", elas_image->init_line);
  (void) fprintf(printdev,"Last line (LL): %d\n", elas_image->last_line);
  (void) fprintf(printdev,"Initial Element of line (IE): %d\n", elas_image->init_elem_scan_line);
  (void) fprintf(printdev,"Last Element of line (LE): %d\n", elas_image->last_elem_scan_line);
  (void) fprintf(printdev,"Number of Channels (bands): %d\n", elas_image->num_channels);
  (void) fprintf(printdev,"Header record ID: %d\n", elas_image->header_id);
  (void) fprintf(printdev,"Y-axis Grid descriptor: %s\n", elas_image->grid_desc_y);
  (void) fprintf(printdev,"X-axis Grid descriptor: %s\n", elas_image->grid_desc_x);
  (void) fprintf(printdev,"Y-offset: %d\n", elas_image->y_offset);
  (void) fprintf(printdev,"X-offset: %d\n", elas_image->x_offset);
  (void) fprintf(printdev,"Y spot size: %f\n", elas_image->y_spot_size);
  (void) fprintf(printdev,"X spot size: %f\n", elas_image->x_spot_size);
  (void) fprintf(printdev,"Transformation Matrix Coordinates:\n");
  (void) fprintf(printdev,"\t(IL, LL, IE, LE)\n");
  (void) fprintf(printdev,"\t(%f, %f, %f, %f)\n", elas_image->trans_matrix_il, elas_image->trans_matrix_ll, elas_image->trans_matrix_ie, elas_image->trans_matrix_le);
  (void) fprintf(printdev,"Eikonix: %d\n", elas_image->eikonix);
  (void) fprintf(printdev,"LABL: %d\n", elas_image->labl);
  (void) fprintf(printdev,"Head: %s\n", elas_image->head);
  (void) fprintf(printdev,"Comments: %s\n", elas_image->comments);
  (void) fprintf(printdev,"\n\n");

  close(elas_fid);
  return(1);
}

/* -library_code_end */
