 /*
  * Khoros: $Id: dfilter.c,v 1.2 1992/03/20 23:30:58 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: dfilter.c,v 1.2 1992/03/20 23:30:58 dkhoros Exp $";
#endif

 /*
  * $Log: dfilter.c,v $
 * Revision 1.2  1992/03/20  23:30:58  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1992, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1992 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: dfilter.c
 >>>>
 >>>>      Program Name: dfilter
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	filters signals according to a transfer function
 >>>>	
 >>>>	

 >>>>            Author: Jeremy Worley
 >>>>
 >>>> Date Last Updated: Thu Mar  5 09:39:26 1992
 >>>>
 >>>>          Routines: main- the main program for dfilter
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "dfilter.h"


/****************************************************************
 *
 * Routine Name:  main program for dfilter
 *
 *       Input:  
 *         -i1  input signal file (xviff file) 
 *         -i2  input filter file (polynomial file) 
 *         -o  resulting filtered signal file (xviff file) 
 *
 *
 *         [-j] scalar processing (0) or vector processing (1)
 *         [-d] data processing direction (0 = down vectors, 1 = across bands)
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
  struct xvimage *image=NULL, *readimage();
  struct poly_struct *poly = NULL;
  int createpoly(), readpoly(), check_args(), propertype(), 
      proper_num_images(), proper_map_enable(), ldfilter(), writeimage();
  int npolys,proc_dir;
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
  if (check_args()) exit(1);
  READIMAGE(image);
  CHECKTYPE(program,image);
  CHECKINPUT(program,image);

  proc_dir = dfilter->d_logic;

  if(!createpoly(&poly,MAXPOLYS,MAXTERMS,MAXSTAGES,STRMAX)){
     fprintf(stderr,"%s:  failure to create polynomial.\n",program);
     exit(1);
  }

  if(!readpoly(dfilter->i2_file,poly,MAXPOLYS,&npolys)){
     fprintf(stderr,"%s:  failure to read polynomial file.\n",program);
     exit(1); 
  }
/* -main_before_lib_call_end */

/* -main_library_call */
  if(!ldfilter(image,poly,proc_dir)){
     fprintf(stderr,"%s:  ldfilter failed.\n",program);
     exit(1);
  }
/* -main_library_call_end */

/* -main_after_lib_call */
 writeimage(dfilter->o_file,image);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for dfilter 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "dfilter :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tfilters signals according to a transfer function\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i1  input signal file (xviff file)  (infile)\n");
	fprintf(stderr,"\t-i2  input filter file (polynomial file)  (infile)\n");
	fprintf(stderr,"\t-o  resulting filtered signal file (xviff file)  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-j]  scalar processing (0) or vector processing (1) (boolean) [true]\n");
	fprintf(stderr,"\t[-d]  data processing direction (0 = down vectors, 1 = across bands) (boolean) [true]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for dfilter\n");
	fprintf(stderr, "\t[-U] Gives the usage for dfilter\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called dfilter.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses dfilter.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for dfilter
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i1_pstr = 
	"\nEnter: (i1) input signal file (xviff file) \n        {infile}: "; 
char	*i2_pstr = 
	"\nEnter: (i2) input filter file (polynomial file) \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) resulting filtered signal file (xviff file) \n        {outfile}: "; 
char	*j_pstr = 
	"\nEnter: (j) scalar processing (0) or vector processing (1) \n        {boolean, (y/n)  [yes] }: "; 
char	*d_pstr = 
	"\nEnter: (d) data processing direction (0 = down vectors, 1 = across bands) \n        {boolean, (y/n)  [yes] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "dfilter", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "dfilter.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "dfilter: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "dfilter.ans");
		}

	     }

	}

	/*
	 * allocate the dfilter structure
	 */
	dfilter = (dfilter_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (dfilter_struct));

	/*
	 * get required arguments for dfilter
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(dfilter->i1_flag = vget_infile(fid, prompt_flag,
			"-i1", i1_pstr, &(dfilter->i1_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(dfilter->i1_flag))
		{
		    fprintf(stderr, "\t\ti1 is required, please re-enter: \n");
		    dfilter->i1_flag = vget_infile(fid, prompt_flag,
		    "-i1", i1_pstr, &(dfilter->i1_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i1' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(dfilter->i2_flag = vget_infile(fid, prompt_flag,
			"-i2", i2_pstr, &(dfilter->i2_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(dfilter->i2_flag))
		{
		    fprintf(stderr, "\t\ti2 is required, please re-enter: \n");
		    dfilter->i2_flag = vget_infile(fid, prompt_flag,
		    "-i2", i2_pstr, &(dfilter->i2_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i2' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(dfilter->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(dfilter->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(dfilter->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    dfilter->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(dfilter->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for dfilter
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	dfilter->j_flag = vget_logic(fid, prompt_flag,
	"-j", j_pstr, &(dfilter->j_logic), 1);

	dfilter->d_flag = vget_logic(fid, prompt_flag,
	"-d", d_pstr, &(dfilter->d_logic), 1);


}



