 /*
  * Khoros: $Id: ldmirror.c,v 1.2 1992/03/20 23:28:15 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: ldmirror.c,v 1.2 1992/03/20 23:28:15 dkhoros Exp $";
#endif

 /*
  * $Log: ldmirror.c,v $
 * Revision 1.2  1992/03/20  23:28:15  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: ldmirror.c
 >>>>
 >>>>      Program Name: dmirror
 >>>>
 >>>> Date Last Updated: Wed Feb 19 09:40:24 1992 
 >>>>
 >>>>          Routines: ldmirror - the library call for dmirror
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/* -library_includes_end */


/****************************************************************
*
* Routine Name: ldmirror - library call for dmirror
*
* Purpose:
*    
*    1D Create Mirror of Data. Points added to the  left  of  the
*    first data point.
*    
*    

* Input:
*    
*    image          (struct xvimage) - the input/output xvimage struc-
*                   ture
*    
*    arith_type     (int) - flag indicating whether to perform complex
*                   conjugate or scalar mirror on complex data
*    
*    process_dir    (int) - direction of data  processing:  DSP_VECTOR
*                   or DSP_BAND.
*    
*    

* Output:
*    
*    image          (struct xvimage) - the input/output xvimage struc-
*                   ture.   Since image is used for both the input and
*                   the output, be careful not to overwrite  important
*                   data.
*    
*    

*
* Written By: Donna Koechner, Ramiro Jordan
*    
*    Jeremy Worley 19 Feb 1992 09:39 MST
*                                  added   explicit   declaration   of
*                                  dunload_vector().
*    
*    

****************************************************************/


/* -library_def */
int 
ldmirror ( image, arith_type, process_dir )

int             arith_type, process_dir;
struct xvimage  *image;
/* -library_def_end */

/* -library_code */
{
  int   
        num_vects,      /* number vectors from load_vector (nc * nr) */
        dimension,      /* vector dimension from load_vector (# bands) */
        end_dim,        /* total number of points in output vectors */
        data_type,      /* 1=FLOAT, 2=COMPLEX -- used as a scale factor */
        end,
        i, j;

  float **data,         /* vectorized image file */
        **mirror;       /* mirrored file (vectorized) */

  char  **dload_vector(),
        *malloc();

  int   propertype(),dunload_vector();

  if( ! (propertype("ldmirror",image,VFF_TYP_FLOAT,FALSE)) && 
      ! (propertype("ldmirror",image,VFF_TYP_COMPLEX,FALSE)) ) { 
      fprintf(stderr,"ldmirror: data storage type must be float or complex.\n");
      return(0);
  }

 /*
  * Set data type to 1 if data is real, 2 if data is complex.
  */
  data_type = 1;
  if (image->data_storage_type == VFF_TYP_COMPLEX )
  {
    data_type = 2;
  }

  if ( (data = (float **)dload_vector(image, &num_vects, &dimension, 
               process_dir) ) == NULL)
  {
    (void) fprintf(stderr,"dmirror: dload_vector failed \n");
    return(0);
  }

  dimension *= data_type;

 /*
  * Calculate dimension of mirrored vectors and the resulting size of
  * the output file.
  */
  end_dim = (dimension * 2) - data_type;
  end = dimension - data_type;

 /*
  * Allocate for the new mirror array. 
  */
  if ( (mirror = (float **) (malloc ((unsigned int) num_vects * 
        sizeof(float))) ) == NULL)
  {
    (void) fprintf(stderr,"ldmirror: Cannot allocate mirror array.\n");
    return(0);
  }
  for (i=0; i<num_vects; i++)
  {
    if ((mirror[i] = (float *) (malloc ((unsigned int) end_dim * 
         sizeof(float) ))) == NULL)
    {
      (void)fprintf(stderr,"ldmirror: Cannot alloc mirror array.\n");
      return(0);
    }
  }
   
  switch ( image->data_storage_type )
  {
    case VFF_TYP_FLOAT:

          for ( i = 0; i < num_vects; i++ )
          {
            for (j = 0; j < end ; j++)
            {
              mirror[i][j] = data[i][end-j];
            }
            for ( j=end ; j < end_dim; j++ )
            {
              mirror[i][j] = data[i][j-end];
            }
          }
          break;

    case VFF_TYP_COMPLEX:
         
         for ( i = 0; i < num_vects; i++ )
         {
           for (j = 0; j < end ; j++)
           {
             /* create real part */
             mirror[i][j] = data[i][end-j];
             j++;

             /* create imaginary part */
             if (arith_type == 0)       /* scalar */
             {
               mirror[i][j] = data[i][dimension -j];
             }
             else if (arith_type == 1)  /* complex conjugate */
             {
               mirror[i][j] = -data[i][dimension -j];
             }

           }

           for ( j=end; j<end_dim; j++)
           {
             mirror[i][j] = data[i][j-end];
             j++;
             mirror[i][j] = data[i][j-end];
           }
         }
         break;

    default:

         (void) fprintf(stderr,"ldmirror: Invalid data storage type\n");
         (void) fprintf(stderr,"Can only operate on FLOAT or COMPLEX\n");
         return(0);
         /* break; commented out as a matter of principle */

  }  /* end case statement */

  end_dim /= data_type;

 /* 
  * Call dunload vector to rearrange imagedata to correct format.
  */
  if (!dunload_vector( (char **) mirror, image, image->data_storage_type, 
                      num_vects, end_dim, process_dir)) 
  {
    (void)fprintf(stderr,"ldmirror: dunload_vector failed!\n");
    return(0);
  }

  for (i=0; i<num_vects; i++)
  {
    free((char*)data[i]);
    free((char*)mirror[i]);
  }
  free((char**)data);
  free((char**)mirror);

  return(1);
} 

/* -library_code_end */
