 /*
  * Khoros: $Id: enter_arg.c,v 1.2 1991/10/02 00:32:37 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: enter_arg.c,v 1.2 1991/10/02 00:32:37 khoros Exp $";
#endif

 /*
  * $Log: enter_arg.c,v $
 * Revision 1.2  1991/10/02  00:32:37  khoros
 * HellPatch2
 *
  */ 

/******************************************************************

	Enter an Answer File Argument into the Linked List

	source filename:			enter_arg.c

	revision	  date			programmer
	--------	  ----			----------
	   0.0		Jan-05-85		don hush

******************************************************************

	usage
	-----

	enter_arg(key,sarg)

	char *key,*sarg;

	description
	-----------

	  This routine makes an entry in a sorted linked list
	for the key,sarg pair and then inserts them into the list.

******************************************************************/

#include "vgparm.h"

enter_arg(key,sarg)

char *key,*sarg;

{
	extern int num_args;
	extern ARG_ENTRY first;

	ARG_ENTRY *current,*prev,*new;

	new = (ARG_ENTRY *) malloc(sizeof(ARG_ENTRY));
	if(new == NULL) {
            fprintf(stderr,"\nERROR-enter_arg cannot allocate more memory\n");           
            exit(1);
        }

	prev = &first;
	current = first.next;

	while (current!=NULL) {
		if (strcmp(key,current->key)<=0)
			break;
		prev = current;
		current = current->next;
	}

	new->next = current;
	prev->next = new;

	strcpy(new->key,key);
	strcpy(new->sarg,sarg);

	num_args++;

}
