 /*
  * Khoros: $Id: expr.h,v 1.1 1991/05/10 15:41:00 khoros Exp $
  */

 /*
  * $Log: expr.h,v $
 * Revision 1.1  1991/05/10  15:41:00  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 * 
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *----------------------------------------------------------------------
 */


/*******  #Includes, #Defines, and Global variables & declarations ****/
  
#ifndef _expr_h_
#define _expr_h_

#include	"unmcopyright.h"	 /* Copyright 1990 by UNM */
#include	"vinclude.h"	
#include	"xvparser.h"


#define Value	    u.value
#define Operator    u.operator
#define Instruction u.instruction
#define Function    u.function
#define String	    u.string

/*
 *  The following definition is used to define a single token.
 *  Such as the definition of x, or the definition of a function, etc.
 */

typedef struct _symbol
{
	char *name;
	int  type;
	unsigned char eval, num;
	struct _symbol_list *symlist;
	union
	{
	   double value;
	   char   *string;
	   int    operator;
	   int    instruction;
	   double (*function)();
	} u;

} Symbol;

typedef struct _symbol_list
{
	Symbol *symbol;
	struct _symbol_list *next;

} SymbolList;

typedef struct _varlist
{
	long	   id;
	SymbolList *symlist;
	struct _varlist *next, *parent;

} Varlist;

Symbol  *_xve_get_symbol();
Symbol  *_xve_add_symbol();
Varlist *_xve_get_varlist();

jmp_buf		jump_dest;
char		*sptr, *string_array, xve_error[1024];

#define	GLOBAL_ID   -1
#define	FUNCTION_ID -2
#define	CONSTANT_ID -3
int	CURRENT_ID;

Symbol FinalValue;

/*
 *  Kludge to allow you to use more than one lex & yacc parser when compiling
 *  within the khoros system.
 */

/* re-define routines */
#define yyparse	      expr_parse
#define yylex	      expr_lex
#define yyerror	      expr_error

/* re-define structures & variables */
#define yylval	      expr_lval
#define yyval	      expr_val
#define yyv	      expr_v
#define yychar	      expr_char
#define yyerrflag     expr_errflag
#define yyexca	      expr_exca
#define yyact	      expr_act
#define yypact	      expr_pact
#define yypgo	      expr_pgo
#define yyr1	      expr_r1
#define yyr2	      expr_r2
#define yychk	      expr_chk
#define yydef	      expr_def
#define yynerrs	      expr_nerrs
#define yysptr	      expr_sptr
/*
#define yyin	      expr_in
#define yyout	      expr_out
#define yysvec	      expr_svec
#define yybgin	      expr_bgin
 */
#define yylineno      expr_lineno
#define yyprevious    expr_previous
#define yylook	      expr_look
#define yyvstop	      expr_stop
#define yycrank	      expr_crank
#define yytop	      expr_top
#define yymatch	      expr_match
#define yyextra	      expr_extra
#define yyback	      expr_back
#define yyinput	      expr_input
#define yyoutput      expr_output
#define yyunput	      expr_unput

#endif
/* Dont' add after this point */
