 /*
  * Khoros: $Id: propersize.c,v 1.1 1991/05/10 15:40:47 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: propersize.c,v 1.1 1991/05/10 15:40:47 khoros Exp $";
#endif

 /*
  * $Log: propersize.c,v $
 * Revision 1.1  1991/05/10  15:40:47  khoros
 * Initial revision
 *
  */ 

/*
#
# FILE NAME:	propersize.c
# 
# AUTHORS:	Tom Sauer, John Rasure
#               Modified from code done origianlly by Marcelo Teran
# 
# DATE:		2/6/89
# 
# DESCRIPTION:	Contains module propersize().
# 
# MODIFICATIONS:
#		John Rasure modified error messages.
#		Sat Jun  2 23:59:07 MDT 1990
# 
# ROUTINES:	propersize()
#		
*/

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.

 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */

#include "vinclude.h"	  


/**************************************************************
*
* MODULE NAME: 	propersize()
*
*     PURPOSE:	Check to see if viff data is of the correct size. 
*
*       INPUT:  prog 	- program name
*		*image	- viff data
*		proper_col_size - desired col_size
*		proper_row_size - desired row_size
*		exit_flag
*
*      OUTPUT:  If exit_flag is true and match fails, an error 
*          	message is printed.
*      		If exit_flag is false and match fails, return(0).
*
*       USAGE:	If exit_flag is set, The routine will print out an
*		error message and then exit().  In this case, the
*		function should be declared (void).  If exit_flag
*               is not set (equal 0) then the function should be
*		declared int.
*
*
**************************************************************/
propersize(prog,image,proper_col_size,proper_row_size,exit_flag)
char  *prog;
struct xvimage *image;
unsigned long proper_col_size, proper_row_size;
int exit_flag;
{
    if( ! (image->col_size==proper_col_size 
	     && image->row_size==proper_row_size) ){
	if (exit_flag == TRUE) {
		(void) fprintf(stderr,"\nError in program %s.\n",prog);
		(void) fprintf(stderr,
"The viff data is the incorrect size for this program.\n");
		(void) fprintf(stderr,
"The viff data should be: %d rows by %d columns.\n",proper_col_size,proper_row_size);
		(void) fprintf(stderr,
"BUT is: %d rows by %d columns.\n",image->col_size,image->row_size);
		exit(1);
	}
	else return(0);
    }
return(1);
}
