 /*
  * Khoros: $Id: lvrast.h,v 1.1 1991/05/10 04:14:48 khoros Exp $
  */

 /*
  * $Log: lvrast.h,v $
 * Revision 1.1  1991/05/10  04:14:48  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                        <<<<
   >>>>	    file name: lvrast.h                                <<<<
   >>>>                                                        <<<<
   >>>>      contains: Defines the LINE and INTERSECTION       <<<<
   >>>>                data structures needed for the bilinear <<<<
   >>>>		       raster fill routines		       <<<<
   >>>>                                                        <<<<
   >>>>      written by: Scott R. Wilson		       <<<<
   >>>>                                                        <<<<
   >>>>      date: 10/29/88                                    <<<<
   >>>>                                                        <<<<
   >>>>      modifications:				       <<<<
   >>>>                                                        <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _vrast_h_
#define _vrast_h_


struct line
  {
    int x1,y1;      /* Input plane point #1 */
    int x2,y2;      /* Input plane point #2 */
    float wx1,wy1;  /* Output plane point #1 */
    float wx2,wy2;  /* Output plane point #2 */
    float i1;       /* Input plane intensity at point #1 */
    float i2;       /* Input plane intensity at point #2 */
  };

struct intersection
  {
    struct line *seg;    /* Which segment has an intersection */
    float x,y;           /* Where we hit */
    float inten;         /* Interpolated intensity where we hit */
  };

float intrp();		/* Intrp returns a float! */

#endif
/* Don't add after the endif */
