/*****************************************************************************
* Default fatal error handler for the irit parser.			     *
*									     *
* Written by:  Gershon Elber				Ver 0.2, April 1993  *
*****************************************************************************/

#include <stdio.h>
#include "irit_sm.h"
#include "iritprsr.h"
#include "allocate.h"
#include "attribut.h"

/*****************************************************************************
* DESCRIPTION:                                                               M
* Default trap for Irit parser errors.					     M
*   This function prints the provided error message anddies.		     M
*                                                                            *
* PARAMETERS:                                                                M
*   Msg:      Error message.                                                 M
*                                                                            *
* RETURN VALUE:                                                              M
*   void                                                                     M
*                                                                            *
* KEYWORDS:                                                                  M
*   IritPrsrFatalError , error handling                                      M
*****************************************************************************/
void IritPrsrFatalError(char *Msg)
{
    fprintf(stderr, "IP: %s\n", Msg);

    exit(-1);
}
