#ifdef VMS
#include <decw$include/Intrinsic.h>
#else /* UNIX */
#include <X11/Intrinsic.h>
#endif
#include "defs.h"
#include "xws_defs.h"

#define	DOT_MARKER	'.'
#define PLUS_MARKER	'+'
#define ASTERISK_MARKER '*'
#define CIRCLE_MARKER	'o'
#define CROSS_MARKER	'x'

/* Polymarker Graphical Primitive Element routines */

static char		MarkerType = ASTERISK_MARKER;	/* default marker */
static unsigned short	MarkerSize = DEFAULT_MARKER_SIZE;

/* Set marker type */

xws_mk_type(marker)
int	marker;
{
	switch (marker) 
	{
	case 1 : MarkerType = DOT_MARKER;	break;
	case 2 : MarkerType = PLUS_MARKER;	break;
	case 3 : MarkerType = ASTERISK_MARKER;	break;
	case 4 : MarkerType = CIRCLE_MARKER;	break;
	case 5 : MarkerType = CROSS_MARKER;	break;
	default:
		MarkerType = ASTERISK_MARKER;
		return(GPLOT_INVALID_PARAMETER);
	}
	return(GPLOT_SUCCESS);
}

/* Set marker color */

xws_mk_colour(r, g, b, index)
float	r, g, b;
int	index;
{

	XSetForeground(Dpy, MarkerGC, 
		(*xws_get_pixel)(r, g, b, index));
	return(GPLOT_SUCCESS);
}

/* Set marker size */

/*ARGSUSED*/
xws_mk_size(absolute, scaled)
int	absolute;
float	scaled;
{
	MarkerSize = (absolute > 0) ? absolute : DEFAULT_MARKER_SIZE;
	return((absolute > 0) ? GPLOT_SUCCESS : GPLOT_INVALID_PARAMETER);
}
/* Draw polymarkers */

#define MAX_ARCS	16

/* "If the marker position is outside the clipping rectangle, nothing is 
 * diplayed." CGM standard, p. 62.  Since gplot does not take responsibility,
 * this driver code clips markers when the marker position is outside the
 * window.
 */

xws_pmarker(point_count, x, y)
int	point_count;
int	x[], y[];
{
register int	n, p;
short	left_x, middle_x, right_x, upper_y, middle_y, lower_y;
XArc	arcs[MAX_ARCS];


    n = 0;

    switch (MarkerType)
    {
    case DOT_MARKER:
        while (n < point_count)
        {
	    for(p=0; (n < point_count) && (p < MAX_POINTS); n++)
	    {
		if (x[n] < 0 || x[n] > MaxX || y[n] < 0 || y[n] > MaxY)
			continue;
        	Points[p].x = (short) x[n];
        	Points[p++].y = (short) (MaxY - y[n]);
	    }
	    if (p)	/* we may have clipped all the markers */
		    XDrawPoints(Dpy, Win, MarkerGC, Points, p, CoordModeOrigin);
        }
	break;

    default:	/* CGM specifies the asterisk as the default marker type */
	MarkerType = ASTERISK_MARKER;
	/* falls through */
    case ASTERISK_MARKER:
    case CROSS_MARKER:
    case PLUS_MARKER:
        while (n < point_count)
        {
    	    for (p=0; (n < point_count) && (p < MAX_SEGMENTS); n++)
    	    {
		if (x[n] < 0 || x[n] > MaxX || y[n] < 0 || y[n] > MaxY)
			continue;
		middle_x = (short) x[n];
		left_x = middle_x - MarkerSize / 2;
		right_x = left_x + MarkerSize;
		middle_y = (short) (MaxY - y[n]);
		upper_y = middle_y - MarkerSize / 2;
		lower_y = upper_y + MarkerSize;

		if (MarkerType == ASTERISK_MARKER || MarkerType == CROSS_MARKER)
		{
	    		/* \ */
		    Segments[p].x1 = left_x;
		    Segments[p].y1 = upper_y;
		    Segments[p].x2 = right_x;
		    Segments[p].y2 = lower_y;
		    p++;
			/* / */
		    Segments[p].x1 = right_x;
		    Segments[p].y1 = upper_y;
		    Segments[p].x2 = left_x;
		    Segments[p].y2 = lower_y;
		    p++;
		}

		if (MarkerType == ASTERISK_MARKER || MarkerType == PLUS_MARKER)
		{
            		/* | */
		    Segments[p].x1 = Segments[p].x2 = middle_x;
		    Segments[p].y1 = upper_y;
		    Segments[p].y2 = lower_y;
		    p++;
		}

		if (MarkerType == PLUS_MARKER)
		{
			/* - */
		    Segments[p].x1 = left_x;
		    Segments[p].x2 = right_x;
		    Segments[p].y1 = Segments[p].y2 = middle_y;
		    p++;
		}
	    }
	    if (p)	/* we may have clipped all the markers */
		    XDrawSegments(Dpy, Win, MarkerGC, Segments, p);
	  }
	break;

    case CIRCLE_MARKER:
	while (n < point_count)
	{
	    for(p=0; (n < point_count) && (p < MAX_ARCS); n++)
	    {
		if (x[n] < 0 || x[n] > MaxX || y[n] < 0 || y[n] > MaxY)
			continue;
		arcs[p].x = (short) x[n] - MarkerSize / 2;
		arcs[p].y = (short) (MaxY - y[n]) - MarkerSize / 2;
		arcs[p].width = arcs[p].height = MarkerSize;
		arcs[p].angle1 = 0;
		arcs[p++].angle2 = 360 * 64;
	    }
	    if (p)	/* we may have clipped all the markers */
		    XDrawArcs(Dpy, Win, MarkerGC, arcs, p);
	}
	break;
    }

    return(GPLOT_SUCCESS);
}
