#ifndef HLINE3DEF
#define HLINE3DEF

#define HLN3_POINT_FORM -1
#define HLN3_PLANE_FORM  1
#define HLN3_DUAL_FORM(f) (-(f))

typedef struct { 
    float L[4][4];
    int type;
} HLine3;

extern HLine3 *HLn3Create();
extern void HLn3Delete(/* HLine3 *ln */);

extern void HLn3Print(/* HLine3 *ln */);
extern void HLn3Copy(/* HLine3 *ln1, *ln2 */);
extern int HLn3From2HPt3s(/* HLine3 *ln, HPoint3 *pt1, *pt2 */);
extern int HLn3From2HPl3s(/* HLine3 *ln, HPlane3 *pl1, *pl2 */);

extern int HLn3IntersectHPt3(/* HLine3 *ln, HPoint3 *pt, HPlane3 *pl */);
extern int HLn3IntersectHPl3(/* HLine3 *ln, HPlane3 *pl, HPoint3 *pt */);
extern int HLn3IntersectHLn3(/* HLine3 *lnpl, *lnpt, HPlane3 *pl, HPoint3 *pt */);

extern int HLn3Undefined(/* HLine3 *ln */);
extern int HLn3Infinity(/* HLine3 *ln */);
extern int HLn3Compare(/* HLine3 *ln1, *ln2 */);

extern int HLn3CoincidentHPt3(/* HLine3 *ln, HPoint3 *pt */);
extern int HLn3CoincidentHLn3(/* HLine3 *ln1, *ln2 */);
extern int HLn3CoincidentHPl3(/* HLine3 *ln, HPlane3 *pl */);

extern void HLn3Transform(/* Transform3 T, HLine3 *ln1, *ln2 */);

extern void HLn3Dual(/* HLine3 *ln, *lndual */);

extern void HLn3Perp(/* HLine3 *ln, *lnperp */);

#endif
