/* SCCS @(#)select3planeI.layout.c	1.1  12/2/92 */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/*                       select3planeI.layout.c                         */
/*                                                                      */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/* FILENAME     :   select3planeI.layout.c                              */
/*                                                                      */
/* DESCRIPTION  :   3 Input planes                                      */
/*                                                                      */
/* AUTHORS      :   Marianne Logean                                     */
/*                                                                      */
/* VERSION      :   1.0                                                 */
/*                                                                      */
/* HISTORY      :   1.12.92                                             */
/*                  MAL         Created    version: 1.0                 */
/*                                                                      */
/* Copyright  1992 by CUI/UIN/HCUG, All rights reserved.                */
/*                                                                      */
/************************************************************************/
/************************************************************************/

#include "select3planeI.layout.h"
#include "widgetstructure.h"

#define MAX_ARGS 100

extern XmFontList gFontlist; 
extern Pixel      gorchid, gthistle;

/********************************************************
/   Creation Function for Selection3Planes 
/*******************************************************/

Widget
build_Selection3Planes(select3planeinput, IO_load_image_plane_OK, message1, message2, message3)
	Widget select3planeinput;
	Widget IO_load_image_plane_OK;
        char *message1;
        char *message2;
        char *message3;
{
	Widget Selection3Planes;
	Widget Select3Plane0;
	Widget Select3Plane1;
	Arg args[MAX_ARGS];
	int n;

	/* Creating Selection3Planes Widget */ 

	n = 0;
	XtSetArg(args[n],XmNx,1); n++;

	Selection3Planes = 
		XmCreateRowColumn(select3planeinput,"Selection3Planes",args,n);
	XtManageChild(Selection3Planes);

	/* Creating Select3Plane0 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[73],
			XmSTRING_DEFAULT_CHARSET)); n++;

	Select3Plane0 = XmCreateLabel(Selection3Planes,"Select3Plane0",args,n);
	XtManageChild(Select3Plane0);

	/* Creating Select3Plane1 Widget */ 

	Select3Plane1 = 
	      build_Select3Plane1(Selection3Planes, 
		      IO_load_image_plane_OK, message1, message2, message3);

	return(Selection3Planes);
}


/********************************************************
/   Creation Function for Select3Plane1 
/*******************************************************/

Widget
build_Select3Plane1(Selection3Planes, IO_load_image_plane_OK, message1, message2, message3)
	Widget Selection3Planes;
	Widget IO_load_image_plane_OK;
        char *message1;
        char *message2;
        char *message3;
{
	Widget Select3Plane1;
	Widget Select3PlaneLabel1;
	Widget SelectPlanesR;
	Widget SelectPlanesG;
	Widget SelectPlanesB;
	Arg args[MAX_ARGS];
	int n;

	/* Creating Select3Plane1 Widget */ 


	Select3Plane1 = 
	   XmCreateRowColumn(Selection3Planes,"Select3Plane1",NULL,0);
	XtManageChild(Select3Plane1);

	/* Creating Select3PlaneLabel1 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[102],
			XmSTRING_DEFAULT_CHARSET)); n++;

	Select3PlaneLabel1 = 
	    XmCreateLabel(Select3Plane1,"Select3PlaneLabel1",args,n);
	XtManageChild(Select3PlaneLabel1);

	/* Creating SelectPlanesR Widget */ 
	SelectPlanesR = 
	    build_SelectPlanesRbis(Select3Plane1, 
		     IO_load_image_plane_OK, message1, 1);

	/* Creating SelectPlanesG Widget */ 
	SelectPlanesG = 
		build_SelectPlanesG(Select3Plane1, 
		     IO_load_image_plane_OK, message2, 2);

	/* Creating SelectPlanesB Widget */ 
	SelectPlanesB = 
		build_SelectPlanesB(Select3Plane1, 
		     IO_load_image_plane_OK, message3, 3);

	return(Select3Plane1);
}


/********************************************************
/   Creation Function for SelectPlanesR 
/*******************************************************/

Widget
build_SelectPlanesRbis(Select3Plane1, IO_load_image_plane_OK, message, numplan)
	Widget Select3Plane1;
	Widget IO_load_image_plane_OK;
        char *message;
	int numplan;
{
	Widget SelectPlanesR;
	Widget SelectPlaneRLabel2;
	Widget PlaneRnumbers;
	Widget Plane[MAX_IMAGE];
	plan_image_select *Tableau_plans;
	char num[4];
	Arg args[MAX_ARGS];
	int i, n;

	/* Creating SelectPlanesR Widget */ 

	n = 0;
	XtSetArg(args[n],XmNorientation,XmHORIZONTAL); n++;

	SelectPlanesR =
	    XmCreateRowColumn(Select3Plane1,"SelectPlanesR",args,n);
	XtManageChild(SelectPlanesR);

	/* Creating SelectPlaneRLabel2 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(message,
			XmSTRING_DEFAULT_CHARSET)); n++;

	SelectPlaneRLabel2 = 
		XmCreateLabel(SelectPlanesR,"SelectPlaneRLabel2",args,n);
	XtManageChild(SelectPlaneRLabel2);

	/* Creating PlaneRnumbers Widget */ 

	n = 0;
	XtSetArg(args[n],XmNorientation,XmHORIZONTAL); n++;

	PlaneRnumbers = XmCreateForm(SelectPlanesR,"PlaneRnumbers",args,n);
	XtManageChild(PlaneRnumbers);


	/* Creating Plane[MAX_IMAGE] Widgets */ 
	Tableau_plans = 
	    (plan_image_select *) malloc (sizeof (plan_image_select));

	for (i=0;i < MAX_IMAGE; i++){
	  itoa (i, num);	 
  	  n = 0;
	  XtSetArg(args[n],XmNfontList, gFontlist); n++;
	  if (i == 0) XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM);
	  else
	  {
	    XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET);n++;
	    XtSetArg(args[n],XmNleftWidget,Plane[i-1]);
	  }
	  n++;
	  XtSetArg(args[n],XmNwidth, 20); n++;
	  XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(num,
			XmSTRING_DEFAULT_CHARSET)); n++;
	  XtSetArg(args[n],XmNpushButtonEnabled,true); n++;
	  XtSetArg(args[n],XmNrecomputeSize,false); n++;
	  XtSetArg(args[n],XmNhighlightThickness, 0); n++;

	  /* Definition de l'occupation du plan represente par ce bouton!*/
	  if (Occupation_Plan(i) == 1){
	    XtSetArg (args[n],XmNforeground, gorchid); n++;
	  }
	  XtSetArg (args[n],XmNbackground, gthistle);n++;


	  Plane[i] = XmCreateDrawnButton(PlaneRnumbers,"Plane",args,n);
	  XtManageChild(Plane[i]);
	  
	  Tableau_plans->plan_image[i] = Plane[i];
	}

	Tableau_plans->num_index = numplan;

	  /* Adding Callbacks for Plane[i] */ 

	for (i=0;i < MAX_IMAGE; i++)
	  XtAddCallback(Plane[i],
		XmNactivateCallback, plane_selected,Tableau_plans);

        XtAddCallback(IO_load_image_plane_OK,XmNactivateCallback,
		      libere_memoire,Tableau_plans);

	return(SelectPlanesR);
}


/********************************************************
/   Creation Function for SelectPlanesG 
/*******************************************************/

Widget
build_SelectPlanesG(Select3Plane1, IO_load_image_plane_OK, message, numplan)
	Widget Select3Plane1;
	Widget IO_load_image_plane_OK;
        char *message;
	int numplan;
{
	Widget SelectPlanesG;
	Widget SelectPlaneGLabel2;
	Widget PlaneGnumbers;
	Widget Plane[MAX_IMAGE];
	plan_image_select *Tableau_plans;
	char num[4];
	Arg args[MAX_ARGS];
	int i, n;

	/* Creating SelectPlanesG Widget */ 

	n = 0;
	XtSetArg(args[n],XmNorientation,XmHORIZONTAL); n++;

	SelectPlanesG = 
	    XmCreateRowColumn(Select3Plane1,"SelectPlanesG",args,n);
	XtManageChild(SelectPlanesG);

	/* Creating SelectPlaneGLabel2 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(message,
			XmSTRING_DEFAULT_CHARSET)); n++;

	SelectPlaneGLabel2 = 
	     XmCreateLabel(SelectPlanesG,"SelectPlaneGLabel2",args,n);
	XtManageChild(SelectPlaneGLabel2);

	/* Creating PlaneGnumbers Widget */ 

	n = 0;
	XtSetArg(args[n],XmNorientation,XmHORIZONTAL); n++;

	PlaneGnumbers = XmCreateForm(SelectPlanesG,"PlaneGnumbers",args,n);
	XtManageChild(PlaneGnumbers);

	/* Creating Plane[MAX_IMAGE] Widgets */ 
	Tableau_plans = 
	    (plan_image_select *) malloc (sizeof (plan_image_select));

	for (i=0;i < MAX_IMAGE; i++){
	  itoa (i, num);	 
  	  n = 0;
	  XtSetArg(args[n],XmNfontList, gFontlist); n++;
	  if (i == 0) XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM);
	  else
	  {
	    XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET);n++;
	    XtSetArg(args[n],XmNleftWidget,Plane[i-1]);
	  }
	  n++;
	  XtSetArg(args[n],XmNwidth, 20); n++;
	  XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(num,
			XmSTRING_DEFAULT_CHARSET)); n++;
	  XtSetArg(args[n],XmNpushButtonEnabled,true); n++;
	  XtSetArg(args[n],XmNrecomputeSize,false); n++;
	  XtSetArg(args[n],XmNhighlightThickness, 0); n++;

	  /* Definition de l'occupation du plan represente par ce bouton!*/
	  if (Occupation_Plan(i) == 1){
	    XtSetArg (args[n],XmNforeground, gorchid); n++;
	  }
	  XtSetArg (args[n],XmNbackground, gthistle);n++;


	  Plane[i] = XmCreateDrawnButton(PlaneGnumbers,"Plane",args,n);
	  XtManageChild(Plane[i]);
	  
	  Tableau_plans->plan_image[i] = Plane[i];
	}

	Tableau_plans->num_index = numplan;

	  /* Adding Callbacks for Plane[i] */ 

	for (i=0;i < MAX_IMAGE; i++)
	  XtAddCallback(Plane[i],
		XmNactivateCallback, plane_selected,Tableau_plans);

	XtAddCallback(IO_load_image_plane_OK,XmNactivateCallback,
		      libere_memoire,Tableau_plans);

	return(SelectPlanesG);
}


/********************************************************
/   Creation Function for SelectPlanesB 
/*******************************************************/

Widget
build_SelectPlanesB(Select3Plane1, IO_load_image_plane_OK, message, numplan)
	Widget Select3Plane1;
	Widget IO_load_image_plane_OK;
        char *message;
	int numplan;
{
	Widget SelectPlanesB;
	Widget SelectPlaneBLabel2;
	Widget PlaneBnumbers;
	Widget Plane[MAX_IMAGE];
	plan_image_select *Tableau_plans;
	char num[4];
	Arg args[MAX_ARGS];
	int i, n;

	/* Creating SelectPlanesB Widget */ 

	n = 0;
	XtSetArg(args[n],XmNorientation,XmHORIZONTAL); n++;

	SelectPlanesB = 
	    XmCreateRowColumn(Select3Plane1,"SelectPlanesB",args,n);
	XtManageChild(SelectPlanesB);

	/* Creating SelectPlaneBLabel2 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(message,
			XmSTRING_DEFAULT_CHARSET)); n++;

	SelectPlaneBLabel2 = 
	    XmCreateLabel(SelectPlanesB,"SelectPlaneBLabel2",args,n);
	XtManageChild(SelectPlaneBLabel2);

	/* Creating PlaneBnumbers Widget */ 

	n = 0;
	XtSetArg(args[n],XmNorientation,XmHORIZONTAL); n++;

	PlaneBnumbers = XmCreateForm(SelectPlanesB,"PlaneBnumbers",args,n);

	XtManageChild(PlaneBnumbers);

	/* Creating Plane[MAX_IMAGE] Widgets */ 
	Tableau_plans = 
	    (plan_image_select *) malloc (sizeof (plan_image_select));

	for (i=0;i < MAX_IMAGE; i++){
	  itoa (i, num);	 
	  n = 0;
	  XtSetArg(args[n],XmNfontList, gFontlist); n++;
	  if (i == 0) XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM);
	  else
	  {
	    XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET);n++;
	    XtSetArg(args[n],XmNleftWidget,Plane[i-1]);
	  }
	  n++;
	  XtSetArg(args[n],XmNwidth, 20); n++;
	  XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(num,
			XmSTRING_DEFAULT_CHARSET)); n++;
	  XtSetArg(args[n],XmNpushButtonEnabled,true); n++;
	  XtSetArg(args[n],XmNrecomputeSize,false); n++;
	  XtSetArg(args[n],XmNhighlightThickness, 0); n++;

	  /* Definition de l'occupation du plan represente par ce bouton!*/
	  if (Occupation_Plan(i) == 1){
	    XtSetArg (args[n],XmNforeground, gorchid); n++;
	  }
	  XtSetArg (args[n],XmNbackground, gthistle);n++;


	  Plane[i] = XmCreateDrawnButton(PlaneBnumbers,"Plane",args,n);
	  XtManageChild(Plane[i]);
	  
	  Tableau_plans->plan_image[i] = Plane[i];
	}

	Tableau_plans->num_index = numplan;

	  /* Adding Callbacks for Plane[i] */ 

	for (i=0;i < MAX_IMAGE; i++)
	  XtAddCallback(Plane[i],
		XmNactivateCallback, plane_selected,Tableau_plans);

	XtAddCallback(IO_load_image_plane_OK,XmNactivateCallback,
		      libere_memoire,Tableau_plans);


	return(SelectPlanesB);
}
