/* SCCS @(#)convertparam.layout.c	1.1  12/2/92 */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/*                       convertparam.layout.c                          */
/*                                                                      */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/* FILENAME     :   convertparam.layout.c                               */
/*                                                                      */
/* DESCRIPTION  :   Auxiliary Conversions type                          */
/*                                                                      */
/* AUTHORS      :   Marianne Logean                                     */
/*                                                                      */
/* VERSION      :   1.0                                                 */
/*                                                                      */
/* HISTORY      :   1.12.92                                             */
/*                  MAL         Created    version: 1.0                 */
/*                                                                      */
/* Copyright  1992 by CUI/UIN/HCUG, All rights reserved.                */
/*                                                                      */
/************************************************************************/
/************************************************************************/

#include "widgetstructure.h"
#include "convertparam.layout.h"

#define MAX_ARGS 100

extern XmFontList gFontlist, gSmall_fontlist;


static void 
param_SET_callb (options_OK, Paramprepro, callData)
     Widget options_OK;
     xs_struc_paramsconversion *Paramprepro;
     caddr_t callData;
{
  char stitre[30];

  if (Paramprepro->Imu != NULL)
    {
      sprintf (stitre, "%d", (int)dir_desc[index_image[0]].mu); 
      XmTextSetString (Paramprepro->Imu, stitre);
    }
  else
    {
      sprintf (stitre, "%f", dir_desc[index_image[0]].mmax);  
      XmTextSetString (Paramprepro->Imax, stitre);
      if (dir_desc[index_image[0]].type < Paramprepro->type_arr)
	sprintf (stitre, "%f", dir_desc[index_image[0]].mmax);
      else sprintf (stitre, "255");  
      XmTextSetString (Paramprepro->Omax, stitre);
      if (dir_desc[index_image[0]].type < Paramprepro->type_arr)
	sprintf (stitre, "%f", dir_desc[index_image[0]].mmin);
      else sprintf (stitre, "0");  
      XmTextSetString (Paramprepro->Omin, stitre);
      sprintf (stitre, "%f", dir_desc[index_image[0]].mmin); 
      XmTextSetString (Paramprepro->Imin, stitre);
    }
}


/********************************************************
/   Creation Function for convert_widget 
/*******************************************************/

xs_struc_paramsconversion 
* build_convert_widget(convertparam, type_arr)
	Widget convertparam;
	short type_arr;
{
	Widget convert_widget;
	Widget param_SET;
	Widget Imu;
	Widget Imu_text;
	Widget Imax;
	Widget Imin;
	Widget OUTPUT_Label;
	Widget Omin;
	Widget Omax;
	Widget Imin_text;
	Widget Omin_text;
	Widget Omax_text;
	Widget INPUT_Label;
	Widget Imax_text;
	xs_struc_paramsconversion *ParamsConversion;
	Arg args[MAX_ARGS];
	int n;

	ParamsConversion = 
	  (xs_struc_paramsconversion *) malloc (sizeof (xs_struc_paramsconversion));

	ParamsConversion->type_arr = type_arr;
	
	/* Creating convert_widget Widget */ 

	n = 0;
	XtSetArg(args[n],XmNheight,238); n++;
	XtSetArg(args[n],XmNresizePolicy,XmRESIZE_NONE); n++;
	XtSetArg(args[n],XmNwidth,192); n++;
	XtSetArg(args[n],XmNx,0); n++;
	XtSetArg(args[n],XmNy,0); n++;

	convert_widget = XmCreateForm(convertparam,"convert_widget",args,n);

	ParamsConversion->parent = convert_widget;

	/* Creating param_SET Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNbottomPosition,96); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[106],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition, 20); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition, 80); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition, 84); n++;


	param_SET = XmCreatePushButton(convert_widget, 
				       "param_SET",args,n);

	XtManageChild(param_SET);

	/* Adding Callbacks for param_SET */ 

	XtAddCallback(param_SET,XmNactivateCallback,
		      param_SET_callb, ParamsConversion);

	if (type_arr < 0)
	  {
	    /* Creating Imu Widget */ 

	    n = 0;
	    XtSetArg(args[n],XmNalignment,XmALIGNMENT_BEGINNING); n++;
	    XtSetArg(args[n],XmNfontList, gFontlist); n++;
	    XtSetArg(args[n],XmNlabelString,
		     XmStringLtoRCreate(paneltabs[7],
					XmSTRING_DEFAULT_CHARSET)); n++;
	    XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	    XtSetArg(args[n],XmNleftPosition,5); n++;
	    XtSetArg(args[n],XmNrightPosition,35); n++;
	    XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	    XtSetArg(args[n],XmNtopPosition,30); n++;

	    Imu = XmCreateLabel(convert_widget,"Imu",args,n);
	    XtManageChild(Imu);

	    /* Creating Imu_text Widget */ 

	    n = 0;
	    XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET); n++;
	    XtSetArg(args[n],XmNleftWidget,Imu); n++;
	    XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	    XtSetArg(args[n],XmNrightPosition,95); n++;
	    XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	    XtSetArg(args[n],XmNtopPosition,30); n++;
	    XtSetArg(args[n],XmNfontList, gSmall_fontlist); n++;

	    Imu_text = XmCreateText(convert_widget,"Imu_text",args,n);
	    XtManageChild(Imu_text);

	    ParamsConversion->Imu = Imu_text; 
	  }

	else
	  {
	    
	    ParamsConversion->Imu = NULL;

	    /* Creating Imax Widget */ 

	    n = 0;
	    XtSetArg(args[n],XmNalignment,XmALIGNMENT_BEGINNING); n++;
	    XtSetArg(args[n],XmNfontList, gFontlist); n++;
	    XtSetArg(args[n],XmNlabelString,
		     XmStringLtoRCreate(paneltabs[24],
					XmSTRING_DEFAULT_CHARSET)); n++;
	    XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	    XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	    XtSetArg(args[n],XmNrightPosition,40); n++;
	    XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	    XtSetArg(args[n],XmNtopPosition,27); n++;

	    Imax = XmCreateLabel(convert_widget,"Imax",args,n);
	    XtManageChild(Imax);
	

	    /* Creating Imin Widget */ 

	    n = 0;
	    XtSetArg(args[n],XmNalignment,XmALIGNMENT_BEGINNING); n++;
	    XtSetArg(args[n],XmNfontList, gFontlist); n++;
	    XtSetArg(args[n],XmNlabelString,
		     XmStringLtoRCreate(paneltabs[23],
					XmSTRING_DEFAULT_CHARSET)); n++;
	    XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	    XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	    XtSetArg(args[n],XmNrightPosition,40); n++;
	    XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	    XtSetArg(args[n],XmNtopPosition,12); n++;

	    Imin = XmCreateLabel(convert_widget,"Imin",args,n);
	    XtManageChild(Imin);


	    /* Creating OUTPUT_Label Widget */ 
	    
	    n = 0;
	    XtSetArg(args[n],XmNalignment,XmALIGNMENT_BEGINNING); n++;
	    XtSetArg(args[n],XmNfontList, gFontlist); n++;
	    XtSetArg(args[n],XmNlabelString,
		     XmStringLtoRCreate(paneltabs[100],
					XmSTRING_DEFAULT_CHARSET)); n++;
	    XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	    XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	    XtSetArg(args[n],XmNtopPosition,42); n++;

	    OUTPUT_Label = XmCreateLabel(convert_widget,"OUTPUT_Label",args,n);
	    XtManageChild(OUTPUT_Label);

	    /* Creating Omin Widget */ 
	    
	    n = 0;
	    XtSetArg(args[n],XmNalignment,XmALIGNMENT_BEGINNING); n++;
	    XtSetArg(args[n],XmNfontList, gFontlist); n++;
	    XtSetArg(args[n],XmNlabelString,
		     XmStringLtoRCreate(paneltabs[23],
					XmSTRING_DEFAULT_CHARSET)); n++;
	    XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	    XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	    XtSetArg(args[n],XmNrightPosition,40); n++;
	    XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	    XtSetArg(args[n],XmNtopPosition,55); n++;

	    Omin = XmCreateLabel(convert_widget,"Omin",args,n);
	    XtManageChild(Omin);


	    /* Creating Omax Widget */ 

	    n = 0;
	    XtSetArg(args[n],XmNalignment,XmALIGNMENT_BEGINNING); n++;
	    XtSetArg(args[n],XmNfontList, gFontlist); n++;
	    XtSetArg(args[n],XmNlabelString,
		     XmStringLtoRCreate(paneltabs[24],
					XmSTRING_DEFAULT_CHARSET)); n++;
	    XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	    XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	    XtSetArg(args[n],XmNrightPosition,40); n++;
	    XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	    XtSetArg(args[n],XmNtopPosition,70); n++;

	    Omax = XmCreateLabel(convert_widget,"Omax",args,n);
	    XtManageChild(Omax);


	    /* Creating Imin_text Widget */ 

	    n = 0;
	    XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET); n++;
	    XtSetArg(args[n],XmNleftWidget,Imin); n++;
	    XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	    XtSetArg(args[n],XmNrightPosition,95); n++;
	    XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	    XtSetArg(args[n],XmNtopPosition,12); n++;
	    XtSetArg(args[n],XmNfontList, gSmall_fontlist); n++;

	    Imin_text = XmCreateText(convert_widget,"Imin_text",args,n);
	    XtManageChild(Imin_text);

	    ParamsConversion->Imin = Imin_text;

	    /* Creating Omin_text Widget */ 

	    n = 0;
	    XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET); n++;
	    XtSetArg(args[n],XmNleftWidget,Omin); n++;
	    XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	    XtSetArg(args[n],XmNrightPosition,95); n++;
	    XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	    XtSetArg(args[n],XmNtopPosition,55); n++;
	    XtSetArg(args[n],XmNfontList, gSmall_fontlist); n++;

	    Omin_text = XmCreateText(convert_widget,"Omin_text",args,n);
	    XtManageChild(Omin_text);

	    ParamsConversion->Omin = Omin_text;

	    /* Creating Omax_text Widget */ 

	    n = 0;
	    XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET); n++;
	    XtSetArg(args[n],XmNleftWidget,Omax); n++;
	    XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	    XtSetArg(args[n],XmNrightPosition,95); n++;
	    XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	    XtSetArg(args[n],XmNtopPosition,70); n++;
	    XtSetArg(args[n],XmNfontList, gSmall_fontlist); n++;

	    Omax_text = XmCreateText(convert_widget,"Omax_text",args,n);
	    XtManageChild(Omax_text);

	    ParamsConversion->Omax = Omax_text;

	    /* Creating INPUT_Label Widget */ 

	    n = 0;
	    XtSetArg(args[n],XmNalignment,XmALIGNMENT_BEGINNING); n++;
	    XtSetArg(args[n],XmNfontList, gFontlist); n++;
	    XtSetArg(args[n],XmNlabelString,
		     XmStringLtoRCreate(paneltabs[73],
				   XmSTRING_DEFAULT_CHARSET)); n++;
	    XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	    
	    INPUT_Label = XmCreateLabel(convert_widget,"INPUT_Label",args,n);
	    XtManageChild(INPUT_Label);

	    /* Creating Imax_text Widget */ 

	    n = 0;
	    XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET); n++;
	    XtSetArg(args[n],XmNleftWidget,Imax); n++;
	    XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	    XtSetArg(args[n],XmNrightPosition,95); n++;
	    XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	    XtSetArg(args[n],XmNtopPosition,27); n++;
	    XtSetArg(args[n],XmNfontList, gSmall_fontlist); n++;

	    Imax_text = XmCreateText(convert_widget,"Imax_text",args,n);
	    XtManageChild(Imax_text);

	    ParamsConversion->Imax = Imax_text;
	  }
	return(ParamsConversion);
}
