/* SCCS @(#)sauve4.c	1.1  12/2/92 */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/*                      sauve4.c                                        */
/*                                                                      */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/* FILENAME     :   sauve4.c                                            */
/*                                                                      */
/* DESCRIPTION  :   Save operations                                     */
/*                                                                      */
/* AUTHORS      :   Marianne Logean                                     */
/*                                                                      */
/* VERSION      :   1.0                                                 */
/*                                                                      */
/* HISTORY      :   1.12.92                                             */
/*                  MAL         Created    version: 1.0                 */
/*                                                                      */
/* Copyright  1992 by CUI/UIN/HCUG, All rights reserved.                */
/*                                                                      */
/************************************************************************/
/************************************************************************/

#include <stdio.h>
#include <sys/types.h>
#include <pixrect/pixrect.h>
#include <pixrect/pr_io.h>
#include <pixrect/memvar.h>

#include <rasterfile.h> 

#include <X11/Intrinsic.h>
#include <Xm/Xm.h>
#include "LaboImage.util.h"
#include "define.h"
#include "structure.h"
#include "global.h"
#include "type.h"

#define	MIN(A,B)    ((A)<(B)?(A):(B))

extern int write_desc();
extern int write_desc_gel();



/*****************************************************************************/
/*									     */
/* nom      : SetUpPS							     */
/*									     */
/* fonction : construit l'entete d'un fichier PostScript pour une image      */
/*                                                                           */
/* entrees  : FILE *fdout	        : fichier de sortie de l'image       */
/*            int x		        : nbr de colonnes de l'image         */
/*	      int y			: nbr de lignes	de l'image	     */
/*                                                                           */
/* globales : neant							     */
/*									     */
/* return   : neant                                     		     */
/*									     */
/* routines : neant							     */
/*									     */
/*****************************************************************************/

SetUpPS (mode, fdOut,x,y)
    int mode;
    FILE *fdOut;
    int x,y;
{
    int dx, dy;
    double sx, sy, scale;
    double scaledX, scaledY, XX, YY;
    char pcent = '%';

    sx = PAGEWIDTH / (double)(x);
    sy = PAGEHEIGHT/ (double)(y);
    scale = (sx > sy) ? sy:sx;
    scaledX = x*scale;
    scaledY = y*scale;
    fprintf (fdOut, "%c!\n",pcent);
    fprintf (fdOut, "gsave\n");
    fprintf (fdOut, "initgraphics\n");
    fprintf (fdOut, "0.24 0.24 scale\n");
    fprintf (fdOut, "/imline %d string def\n",y);
    fprintf (fdOut, "/drawimage {\n");
    fprintf (fdOut, "    %d %d 8\n",x,y);
    fprintf (fdOut, "    [%d 0 0 %d 0 %d]\n",x,1*y,y);
    fprintf (fdOut, "    { currentfile imline readhexstring pop } image\n");
    fprintf (fdOut, "} def\n");
    if (mode == 0) {	/* grandeur nature */
	XX =  MIN ((int)(scaledX+0.5), (int)((scaledX*x/512)+0.5));
	YY =  MIN ((int)(scaledY+0.5), (int)((scaledY*y/512)+0.5));
	if ((int)XX != (int)(scaledX+0.5) && (int)YY != (int)(scaledY+0.5)){
	    scaledX = XX;
	    scaledY = YY;
	}
    }
    dx = PAGEOFFSETX + (PAGEWIDTH  - scaledX)/2;
    dy = PAGEOFFSETY + (PAGEHEIGHT  - scaledY)/2;

    fprintf (fdOut, "%d %d translate\n",dx,dy);
    fprintf (fdOut, "%d %d scale\n",(int)(scaledX+0.5), -1*(int)(scaledY+0.5));
    fprintf (fdOut, "drawimage\n");
}


/*****************************************************************************/
/*									     */
/* nom      : EndImagePS						     */
/*									     */
/* fonction : termine un fichier PostScript pour une image	             */
/*                                                                           */
/* entrees  : FILE *fdout	        : fichier de sortie de l'image       */
/*                                                                           */
/* globales : neant							     */
/*									     */
/* return   : neant                                     		     */
/*									     */
/* routines : neant							     */
/*									     */
/*****************************************************************************/
 
EndImagePS (fdOut)
    FILE *fdOut;
{
    fprintf (fdOut, "showpage\n");
    fprintf (fdOut, "grestore\n");
}


/*****************************************************************************/
/*									     */
/* nom      : fichier_laser						     */
/*									     */
/* fonction : construit un fichier PostScript pour une                       */
/*            image de type byte ou byte bin!		                     */
/*                                                                           */
/* entrees  : unsigned char *image	: image a traiter                    */
/*                                                                           */
/*									     */
/*****************************************************************************/

void fichier_laser(mode, ligne, colonne, mmin, mmax, imageIn, fdOut)
    int	    mode, ligne, colonne;
    float   mmin, mmax;
    unsigned char *imageIn;
    FILE    *fdOut;
{
  register int i, j;
  register float rapport;
  unsigned char n, *image;
  static char table[] = {'0', '1', '2', '3', '4', '5', '6', '7',
                         '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

  image = imageIn;
  SetUpPS (mode, fdOut, (int)colonne,(int)ligne);
  rapport = 255 / (mmax - mmin);
  for (j=0; j<ligne; j++) {
    for (i=0; i<colonne; i++) {
      n = (unsigned char)((*image - mmin) * rapport);
      fprintf (fdOut, "%c", table [(int)((n & 0xF0) >> 4)]);
      fprintf (fdOut, "%c", table [(int)(n & 0x0F)]);
      image++;
    }
    fprintf (fdOut, "\n");
  }
  EndImagePS (fdOut);
  fclose (fdOut);
}


/*****************************************************************************/
/*									     */
/* nom	    : sauve_fichier						     */
/*									     */
/* fonction : sauve une image en format standard (.ima et .desc)             */
/*                                                                           */
/* entrees  : char *filname           : nom du fichier de sauvetage	     */
/*	      int index1,index2,index3: no des plan-images a sauver	     */
/*									     */
/* globales : description desc        : statistiques de l'image              */
/*	      description_memoire dir_desc				     */
/*	      directoire_image dir_image				     */
/*                                                                           */
/* return   : neant                                                          */
/*									     */
/* routines : element(t)              : taille en byte du type de l'image    */
/*									     */
/*****************************************************************************/
 
int sauve_fichier (index1, index2, index3, fn)
int index1, index2, index3;
struct fname *fn;
{   
    FILE    *fp;
    int     n, taille, elem;

    /* on ecrit d'abord le descripteur de l'image */

    fp = fn->fpdesc;
    desc.ncolonne = dir_desc[index1].ncolonne; 
    desc.nligne = dir_desc[index1].nligne;
    strcpy (desc.date, (char *)get_time());
    desc.mini[0] = dir_desc[index1].mmin;
    desc.maxi[0] = dir_desc[index1].mmax;
    desc.mu[0] = dir_desc[index1].mu;
    desc.ecart[0] = dir_desc[index1].ecart;
    strcpy (desc.comment, dir_desc[index1].comment);

    if (index2 != -1) {      /* 2eme plan-image non-vide */
        desc.mini[1] = dir_desc[index2].mmin;
        desc.maxi[1] = dir_desc[index2].mmax;
        desc.mu[1] = dir_desc[index2].mu;
        desc.ecart[1] = dir_desc[index2].ecart;
    }
    else desc.mini[1] = desc.maxi[1] = desc.mu[1] = desc.ecart[1] = 0;

    if (index3 != -1) {      /* 3eme plan-image non-vide */
        desc.mini[2] = dir_desc[index3].mmin;
        desc.maxi[2] = dir_desc[index3].mmax;
        desc.mu[2] = dir_desc[index3].mu;
        desc.ecart[2] = dir_desc[index3].ecart;
    }
    else desc.mini[2] = desc.maxi[2] = desc.mu[2] = desc.ecart[2] = 0;

    desc.mini[3] = desc.maxi[3] = desc.mu[3] = desc.ecart[3] = 0;
    desc.mini[4] = desc.maxi[4] = desc.mu[4] = desc.ecart[4] = 0;
    desc.mini[5] = desc.maxi[5] = desc.mu[5] = desc.ecart[5] = 0;

    write_desc(fp, desc);   /* ecriture du descripteur */
    
    fclose(fp);            /* fermeture du fichier .desc */

    /* on ecrit ensuite l'image  */

    elem = element(dir_desc[index1].type);
    taille = desc.nligne * desc.ncolonne * elem;
    fp = fn->fpim;
    fwrite(dir_image[index1].image, (int)taille, 1, fp);     /* 1er plan  */
    if (index2 != -1) 
      {      
	if (dir_image[index2].image != NULL)                           
	  fwrite(dir_image[index2].image, (int)taille, 1, fp); /* 2eme plan */
      }
    if (index2 != -1) 
      {          
	if (dir_image[index3].image != NULL)
	  fwrite(dir_image[index3].image, (int)taille, 1, fp); /* 3eme plan */
      }
    fclose(fp);
}



/*****************************************************************************/
/*									     */
/* nom	    : sauve_gel							     */
/*									     */
/* fonction : sauve un gel						     */
/*                                                                           */
/* entrees  : struct fname *fn;          : nom du repertoire de sauvetage    */
/*	      int index			: plan-image			     */
/*									     */
/* globales : description desc        : statistiques de l'image              */
/*	      description_memoire dir_desc				     */
/*	      directoire_image dir_image				     */
/*                                                                           */
/* return   : neant                                                          */
/*									     */
/* routines : element(t)              : taille en byte du type de l'image    */
/*									     */
/*****************************************************************************/
 
int sauve_gel (index, fn)
int index;
struct fname *fn;
{   
    FILE    *fp;
    int     n, taille, elem;

    /* on ecrit d'abord le descripteur de l'image */

    fp = fn->fpdesc;
    desc.ncolonne = dir_desc[index].ncolonne; 
    desc.nligne = dir_desc[index].nligne;
    strcpy (desc.date, (char *)get_time());
    desc.mini[0] = dir_desc[index].mmin;
    desc.maxi[0] = dir_desc[index].mmax;
    desc.mu[0] = dir_desc[index].mu;
    desc.ecart[0] = dir_desc[index].ecart;
    strcpy (desc.comment, dir_desc[index].comment);

    desc.mini[1] = desc.maxi[1] = desc.mu[1] = desc.ecart[1] = 0;
    desc.mini[2] = desc.maxi[2] = desc.mu[2] = desc.ecart[2] = 0;
    desc.mini[3] = desc.maxi[3] = desc.mu[3] = desc.ecart[3] = 0;
    desc.mini[4] = desc.maxi[4] = desc.mu[4] = desc.ecart[4] = 0;
    desc.mini[5] = desc.maxi[5] = desc.mu[5] = desc.ecart[5] = 0;

    write_desc_gel(fp, desc);   /* ecriture du descripteur */
    
    fclose(fp);            /* fermeture du fichier .desc */

    /* on ecrit ensuite l'image  */

    elem = element(dir_desc[index].type);
    taille = desc.nligne * desc.ncolonne * elem;
    fp = fn->fpim;
    fwrite(dir_image[index].image, (int)taille, 1, fp); 
    fclose(fp);
}




/*        fnras = fname_panel(paneltabs[449], paneltabs[450], 31);*/
/*    else fromto (FROM, DEFAUT);*/
/* !!!!!!verifier le type BYTE de l'image: */
/* imageInit = = (unsigned char *)dir_image[index_image[0]].image;*/
/* nline = dir_desc[index_image[0]].nligne */
/* ncol = dir_desc[index_image[0]].ncolonne */

int sauve_rasterfile(fnras, imageInit, nline, ncol)
    struct fname *fnras;
    unsigned char *imageInit;
    int nline, ncol;
{
    FILE *fp;
    int i, j;
    struct pixrect *p1pixrect;
    colormap_t colormaploc;
    unsigned char *p_pix, *p_image;
    int incr_pix, l, c;
    unsigned char nivgrislin[3][256];

    p_image = (unsigned char *)imageInit;

    for ( j = 0 ; j < 256 ; j++) {
        nivgrislin[0][j] = j;
        nivgrislin[1][j] = j;
        nivgrislin[2][j] = j;
    }

    colormaploc.type = RMT_EQUAL_RGB;
    colormaploc.length = 256;
    colormaploc.map[0] = nivgrislin[0];
    colormaploc.map[1] = nivgrislin[1];
    colormaploc.map[2] = nivgrislin[2];

    p1pixrect = mem_create(ncol, nline, 8);
    p_pix = (unsigned char *)((mpr_d(p1pixrect))->md_image);
    incr_pix = ncol & 03;
    incr_pix = (4 - incr_pix) & 03;
    for (l=0; l<nline; l++){
      for (c=0; c<ncol; c++){
	*p_pix = *p_image;
	p_pix++;  p_image++;
      }
      p_pix += incr_pix;
    }
    pr_dump(p1pixrect, fnras->fpim, &colormaploc, RT_BYTE_ENCODED, 1);
    pr_destroy(p1pixrect);
    fclose(fnras->fpim);
    return(1);
}

