/* SCCS @(#)rehaus4.c	1.1  12/2/92 */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/*                      rehaus4.c                                       */
/*                                                                      */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/* FILENAME     :   rehaus4.c                                           */
/*                                                                      */
/* DESCRIPTION  :   Rehaussement operation                              */
/*                                                                      */
/* AUTHORS      :   Marianne Logean                                     */
/*                                                                      */
/* VERSION      :   1.0                                                 */
/*                                                                      */
/* HISTORY      :   1.12.92                                             */
/*                  MAL         Created    version: 1.0                 */
/*                                                                      */
/* Copyright  1992 by CUI/UIN/HCUG, All rights reserved.                */
/*                                                                      */
/************************************************************************/
/************************************************************************/

#include <stdio.h>
#include <math.h>

#include "define.h"


/*****************************************************************************/

int histequalize(InImage, OutImage, DimX, DimY, InGrayLevels, OutGrayLevels)
  float *InImage, **OutImage;
  int DimX, DimY;
  int InGrayLevels, OutGrayLevels;
{
    float *IdealImageHist, *InImageHist, *OutImageHist; 
    int *TransfTable, CountInGray;
    float value, InVal, Rmin, diff, sumc;
    int i, j, index1, index2, StopLoop, sum, size, histindex;
    int errorpix, InVali;

    /* get an ideally equalized histogram in IdealHist */

    IdealImageHist=(float *) calloc(OutGrayLevels, sizeof(float));
    InImageHist=(float *) calloc(InGrayLevels, sizeof(float));
    value = (float) 1.0/OutGrayLevels;
    for (i=0; (i < OutGrayLevels); ++i)
      *(IdealImageHist+i)= value;
    size = DimX*DimY;    

    CountInGray = InGrayLevels;

    /* make histogram of input image */

    for(i=0; (i < size); i++){
       histindex = (int) *(InImage + i);
       histindex = (histindex < 0) ? 0 : histindex;
       histindex = (histindex > InGrayLevels) ? InGrayLevels : histindex;          
       *(InImageHist + histindex) += 1.00;
     }

    /* normalize histogram of input image */
   
    sumc=0;

    for(i=0; (i < CountInGray); ++i){
       sumc += *(InImageHist + i);
      }
    for(i=0; (i < CountInGray); ++i)
       *(InImageHist + i) = (*(InImageHist + i) / sumc );

/*
       construct transformation table: 
       --first make cumulative distributions : 
*/

    sumc=0;
    for(i=0; (i < CountInGray); ++i){
       sumc += *(InImageHist + i);
       *(InImageHist + i)= sumc;  
     }
    sumc=0;
    for(i=0; (i < OutGrayLevels); ++i){
       sumc += *(IdealImageHist + i);
       *(IdealImageHist + i)= sumc;
     } 

    /* now construct the transformation table  TransTable[] */
 
    TransfTable = (int*) calloc(InGrayLevels , sizeof(int));

    index1=0;
    index2=1;
    for (i=0; (i < CountInGray); i++){
           Rmin=100.00;
           j=index1;
           InVal= *(InImageHist + i);
           StopLoop = FALSE;
           while ((!StopLoop) && (j < OutGrayLevels)){
	       diff= fabs(InVal - *(IdealImageHist + j));
               if (diff > Rmin) {
                   StopLoop=TRUE;
	       }
               else{
                     index2=j;
                     Rmin= diff;
	       }
               j += 1;
	   }
           *(TransfTable + i) = index2;
	   if (i > CountInGray){
	       --i;
	   }
           index1= index2 ;
    }

    /* create new image with gray-scale transformation */

    *OutImage=(float *) calloc(size , sizeof(float));
    for (i=0; (i < size); ++i){ 
       InVali= *(InImage + i);
       InVali = (InVali < 0) ? 0 : InVali;
       InVali = (InVali > InGrayLevels) ? InGrayLevels : InVali;  
       *(*OutImage + i) = *(TransfTable + InVali);
    }

    free(IdealImageHist);
    free(InImageHist);
    free(TransfTable);
    return(0);
}
  


/**************************************************************************/
/*                                                                        */
/* Procedure implementing the fast 2-D median filtering algorithm as      */
/* described by T.S.HUANG ,G.J.YANG, G.Y.TANG in IEEE Transactions ASSP   */
/* Vol-27 No.1                                                            */
/*                                                                        */
/**************************************************************************/

int SlideWindow(Image, ImageR, DimX, DimY, Wx, Wy, hues)
    float *Image;
    float **ImageR; 
    int DimX, DimY, Wx, Wy, hues;
{
    int  *Histogram, *IWind, *ValRet, AC, OC;
    int  Median, MedianTot, LessThanMedCount,MedEstim;
    int HalfWx,HalfWy, l, m, n , buf1, bufX,p, l1, limW, i, j, k;


    Histogram=(int*) calloc(hues,sizeof(int));

    /* Allocation of memory space for the resultant image */
    *ImageR=(float*) calloc(DimX*DimY,sizeof(float));

    if (ImageR==NULL)   /* not enough memory space */
        return(-1);
  
    HalfWx= Wx/2;
    HalfWy= Wy/2;
    MedEstim=(Wx*Wy)/2;

    /* Padding  around the sides */
    buf1=DimY-HalfWy;
    for(j=0; j<HalfWy; ++j){
       for(i=0; i<DimX; ++i){
          *(*ImageR+j*DimX+i)=  *(Image+j*DimX+i);
          *(*ImageR+DimX*(buf1+j)+i)=  *(Image+DimX*(buf1+j)+i);
       }  
    }
    buf1=DimX-HalfWx;
    for(j=0; j < HalfWx; ++j){
       for(i=0; i < DimY; ++i){
          *(*ImageR+i*DimX+j)= *(Image+i*DimX+j);
          *(*ImageR+DimX*i+j+buf1)= *(Image+DimX*i+j+buf1);
       }  
    }

    /* Application of the Median Filter */

    bufX=DimX*HalfWy + HalfWx + 1;
    for(j=0; j <= (DimY - Wy); ++j){
/*  
   initialisation of the histogram with the 1st window on the row 
   along which the window slides.
*/
         MedianTot = 0;
         limW = j+Wy;
         for(i=0; i<hues; ++i)
            *(Histogram + i)=0; 
	 for(k=0; k < Wx; ++k){
            for(i=j; i < limW; ++i){ 
               p = *(Image + DimX*i + k); 
               p = (p < 0) ? 0 : p; 
               p = (p > hues) ? hues : p; 
               *(Histogram + p) += 1;
               MedianTot += 1;
            }
	 }
         MedianTot /= 2;
         k=0;
         i= 0;
         while (k <= MedEstim){
             k += *(Histogram + i);
             ++i;
         } 
         Median=i-1;
         LessThanMedCount=k- *(Histogram + i - 1); 
         buf1= DimX*(j+HalfWy)+HalfWx;
         /* 
            readjustement of the median along the row as the window
            changes, accounting only for the column which gets
            removed and the one which gets added.
         */
         *(*ImageR + buf1)= Median;
         for(k=Wx; k<DimX; ++k)
         {
           for(i=j; i < (j+ Wy); ++i){  /* column */
              m=DimX*i+k; 
              OC= *(Image+m-Wx);
              *(Histogram + OC) -= 1;
              if (OC < Median) LessThanMedCount -= 1;
              AC= *(Image+m);
              *(Histogram + AC) += 1;
              if (AC < Median) LessThanMedCount += 1;
	   }

           if  (LessThanMedCount > MedEstim)
              do{
		  Median -= 1;
                  LessThanMedCount -=  Histogram[Median] ;
	      }while (LessThanMedCount >= MedEstim);
           else  while ((LessThanMedCount+Histogram[Median]) <= MedEstim){
	             LessThanMedCount +=  Histogram[Median] ;
                     Median += 1;
 	        }

           buf1 += 1;
           *(*ImageR+ buf1)=Median;
   	 }
    }
  
   return(0);
      

    
}


