/* SCCS @(#)lcount4.c	1.1  12/2/92 */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/*                      lcount4.c                                       */
/*                                                                      */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/* FILENAME     :   lcount4.c                                           */
/*                                                                      */
/* DESCRIPTION  :   Color regions operations                            */
/*                                                                      */
/* AUTHORS      :   Marianne Logean                                     */
/*                                                                      */
/* VERSION      :   1.0                                                 */
/*                                                                      */
/* HISTORY      :   1.12.92                                             */
/*                  MAL         Created    version: 1.0                 */
/*                                                                      */
/* Copyright  1992 by CUI/UIN/HCUG, All rights reserved.                */
/*                                                                      */
/************************************************************************/
/************************************************************************/

#include <math.h>

#include "lcount4.h"

#include "define.h"
#include "global.h"
#include "structure.h"
#include "type.h"


#define MAGIC_1	    11
#define MAGIC_2	    22
#define CONN8	    2
#define BACKGR	    1
#define VIDE 	    0		/* Couleur des pixels vides    : a ne pas
				 * modifier !! */
#define CONTOUR_C 0xffff	/* Couleur des pixels contours : a ne pas
				 * modifier !! */

#define MAX_OBJETS CONTOUR_C-1	/* nombre maximal d' objets enregistres */


static int      flag_regime, Vide_x;
int            *Histogramme[MAX_IMAGE];


static struct ligne
{				/* Structure de remplissage d'une ligne : */
    short           X, Y, Min, Max;	/* passe par X et Y et va de XMin a
					 * XMax */
};

static int      Hist[CONTOUR_C];/* Tableau temporaire pour le stockage de la
				 * taille des objets */

static unsigned short *VRAM_SAVE;	/* Pointeur vers l'image a traiter */

static int      Couleur_Courante = 0;	/* Compteur de la couleur courante */
static int      Conn8;		/* Flag de remplissage en connectivite 8 */
static unsigned int Taille_Objet_Courant;
static int      XXMax, YYMax;	/* Taille de l'image */



/*****************************************************************************/
/* unsigned int Adresse(X,Y)  calcule le deplacement pour le pixel en X et Y */
/*     entree : Coordonnees X et Y en pixels                                 */
/*     sortie : deplacement dans la memoire correspondant                    */
/*****************************************************************************/

static unsigned int
Adresse(X, Y)
    unsigned int    X, Y;
{
    return ((unsigned int) ((unsigned int) XXMax * Y + X));

}


/*****************************************************************************/

void
write_res_count(N, colonne, ligne, str)
    int N, colonne, ligne;
    struct count_s *str;
{
    FILE           *FO;
    int             IMin = VIDE + 1;
    int		    N_O = 0, Coul_e, XEt, YEt, S_All, S_Front = 0, I;
    int             XX, Y;
    unsigned short *Coords, *Adr, Coul;
    float           coeff, coeff_l;

    XEt = min(colonne - 1, str->XEt);
    if (XEt < 0)
	XEt = 0;
    YEt = min(ligne - 1, str->YEt);
    if (YEt < 0)
	YEt = 0;
    FO = fopen(str->FN_Res, "wt");
    if (FO == NULL)
    {
	write_erreur(931);
	return;
    }
    S_All = colonne * ligne;
    Coords = (unsigned short *) malloc(2 * sizeof(short) * (*Histogramme[N]));
    if (Coords == NULL)
    {
	write_erreur(900);
	fclose(FO);
	return;
    }
    memset(Coords, 0xff, 2 * sizeof(short) * (*Histogramme[N]));
    Adr = (unsigned short *) dir_image[N].image;
    for (Y = 0; Y < ligne; Y++)
	for (XX = 0; XX < colonne; XX++, Adr++)
	{
	    if (!(*Adr))
		continue;
	    Coul = *Adr - 1;
	    if ((*Adr != 0xffff) && (*(Coords + Coul + Coul) == 0xffff))
	    {
		*(Coords + Coul + Coul) = XX;
		*(Coords + Coul + Coul + 1) = Y;
	    }
	    if ((XX == colonne - 3) &&
		(Y == ligne - 1))
		break;
	}
    for (I = 1; I <= *Histogramme[N]; I++)
    {
	if (*(Histogramme[N] + I) >= str->SMin)
	    N_O++;
	S_Front += *(Histogramme[N] + I);
    }
    S_Front = S_All - S_Front;
    Coul_e = *((short *) dir_image[N].image + Adresse(XEt, YEt));
    fprintf(FO,
	    "/***************************************************************************/\n");
    fprintf(FO,filetabs[0]);
	    
    fprintf(FO,
	    "/*                                                                         */\n");
    fprintf(FO, filetabs[1]);
	    
    fprintf(FO,
	    "/***************************************************************************/\n");
    fprintf(FO,filetabs[2], dir_desc[N].filename); 
    fprintf(FO, filetabs[3], colonne, ligne);
    fprintf(FO, filetabs[4], str->SMin);
    if (str->SEt)
    {
	fprintf(FO, filetabs[5]);
	fprintf(FO, "X = %d pix, Y = %d pix S = %d pix.\n",
		str->XEt, str->YEt, str->SEt);
	coeff = (float) str->SEt / (float) *(Histogramme[N] + Coul_e);
	coeff_l = (float) sqrt((double) coeff);
	if (flag_regime & BACKGR)
	{
	    N_O--;
	    IMin++;
	    fprintf(FO, filetabs[6],
		    *(Histogramme[N] + 1),
		    (float) ((float) *(Histogramme[N] + 1) * coeff));
	    fprintf(FO,filetabs[7],
		    S_Front, (float) ((float) S_Front * coeff));
	}
	if (N_O == 1)
	    fprintf(FO, filetabs[8], N_O);
	else
	    fprintf(FO, filetabs[9], N_O);
	for (I = IMin; I <= *Histogramme[N]; I++)
	{
	    if (*(Histogramme[N] + I) < str->SMin)
		continue;
	    fprintf(FO,filetabs[10], I,
		(float) ((float) *(Coords + I + I - 2) * coeff_l),
		(float) ((float) *(Coords + I + I - 1) * coeff_l),
		(float) ((float) *(Histogramme[N] + I) * coeff));
	    if (I == Coul_e)
		fprintf(FO, filetabs[11]);
	    fprintf(FO, "\n");
	}
	fprintf(FO, "\n");
}
    else
    {
	if (flag_regime & BACKGR)
	{
	    N_O--;
	    IMin++;
	    fprintf(FO, filetabs[12],
		    *(Histogramme[N] + 1));
	    fprintf(FO, filetabs[13],
		    S_Front);
	}
	if (N_O == 1)
	    fprintf(FO, filetabs[14], N_O);
	else
	    fprintf(FO, filetabs[15], N_O);
	for (I = IMin; I <= *Histogramme[N]; I++)
	{
	    if (*(Histogramme[N] + I) < str->SMin)
		continue;
	    fprintf(FO, filetabs[16], I,
		*(Coords + I + I - 2), *(Coords + I + I - 1),
		*(Histogramme[N] + I));
	}
    }
    free(Coords);
    fclose(FO);
}



/*****************************************************************************/
/* Tracer_Ligne(LAdr) Remplit une ligne avec la Couleur_Courante 	     */
/*             et met a jour les limites (*LAdr).XMin et (*LAdr).XMax        */
/*     entree : pointeur vers la structure LIGNE a remplir                   */
/*     sortie : neant                                                        */
/*****************************************************************************/

static void
Tracer_Ligne(LAdr)
    struct ligne   *LAdr;
{
    unsigned short *Adr;
    (*LAdr).Min = (*LAdr).X;	/* initialise les points gauche et droite */
    (*LAdr).Max = (*LAdr).X + 1;
    for (Adr = (unsigned short *) (VRAM_SAVE + Adresse((*LAdr).X, (*LAdr).Y))
	 ;; Adr--, (*LAdr).Min--)	/* on cherche la fin a gauche de X */
    {
	if (((*LAdr).Min < 0) || (*Adr != Vide_x))
	    break;		/* si on arrive au bord gauche ou a un pixel
				 * plein */
	*Adr = Couleur_Courante;/* Autrement on remplit le pixel */
	Taille_Objet_Courant++;	/* et on incremente la Taille de l'objet */
    }
    (*LAdr).Min++;
    for (Adr = (unsigned short *) (VRAM_SAVE + Adresse((*LAdr).X + 1, (*LAdr).Y))
	 ;; Adr++, (*LAdr).Max++)	/* on cherche la fin a droite de X */
    {
	if (((*LAdr).Max >= XXMax) || (*Adr != Vide_x))
	    break;		/* si on arrive au bord droit ou a un pixel
				 * plein */
	*Adr = Couleur_Courante;/* Autrement on remplit le pixel */
	Taille_Objet_Courant++;	/* et on incremente la Taille de l'Objet */
    }
}


/*****************************************************************************/
/* Colorer_Region(X,Y) Remplit la region autour de X et Y	             */
/*     entree : coordonnees X et Y appartenant a la region		     */
/*     sortie : rien                                                         */
/*****************************************************************************/

static void
Colorer_Region(X, Y)
    int X, Y;
{
    struct ligne    L;
    int             I;
    unsigned short *Adr;
    L.X = X;			/* Met les valeurs initiales de X et Y dans
				 * la */
    L.Y = Y;			/* structure LIGNE L */
    Tracer_Ligne(&L);		/* Remplit cette ligne passant par X et Y */
    if (Conn8)			/* Si on remplit en connectivite 8,a lors on */
    {				/* permet a ses voisines immediates d'etre  */
	if (L.Min > 0)		/* plus longs de un pixel de chaque cote,
				 * sans */
	    L.Min--;		/* toutefois depasser les bords de l'image */
	if (L.Max < XXMax)
	    L.Max++;
    }
    if (Y > 0)			/* si il y a une ligne au dessus, on essaye
				 * de la */
    {				/* remplir aussi	 */
	Adr = (unsigned short *) (VRAM_SAVE + Adresse(0, Y - 1));
	for (I = L.Min; I < L.Max; I++)
	    if (*(Adr + I) == Vide_x)
		Colorer_Region(I, Y - 1);
    }
    if (Y < YYMax - 1)		/* si il y a une ligne au dessous, on essaye
				 * de la */
    {				/* remplir aussi	 */
	Adr = (unsigned short *) (VRAM_SAVE + Adresse(0, Y + 1));
	for (I = L.Min; I < L.Max; I++)
	    if (*(Adr + I) == Vide_x)
		Colorer_Region(I, Y + 1);
    }
}


/*****************************************************************************/

static void
Count_Obj(XM, YM, NN)
int XM, YM, NN;
{
    int             X, Y;
    int             Taille_X_Image;	/* On met a jour les variables
					 * globales necessaires */
    int             N;
    Couleur_Courante = 0;
    XXMax = XM;
    YYMax = YM;
    Taille_X_Image = XM * YM;	/* taille de l'image en pixels */
    for (Y = 0; Y < YYMax; Y++)
	for (X = 0; X < XXMax; X++)
	    /* On parcourt tous les pixels de l'image */
	    if (*(VRAM_SAVE + Adresse(X, Y)) == Vide_x)
	    {				/* si le pixel est vide */
		Couleur_Courante++;	/* on choisit une nouvelle couleur */
		if (Couleur_Courante > MAX_OBJETS)
		{		/* si il n'y a plus de couleurs disponibles */
		    write_erreur(920);
		    Histogramme[NN] = NULL;
		    return;	/* on retourne */
		}
		Taille_Objet_Courant = 0;	/* sinon on met a 0 la taille
						 * de l'objet */
		Colorer_Region(X, Y);	/* on remplit la region autour du
					 * pixel */
		Hist[Couleur_Courante - 1] = Taille_Objet_Courant;
		/*
		 * on sauvegarde la taille obtenue dans l'histogramme 
		 */
	    }
    if (Histogramme[NN] != NULL)
	free(Histogramme[NN]);
    if (Couleur_Courante == 0)	/* si il n'y a aucun objet dans l'image */
	Histogramme[NN] = NULL;	/* on retourne vecteur des tailles pointant
				 * vers NUL */
    else			/* sinon on aloue de la place pour ce vecteur */
    {
	Histogramme[NN] = (int *) malloc((Couleur_Courante + 1) * sizeof(int));
	if (Histogramme[NN] == NULL)	/* si il n'y a plus de place */
	{
	    write_erreur(900);
	    return;		/* retour si pas de memoire */
	}
	*Histogramme[NN] = Couleur_Courante;
	memcpy((char *) (Histogramme[NN] + 1), (char *) Hist,	/* on recopie les */
	       Couleur_Courante * sizeof(int));	/* valeurs trouvees dans le */
    }				/* vecteur */
    *(VRAM_SAVE + Taille_X_Image - 2) = MAGIC_1;
    *(VRAM_SAVE + Taille_X_Image - 1) = MAGIC_2;
}



/*****************************************************************************/

int
make_count(imageIn, imageOut, no, ligne, colonne, nb_count, current_color)
    unsigned char *imageIn, **imageOut;  
    int no, ligne, colonne, nb_count, *current_color;
{
    int             ssize, xsize, nn;
    unsigned char  *Adr_c;
    unsigned short *Adr_s;

    switch (nb_count)
    {
      case 1: flag_regime = CONN8 + BACKGR;
      case 2: flag_regime = BACKGR;
      case 3: flag_regime = CONN8;
      case 4: flag_regime = 0;
    }
    
    xsize = colonne * ligne;
    ssize = xsize * sizeof(short);

    *imageOut = (unsigned char *) malloc(ssize);
    if (*imageOut == NULL)
	return(-1);

    Adr_c = imageIn;
    Adr_s = (unsigned short *) *imageOut;
    for (nn = 0; nn < xsize; nn++, Adr_c++, Adr_s++)
    {
	if (*Adr_c == 0)
	    *Adr_s = 0;
	else
	    *Adr_s = 0xffff;
    }
    VRAM_SAVE = (unsigned short *) *imageOut;
    if (flag_regime & CONN8)
	Conn8 = 1;
    else
	Conn8 = 0;
    if (flag_regime & BACKGR)
	Vide_x = VIDE;
    else
	Vide_x = CONTOUR_C;
    Count_Obj(colonne, ligne, no);
    *current_color = Couleur_Courante;
    return (0);
}



/*****************************************************************************/

int
ccut(InImage, OutImage, type, colonne, ligne, size)
    unsigned char *InImage, **OutImage;
    int type, colonne, ligne;
    struct cut_s *size;
{
    int   y, lelem, step1, step2, ssize, ll;
    unsigned char  *Adr1, *Adr2;
    
    lelem = element(type);

    ll = size->XMax - size->XMin;
    ssize = ll * (size->YMax - size->YMin) * lelem;
    if (!ssize)
	return(-1);

    *OutImage = (unsigned char *) malloc(ssize);

    if (*OutImage == NULL)
    {
	write_erreur(900);
	return(-1);
    }
    
    Adr1 = InImage + (size->XMin + size->YMin * colonne) * lelem;
    Adr2 = *OutImage;
    step1 = colonne * lelem;
    step2 = ll * lelem;
    for (y = size->YMin; y < size->YMax; y++)
    {
	memcpy(Adr2, Adr1, step2);
	Adr1 += step1;
	Adr2 += step2;
    }
    return(0);
}


/*****************************************************************************/

void
Order_Min_Max(i,j)
int *i, *j;
{
    int I, J;
    I = *i;
    J = *j;
    *i = min(I,J);
    *j = max(I,J);
}



#undef CONN8
#undef BACKGR
#undef VIDE 0
#undef CONTOUR_C
#undef MAX_OBJETS
#undef MAGIC_1
#undef MAGIC_2

