/* SCCS @(#)convol4.c	1.1  12/2/92 */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/*                      convol4.c                                       */
/*                                                                      */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/* FILENAME     :   convol4.c                                           */
/*                                                                      */
/* DESCRIPTION  :   Convolution operations                              */
/*                                                                      */
/* AUTHORS      :   Marianne Logean                                     */
/*                                                                      */
/* VERSION      :   1.0                                                 */
/*                                                                      */
/* HISTORY      :   1.12.92                                             */
/*                  MAL         Created    version: 1.0                 */
/*                                                                      */
/* Copyright  1992 by CUI/UIN/HCUG, All rights reserved.                */
/*                                                                      */
/************************************************************************/
/************************************************************************/

#include <math.h>
#include "type.h"
#include "structure.h"

#define max(x,y) (((x) > (y)) ? (x) : (y))
#define min(x,y) (((x) < (y)) ? (x) : (y))


int convolue (debut, Dlin, Dcol, imagearr, Alin, Acol, conv, select)
    float *debut, **imagearr;
    int Dlin, Dcol, Alin, Acol;
    struct convol *conv;
    int select;
{
    float *arr, res, *masque, *deb, mtemp, *pmas, *pdep;
    int Mlin, Mcol;
    int Mdlin, Mdcol, Iminl, Imaxl, Iminc, Imaxc;
    int dep_c, dep_l, mas_c, mas_l, diffcol, i;

    register int Dl, Dc, Ml, Mc;
    register int l, c, ll, cc;

     /* convolution -> retourner masque */

    if (select == 1 || select == 2) {
	masque = conv->masque;
	deb = conv->masque + (conv->ligne * conv->colonne) - 1;
	for (i=0; i<(conv->ligne*conv->colonne)/2; i++){
	    mtemp = *deb;
	    *deb = *masque;
	    *masque = mtemp;
	    masque++; deb--;
	}
    }

    *imagearr = arr = (float *)malloc(Alin*Acol*sizeof(*arr));

    /* dans le systeme de coordonnees de l'image d'arrivee (A)		*/
    /* coin superieur gauche = (0,0)					*/
    /* D = image depart, A = image arrivee, M = masque, I = A inter M	*/

    Mlin = conv->ligne;
    Mcol = conv->colonne;
    Mdlin = Mlin/2;
    Mdcol = Mcol/2;
    Dl = (Alin-Dlin)/2;
    Dc = (Acol-Dcol)/2;

    for (l=0; l<Alin; l++){
	for (c=0; c<Acol; c++){
	    Ml = l-Mdlin;
	    Mc = c-Mdcol;
	    Iminl = max (Ml,Dl);
	    Iminc = max (Mc,Dc);
	    Imaxl = min (Ml+Mlin,Dl+Dlin);
	    Imaxc = min (Mc+Mcol,Dc+Dcol);
	    mas_c = Iminc - Mc;
	    mas_l = Iminl - Ml;
	    dep_c = Iminc - Dc;
	    dep_l = Iminl - Dl;
	    pmas = conv->masque + mas_l * Mcol + mas_c;
	    pdep = debut + dep_l * Dcol + dep_c;
            res = 0;
	    diffcol = Imaxc-Iminc;
	    for (ll=Iminl; ll<Imaxl; ll++){
		for (cc=Iminc; cc<Imaxc; cc++){
		   res += (*pmas) * (*pdep);
		   pmas++; pdep++;
		}
		pmas += Mcol-diffcol;
                pdep += Dcol-diffcol;
	    }
	    *arr = res * conv->factmult;
	    arr++;
	}
    }
}
