/* SCCS @(#)mapeditTOOL.callback.c	1.1  12/2/92 */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/*                   mapeditTOOL.callback.c                             */
/*                                                                      */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/* FILENAME     :   mapeditTOOL.callback.c                              */
/*                                                                      */
/* DESCRIPTION  :   LaboImage (Map Editing Tool)                        */
/*                                                                      */
/* AUTHORS      :   Marianne Logean                                     */
/*                                                                      */
/* VERSION      :   1.0                                                 */
/*                                                                      */
/* HISTORY      :   1.12.92                                             */
/*                  MAL         Created    version: 1.0                 */
/*                                                                      */
/* Copyright  1992 by CUI/UIN/HCUG, All rights reserved.                */
/*                                                                      */
/************************************************************************/
/************************************************************************/

#include "libwidgets/widgetstructure.h"
#include "mapeditTOOL.layout.h"
#include <Xm/Text.h>
#include <Xm/Scale.h>
#include <sys/types.h>
#include <sys/dir.h>
#include <stdio.h>
#include <math.h>

extern Pixmap 	flechepixmap;
extern Widget 	XmDrawingAreafleche;
extern Display 	*gDisplay;
extern GC 	default_gc;   

static Widget ChildrenToManage[15];

/*
    definition de constantes 
*/

#define max(x,y) (((x) > (y)) ? (x) : (y))
#define min(x,y) (((x) < (y)) ? (x) : (y))

/*  constantes generales   */

#define BLACK	255
#define WHITE	0
#define E	2.7182818
#define CMAP_SIZE 256

#define RM 1 
#define HM 2 
#define RO 3 
#define HO 4 

/*#define RGB 1  cf define.h:#define RGB 30 */
#define HLS 0

#define MULT 1
#define ONE 0


static void set_map_edit() ;

static void draw_arrow() ;
static void erase_arrows() ;
static void arrows() ;
static void one_arrow() ;

static void change_one_field() ;
static void change_multiple_field() ;
static void one_field_proc() ;
static void fields_proc() ;
static void of_proc() ;
static void fs_proc() ;

static void Manage_TO() ;
    

/*
    procedures de gestion de couleur RGB 
*/

static void RGB_fix_mult_map() ;
static void fix_colourRGB() ;

/*
    procedures de gestion de couleur HLS 
*/

static void HLS_fix_mult_map() ;
static void fix_colourHLS() ;
static void RGB_to_HLS() ;
static float RGBconv() ;

    
    
/*******************************************************************

		declaration de variables globales

********************************************************************/


/*
    table de couleurs complete
*/

unsigned char	mapedit_red[256] ;
unsigned char	mapedit_green[256] ;
unsigned char	mapedit_blue[256] ;
static Colormap Defaultcolormap;

extern Colormap Mapedit_colormap;
extern XColor Colors[MAXCOLORS];

/*
    borne de l'intervale (freeze = ON)
*/

static unsigned char	cred[2] ;
static unsigned char	cgreen[2] ;
static unsigned char	cblue[2] ;

/*
    champ unique (freeze = ON)
*/

static unsigned char	one_cred ;
static unsigned char	one_cgreen ;
static unsigned char	one_cblue ;

extern int mode;

static int LIN_ON = TRUE;
static int FREEZE_ON = FALSE;

int numcolors;

/******************************************************
/   activateCallback for Widget  freeze
/*****************************************************/

void
Choose_freeze (freeze_widget, freeze_on, callData)
	Widget freeze_widget;
        int freeze_on;
	caddr_t callData;
{
  switch (freeze_on)
  {
  case 0: FREEZE_ON = FALSE;
    break;
  case 1: FREEZE_ON = TRUE;
    break;
  }
}


/******************************************************
/   activateCallback for Widget  freeze
/*****************************************************/

void
freeze_proc (freeze_widget, tab_widgets, callData)
	Widget freeze_widget;
        xs_struc_mapedit *tab_widgets;
	caddr_t callData;
{
  int n0, n1;
      
    if (MULT_on(mode))
    {
      n0 = atoi(XmTextGetString(tab_widgets->FROM_TO_text[0]));
      n1= atoi(XmTextGetString(tab_widgets->FROM_TO_text[1]));

      if ((n0 >= 0) && (n0 <= 255) && (n1 >= 0) && (n1 <= 255))
      {
	cred[0] = mapedit_red[n0] ;
	cgreen[0] = mapedit_green[n0] ;
	cblue[0] = mapedit_blue[n0] ;
	cred[1] = mapedit_red[n1] ;
	cgreen[1] = mapedit_green[n1] ;
	cblue[1] = mapedit_blue[n1] ;
      }
      else
      write_master(paneltabs[311]) ;
    }
    else
    {
      n0 = atoi(XmTextGetString(tab_widgets->FROM_TO_text[0]));
      if ((n0 >= 0) && (n0 <= 255))
      {
	one_cred = mapedit_red[n0] ;
	one_cgreen = mapedit_green[n0] ;
	one_cblue = mapedit_blue[n0] ;
      }   
      else
      write_master(paneltabs[311]) ;
    }

}



/******************************************************
/   activateCallback for Widget  interpolation
/*****************************************************/

void
Choose_interpolation(interpol_widget, LinLog, callData)
	Widget interpol_widget;
        int    LinLog;
	caddr_t callData;
{
  switch (LinLog)
  {
  case 0: LIN_ON = FALSE;
    break;
  case 1: LIN_ON = TRUE;
    break;
  }
}



int 
alloc_color_cells(defaultcolormap)
    Colormap defaultcolormap;
{
  unsigned long pixels[255];
  int npixels = 255;
  for ( ; ; ) 
  {
    if (npixels == 0) return(255);
    if (XAllocColorCells(gDisplay, defaultcolormap, 0, NULL, 0, 
			 pixels, npixels) == 0)
    {
      --npixels;
      continue;
    }
    return (255-npixels);
  }
}


void 
build_Xcolormap(type)
    int type;
{
  int i;

  for (i = 0 ; i < 256; i++)
  {
    Colors[i].red = mapedit_red[i] << 8;
    Colors[i].green = mapedit_green[i] << 8;
    Colors[i].blue = mapedit_blue[i] << 8;
  }
  if (type == 1)
  {
    Colors[WHITE].red = Colors[WHITE].green = Colors[WHITE].blue = 65535;
    Colors[1].red = Colors[1].green = Colors[1].blue = 0;
  }
  else if (type == 2)
  {
    /* on ne modifie pas les premieres positions de la DefaultColormap qui */
    /* sont deja allouees. Les positions restantes de la table de couleur  */
    /* contiennent les nouvelles valeurs.				   */

    if (numcolors>=50)
     XQueryColors(gDisplay, Defaultcolormap, Colors, 50);
    else 
     XQueryColors(gDisplay, Defaultcolormap, Colors, numcolors);
  }

  XStoreColors (gDisplay, Mapedit_colormap, Colors, MAXCOLORS);
}



static void
set_one_items(type, tab_widgets, f, rh, gl, bs)
int type;
xs_struc_mapedit *tab_widgets;
int f, rh, gl, bs ;
{
  Arg args[MAX_ARGS];
  int n;
  char *repstring;

  repstring = (char *) malloc (20);
  
  sprintf (repstring, "%d", f); 
  XmTextSetString (tab_widgets->FROM_TO_text[0], repstring);

    switch (type)
    {
      case RGB : 
	n = 0;
	XtSetArg(args[n],XmNforeground,0); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("R :",
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetValues(tab_widgets->RGB1_label[0], args, n);
	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("G :",
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetValues(tab_widgets->RGB1_label[1], args, n);
	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("B :",
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetValues(tab_widgets->RGB1_label[2], args, n);
	n = 0;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("255",
			XmSTRING_DEFAULT_CHARSET)); n++;	
	XtSetValues(tab_widgets->label255_1[0], args, n);
	XtSetValues(tab_widgets->label255_1[1], args, n);
	XtSetValues(tab_widgets->label255_1[2], args, n);
	n = 0;
	XtSetArg(args[n],XmNmaximum,255); n++;
	XtSetArg(args[n],XmNscaleWidth,300); n++; /*256*/
	XtSetArg(args[n],XmNforeground,0); n++;
	XtSetArg(args[n],XmNvalue, rh); n++;
	XtSetValues(tab_widgets->Scale1[0], args, n);
	tab_widgets->ValueScale1[0] = rh;
	n = 3;
	XtSetArg(args[n],XmNvalue, gl); n++;
	XtSetValues(tab_widgets->Scale1[1], args, n);
	tab_widgets->ValueScale1[1] = gl;
	n = 3;
	XtSetArg(args[n],XmNvalue, bs); n++;
	XtSetValues(tab_widgets->Scale1[2], args, n);
	tab_widgets->ValueScale1[2] = bs;
	break;
	
      case HLS : 
	n = 0;
	XtSetArg(args[n],XmNforeground,0); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("H :",
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetValues(tab_widgets->RGB1_label[0], args, n);
	n = 0;
	XtSetArg(args[n],XmNforeground,0); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("L :",
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetValues(tab_widgets->RGB1_label[1], args, n);
	n = 0;
	XtSetArg(args[n],XmNforeground,0); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("S :",
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetValues(tab_widgets->RGB1_label[2], args, n);
	n = 0;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("359",
			XmSTRING_DEFAULT_CHARSET)); n++;	
	XtSetValues(tab_widgets->label255_1[0], args, n);
	n = 0;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("100",
			XmSTRING_DEFAULT_CHARSET)); n++;	
	XtSetValues(tab_widgets->label255_1[1], args, n);
	XtSetValues(tab_widgets->label255_1[2], args, n);
	n = 0;
	XtSetArg(args[n],XmNforeground, 0); n++;
	XtSetArg(args[n],XmNscaleWidth,395); n++;
	XtSetArg(args[n],XmNmaximum,359); n++;
	XtSetArg(args[n],XmNvalue, rh); n++;
	XtSetValues(tab_widgets->Scale1[0], args, n);
	tab_widgets->ValueScale1[0] = rh;
	n = 2;
	XtSetArg(args[n],XmNmaximum,100); n++;
	XtSetArg(args[n],XmNvalue, gl); n++;
	XtSetValues(tab_widgets->Scale1[1], args, n);
	tab_widgets->ValueScale1[1] = gl;
	n =3;
	XtSetArg(args[n],XmNvalue, bs); n++;		
	XtSetValues(tab_widgets->Scale1[2], args, n);
	tab_widgets->ValueScale1[2] = bs;
	break;
      }
  free (repstring);
  
}




static void
set_mult_items(type, tab_widgets, f0, rh0, gl0, bs0, f1, rh1, gl1, bs1)
int type;
xs_struc_mapedit *tab_widgets;
int f0, f1, rh0, rh1, gl0, gl1, bs0, bs1 ;
{
  Arg args[MAX_ARGS];
  int n;
  char *repstring;
  
  repstring = (char *) malloc (20);

  sprintf (repstring, "%d", f0); 
  XmTextSetString (tab_widgets->FROM_TO_text[0], repstring);
  sprintf (repstring, "%d", f1); 
  XmTextSetString (tab_widgets->FROM_TO_text[1], repstring);

    switch (type)
    {
      case RGB : 
	n = 0;
	XtSetArg(args[n],XmNforeground,0); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("R :",
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetValues(tab_widgets->RGB1_label[0], args, n);
	XtSetValues(tab_widgets->RGB2_label[0], args, n);
	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("G :",
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetValues(tab_widgets->RGB1_label[1], args, n);
	XtSetValues(tab_widgets->RGB2_label[1], args, n);
	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("B :",
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetValues(tab_widgets->RGB1_label[2], args, n);
	XtSetValues(tab_widgets->RGB2_label[2], args, n);
	n = 0;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("255",
			XmSTRING_DEFAULT_CHARSET)); n++;	
	XtSetValues(tab_widgets->label255_1[0], args, n);
	XtSetValues(tab_widgets->label255_1[1], args, n);
	XtSetValues(tab_widgets->label255_1[2], args, n);
	XtSetValues(tab_widgets->label255_2[0], args, n);
	XtSetValues(tab_widgets->label255_2[1], args, n);
	XtSetValues(tab_widgets->label255_2[2], args, n);
	n = 0;
	XtSetArg(args[n],XmNmaximum,255); n++;
	XtSetValues(tab_widgets->Scale1[0], args, n);
	XtSetValues(tab_widgets->Scale2[0], args, n);
	XtSetValues(tab_widgets->Scale1[1], args, n);
	XtSetValues(tab_widgets->Scale2[1], args, n);
	XtSetValues(tab_widgets->Scale1[2], args, n);
	XtSetValues(tab_widgets->Scale2[2], args, n);
	n= 0;
	XtSetArg(args[n],XmNscaleWidth,300); n++;
	XtSetArg(args[n],XmNforeground,0); n++;
	XtSetArg(args[n],XmNvalue, rh0); n++;
	XtSetValues(tab_widgets->Scale1[0], args, n);
	tab_widgets->ValueScale1[0] = rh0;
	n = 2;
	XtSetArg(args[n],XmNvalue, rh1); n++;
	XtSetValues(tab_widgets->Scale2[0], args, n);
	tab_widgets->ValueScale2[0] = rh1;
	n = 2;
	XtSetArg(args[n],XmNvalue, gl0); n++;
	XtSetValues(tab_widgets->Scale1[1], args, n);
/*	XmScaleSetValue (tab_widgets->Scale1[1],gl0); */
	tab_widgets->ValueScale1[1] = gl0;
	n = 2;
	XtSetArg(args[n],XmNvalue, gl1); n++;
	XtSetValues(tab_widgets->Scale2[1], args, n);
	tab_widgets->ValueScale2[1] = gl1;
	n = 2;
	XtSetArg(args[n],XmNvalue, bs0); n++;
	XtSetValues(tab_widgets->Scale1[2], args, n);
	tab_widgets->ValueScale1[2] = bs0;
	n = 2;
	XtSetArg(args[n],XmNvalue, bs1); n++;
	XtSetValues(tab_widgets->Scale2[2], args, n);
	tab_widgets->ValueScale2[2] = bs1;
	break;
	
      case HLS : 
	n = 0;
	XtSetArg(args[n],XmNforeground,0); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("H :",
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetValues(tab_widgets->RGB1_label[0], args, n);
	XtSetValues(tab_widgets->RGB2_label[0], args, n);
	n = 0;
	XtSetArg(args[n],XmNforeground,0); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("L :",
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetValues(tab_widgets->RGB1_label[1], args, n);
	XtSetValues(tab_widgets->RGB2_label[1], args, n);
	n = 0;
	XtSetArg(args[n],XmNforeground,0); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("S :",
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetValues(tab_widgets->RGB1_label[2], args, n);
	XtSetValues(tab_widgets->RGB2_label[2], args, n);
	n = 0;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("359",
			XmSTRING_DEFAULT_CHARSET)); n++;	
	XtSetValues(tab_widgets->label255_1[0], args, n);
	XtSetValues(tab_widgets->label255_2[0], args, n);
	n = 0;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("100",
			XmSTRING_DEFAULT_CHARSET)); n++;	
	XtSetValues(tab_widgets->label255_1[1], args, n);
	XtSetValues(tab_widgets->label255_1[2], args, n);
	XtSetValues(tab_widgets->label255_2[1], args, n);
	XtSetValues(tab_widgets->label255_2[2], args, n);
	n = 0;
	XtSetArg(args[n],XmNforeground, 0); n++;
	XtSetArg(args[n],XmNscaleWidth,395); n++;
	XtSetArg(args[n],XmNmaximum,359); n++;
	XtSetArg(args[n],XmNvalue, rh0); n++;
	XtSetValues(tab_widgets->Scale1[0], args, n);
	tab_widgets->ValueScale1[0] = rh0;
	n = 3;
	XtSetArg(args[n],XmNvalue, rh1); n++;	
	XtSetValues(tab_widgets->Scale2[0], args, n);
	tab_widgets->ValueScale2[0] = rh1;
	n = 2;
	XtSetArg(args[n],XmNmaximum,100); n++;
	XtSetArg(args[n],XmNvalue, gl0); n++;
	XtSetValues(tab_widgets->Scale1[1], args, n);
	tab_widgets->ValueScale1[1] = gl0;
	n =3;
	XtSetArg(args[n],XmNvalue, gl1); n++;		
	XtSetValues(tab_widgets->Scale2[1], args, n);
	tab_widgets->ValueScale2[1] = gl1;
	n =3;
	XtSetArg(args[n],XmNvalue, bs0); n++;		
	XtSetValues(tab_widgets->Scale1[2], args, n);
	tab_widgets->ValueScale1[2] = bs0;
	n =3;
	XtSetArg(args[n],XmNvalue, bs1); n++;		
	XtSetValues(tab_widgets->Scale2[2], args, n);
	tab_widgets->ValueScale2[2] = bs1;
	break;
	
      }
  free (repstring);
  
}

static
void Manage_TO(show)
    int show;
{
  if (show) XtManageChildren(ChildrenToManage, 15); 
  else XtUnmanageChildren(ChildrenToManage, 15); 
}



/******************************************************
/   activateCallback for Widget  map_editing
/*****************************************************/

void
Set_map_edit(map_editing_widget, tab_widgets, callData)
	Widget map_editing_widget;
        xs_struc_mapedit *tab_widgets;
	caddr_t callData;
{
  int k, n0, n1, h0,h1,l0,l1,s0,s1 ;
  for (k=0;k < 4 ; k++)
    if (map_editing_widget == tab_widgets->map_type[k])
      switch (k)
      {
      case 0:  /*RGB_multi*/
	if (mode == RM) return ;
	n0 = atoi (XmTextGetString (tab_widgets->FROM_TO_text[0]));
	n1 = atoi (XmTextGetString (tab_widgets->FROM_TO_text[1]));
        if (FREEZE_ON)
	     set_mult_items(RGB, tab_widgets, n0, 
			    cred[0], cgreen[0], cblue[0],
			    n1, cred[1], cgreen[1], cblue[1]) ;	
	else
	     set_mult_items(RGB, tab_widgets, n0, 
			    mapedit_red[n0], mapedit_green[n0], 
			    mapedit_blue[n0],
			    n1, mapedit_red[n1], mapedit_green[n1], 
			    mapedit_blue[n1]) ;
	Manage_TO(1);
	arrows(n0*2, n1*2);
	mode = RM;
       break;
      case 1:  /*RGB_one*/
	if (mode == RO) return ;
	n0 = atoi (XmTextGetString (tab_widgets->FROM_TO_text[0]));
	if (FREEZE_ON)
	    set_one_items(RGB,tab_widgets, n0, 
			  one_cred, one_cgreen, one_cblue) ;
	else
	    set_one_items(RGB,tab_widgets, n0,
			  mapedit_red[n0],mapedit_green[n0],mapedit_blue[n0]);

	Manage_TO(0);
	one_arrow(n0) ;
	mode = RO;
       break;
      case 2:  /*HLS_multi*/
	if (mode == HM) return ;
	n0 = atoi (XmTextGetString (tab_widgets->FROM_TO_text[0]));
	n1 = atoi (XmTextGetString (tab_widgets->FROM_TO_text[1]));
	if (FREEZE_ON)
	{
	   RGB_to_HLS(cred[0], cgreen[0], cblue[0],&h0,&l0,&s0);
	   RGB_to_HLS(cred[1], cgreen[1], cblue[1],&h1,&l1,&s1);
	}
	else
	{
	   RGB_to_HLS(mapedit_red[n0], mapedit_green[n0], 
		      mapedit_blue[n0], &h0,&l0,&s0) ;
	   RGB_to_HLS(mapedit_red[n1], mapedit_green[n1], 
		      mapedit_blue[n1], &h1,&l1,&s1) ;  
	 }
	set_mult_items(HLS,tab_widgets, n0, h0, l0, s0, n1, h1, l1, s1);

        Manage_TO(1);
	arrows(n0*2, n1*2) ;
	mode = HM;
       break;
      case 3:  /*HLS_one*/
	if (mode == HO) return ;
	n0 = atoi (XmTextGetString (tab_widgets->FROM_TO_text[0]));
	if (FREEZE_ON)
	   RGB_to_HLS(one_cred, one_cgreen, one_cblue,&h0,&l0,&s0) ;
	else
	   RGB_to_HLS(mapedit_red[n0], mapedit_green[n0], 
		      mapedit_blue[n0], &h0,&l0,&s0); 
	
	set_one_items(HLS,tab_widgets, n0 , h0, l0, s0);	

        Manage_TO(0);	
	one_arrow(n0) ;
	mode = HO;
       break;
     }
}




/******************************************************
/   activateCallback for Widget  mapedit_LOAD 
/*****************************************************/

void
mapedit_LOAD_callb(LOAD, tab_widgets, callData)
	Widget LOAD;
        xs_struc_mapedit *tab_widgets;
	caddr_t callData;
{
  FILE *fp;
  char c;
  int  nb,r,g,b;

  char *nomfile;

  if (nomfile != NULL) free (nomfile);

  nomfile = XmTextGetString (tab_widgets->File);

  if (strcmp (nomfile, "") != 0)
    {
      strcat(nomfile, ".map");
      if ((fp = fopen(nomfile, "r")) == NULL) return;
      else 
	{
	  fread(mapedit_red,sizeof (unsigned char),256,fp) ;
	  fread(mapedit_green,sizeof(unsigned char),256,fp) ;
	  fread(mapedit_blue,sizeof(unsigned char),256,fp) ;

	  Colors[WHITE].red = Colors[WHITE].green = Colors[WHITE].blue = 65535 ;
	  Colors[1].red = Colors[1].green = Colors[1].blue = 0 ;

	  sprintf(buf, paneltabs[308],nomfile);
	  write_master(buf) ;

	  fclose(fp);
	  set_mult_items(RGB, tab_widgets, 0, mapedit_red[0], 
			 mapedit_green[0], mapedit_blue[0],
			 255, mapedit_red[255], mapedit_green[255], 
			 mapedit_blue[255]) ;
	
	  Manage_TO(1);
	  mode = RM;
	  install_mapcolormap();  
	}
    }
  free (nomfile);
}


/******************************************************
/   activateCallback for Widget  mapedit_SAVE
/*****************************************************/

void
mapedit_SAVE_callb(SAVE, tab_widgets, callData)
	Widget SAVE;
        xs_struc_mapedit *tab_widgets;
	caddr_t callData;
{
  FILE *fp;

  char *nomfile;

  if (nomfile != NULL) free (nomfile);

  nomfile = XmTextGetString (tab_widgets->File);

  if (strcmp (nomfile, "") != 0)
  {
    strcat(nomfile, ".map");
    if ((fp = fopen(nomfile, "r")) != NULL) 
    { 
      fclose (fp); 
      return;	
    }  
    if ((fp = fopen(nomfile, "w")) != NULL) 
    {
      fwrite(mapedit_red,sizeof(unsigned char),256,fp) ;
      fwrite(mapedit_green,sizeof(unsigned char),256,fp) ;
      fwrite(mapedit_blue,sizeof(unsigned char),256,fp) ;

      sprintf(buf, paneltabs[310], nomfile) ;
      write_master(buf) ;
      fclose(fp);
    }
    else 
      write_erreur(986);
  }

  XtFree (nomfile);
}



/******************************************************
/   activateCallback for Widget  mapedit_HELP
/*****************************************************/

void
mapedit_HELP_callb(HELP, Help_Mapedit, callData)
	Widget HELP;
        Widget Help_Mapedit;
	caddr_t callData;
{
  XtManageChild(Help_Mapedit);
}


/******************************************************
/   activateCallback for Widget  mapedit_QUIT
/*****************************************************/

void
mapedit_QUIT_callb(QUIT, mapedit_mainwidget, callData)
	Widget QUIT;
        Widget mapedit_mainwidget;
	caddr_t callData;
{
  XUninstallColormap(gDisplay, Mapedit_colormap);
  XtUnmanageChild (mapedit_mainwidget);
  flag_mapedit_open = false;
}


void
change_text_value(text, tab_widgets, callData)
	Widget text;
        xs_struc_mapedit *tab_widgets;
	caddr_t callData;
{ 
  Arg args[MAX_ARGS];
  int n, k;
  int val;

  for (k=0;k < 2 ; k++)
    if (text == tab_widgets->FROM_TO_text[k])
      {
	val = atoi (XmTextGetString (tab_widgets->FROM_TO_text[k]));
	if (k == 0)
	  {
	    n = 0;
	    XtSetArg(args[n],XmNvalue, mapedit_red[val]); n++;
	    XtSetValues(tab_widgets->Scale1[0], args, n);
	    tab_widgets->ValueScale1[0] = mapedit_red[val];
	    n = 0;
	    XtSetArg(args[n],XmNvalue, mapedit_green[val]); n++;
	    XtSetValues(tab_widgets->Scale1[1], args, n);
	    tab_widgets->ValueScale1[1] = mapedit_green[val];
	    n = 0;
	    XtSetArg(args[n],XmNvalue, mapedit_blue[val]); n++;
	    XtSetValues(tab_widgets->Scale1[2], args, n);
	    tab_widgets->ValueScale1[2] = mapedit_blue[val];
	  }
	else
	  {
	    n = 0;
	    XtSetArg(args[n],XmNvalue, mapedit_red[val]); n++;
	    XtSetValues(tab_widgets->Scale2[0], args, n);
	    tab_widgets->ValueScale2[0] = mapedit_red[val];
	    n = 0;
	    XtSetArg(args[n],XmNvalue, mapedit_green[val]); n++;
	    XtSetValues(tab_widgets->Scale2[1], args, n);
	    tab_widgets->ValueScale2[1] = mapedit_green[val];
	    n = 0;
	    XtSetArg(args[n],XmNvalue, mapedit_blue[val]); n++;
	    XtSetValues(tab_widgets->Scale2[2], args, n);
	    tab_widgets->ValueScale2[2] = mapedit_blue[val];
	  }
      }
  arrows(atoi (XmTextGetString (tab_widgets->FROM_TO_text[0]))*2,
         atoi (XmTextGetString (tab_widgets->FROM_TO_text[1]))*2);
  
}
  

void 
install_mapcolormap()
{
  build_Xcolormap(2);
  XInstallColormap(gDisplay, Mapedit_colormap);
}

 
void
change_field(scale, tab_widgets, callData)
	Widget scale;
        xs_struc_mapedit *tab_widgets;
	XmScaleCallbackStruct * callData;
{
  int n0, n1, k;

  switch(mode)
    {
    case RM:
    case HM:
      for (k=0;k < 3 ; k++)
	if (scale == tab_widgets->Scale1[k])
	  {
	    tab_widgets->ValueScale1[k] = callData->value;
	    n0 = atoi (XmTextGetString (tab_widgets->FROM_TO_text[0]));
	    n1 = atoi (XmTextGetString (tab_widgets->FROM_TO_text[1]));
	    change_multiple_field(n0,n1,tab_widgets->ValueScale1[0],
				  tab_widgets->ValueScale2[0],
				  tab_widgets->ValueScale1[1],
				  tab_widgets->ValueScale2[1],
				  tab_widgets->ValueScale1[2],
				  tab_widgets->ValueScale2[2]);
	    build_Xcolormap(1);
	    XInstallColormap(gDisplay, Mapedit_colormap);
	    return;
	  }
      for (k=0;k < 3 ; k++)
	if (scale == tab_widgets->Scale2[k])
	  {
	    tab_widgets->ValueScale2[k] = callData->value;  
	    n0 = atoi (XmTextGetString (tab_widgets->FROM_TO_text[0]));
	    n1 = atoi (XmTextGetString (tab_widgets->FROM_TO_text[1]));
	    change_multiple_field(n0,n1,tab_widgets->ValueScale1[0],
				  tab_widgets->ValueScale2[0],
				  tab_widgets->ValueScale1[1],
				  tab_widgets->ValueScale2[1],
				  tab_widgets->ValueScale1[2],
				  tab_widgets->ValueScale2[2]);
	    build_Xcolormap(1);
	    XInstallColormap(gDisplay, Mapedit_colormap);
	  }
      break;
    case RO:
    case HO:
      for (k=0;k < 3 ; k++)
	if (scale == tab_widgets->Scale1[k])
         tab_widgets->ValueScale1[k] = callData->value;  
      n0 = atoi (XmTextGetString (tab_widgets->FROM_TO_text[0]));
      change_one_field(n0, tab_widgets->ValueScale1[0], 
		       tab_widgets->ValueScale1[1], 
		       tab_widgets->ValueScale1[2]);
      build_Xcolormap(1);
      XInstallColormap(gDisplay, Mapedit_colormap);
      break; 
    }   
}



void
install_mapeditcolormap(win, callData, event)
    Widget          win;
    caddr_t 	    callData;
    XEvent          *event;
{
  switch (event->type)
  {
  case EnterNotify:
    install_mapcolormap();
    break;
      
  case LeaveNotify:
    XUninstallColormap(gDisplay, Mapedit_colormap);
    break;
  default:
    break;
  }
} 



void
install_newcolormap(win, tab_widgets, event)
    Widget          win;
    xs_struc_mapedit *tab_widgets;
    XEvent          *event;
    
{
  switch (event->type)
  {
  case EnterNotify:
    build_Xcolormap(0);
    XInstallColormap(gDisplay, Mapedit_colormap);
    break;  
  case LeaveNotify:
    install_mapcolormap();
    break;
  default:
    break;
  }
}


void
init_red_green_blue(tab_widgets)
    xs_struc_mapedit *tab_widgets;
{
  int i;

  Defaultcolormap = XDefaultColormap(gDisplay, XDefaultScreen(gDisplay));

  mapedit_red[WHITE] = mapedit_green[WHITE] = mapedit_blue[WHITE] = 255;
  mapedit_red[1] = mapedit_green[1] = mapedit_blue[1] = 0;
  
  for ( i = 2 ; i < 256 ; i++) 
     mapedit_red[i] = mapedit_green[i] = mapedit_blue[i] = i;

  ChildrenToManage[0] = tab_widgets->FROM_TO_label[0];
  ChildrenToManage[1] = tab_widgets->FROM_TO_label[1];
  ChildrenToManage[2] = tab_widgets->FROM_TO_text[1];
  for (i = 0;i < 3; i++){ 
    ChildrenToManage[i+3] = tab_widgets->RGB2_label[i]; 
    ChildrenToManage[i+6] = tab_widgets->label0_2[i]; 
    ChildrenToManage[i+9] = tab_widgets->label255_2[i]; 
    ChildrenToManage[i+12] = tab_widgets->Scale2[i]; 
  }
  numcolors = alloc_color_cells(Defaultcolormap);
  
}


/****************************************************************/
/*								*/
/* nom	    : draw_arrow					*/   
/*								*/								
/* fonction : dessine une fleche pointant vers le bas		*/ 
/*								*/								
/* entree   : int x , colour					*/								
/*								*/		

/* return   : ---						*/								
/*								*/								
/* routines : ---						*/								
/*								*/								
/****************************************************************/

static void
draw_arrow(drawing, x) 
Widget drawing;
int	x ;
{
    XSetForeground(gDisplay, default_gc , 50);
    XDrawLine (gDisplay, flechepixmap, default_gc, x,4,x,18);
    XDrawLine (gDisplay, flechepixmap, default_gc, x+1,4,x+1,18);
    XDrawLine (gDisplay, flechepixmap, default_gc, x,18,x-5,13);
    XDrawLine (gDisplay, flechepixmap, default_gc, x+1,18,x-4,13);
    XDrawLine (gDisplay, flechepixmap, default_gc, x,18,x+5,13);
    XDrawLine (gDisplay, flechepixmap, default_gc, x+1,18,x+6,13);

    XCopyArea (gDisplay, flechepixmap, 
	       XtWindow(drawing),  default_gc, 0, 0, 
	       512, 20, 0, 0);
}


/****************************************************************/
/*								*/
/* nom	    : erase_arrows					*/   
/*								*/								
/* fonction : efface les fleches dans le Pixwin arrowpw		*/ 
/*								*/								
/* entree   : ---						*/								
/*								*/								
/* return   : ---						*/								
/*								*/								
/* routines : ---						*/								
/*								*/								
/****************************************************************/

static void
erase_arrows(drawing)
    Widget drawing;
{
    XSetForeground(gDisplay, default_gc , 255);
    XFillRectangle (gDisplay,flechepixmap , default_gc, 0, 0, 512, 20);
    XCopyArea (gDisplay, flechepixmap, 
	       XtWindow(drawing),  default_gc, 0, 0, 
	       512, 20, 0, 0);
    XSetForeground(gDisplay, default_gc , 0);
}




void
get_field (win, tab_widgets, event)
    Widget          win;
    xs_struc_mapedit *tab_widgets;
    XEvent          *event;
{
  int	    xpos,
	    x,
	    xleft, xright;

  char    *buftemp;

  buftemp = (char *) calloc (3, sizeof *buftemp) ;
  xpos = event->xmotion.x;
  
  switch (event->type){
    case ButtonPress:
      if (event->xbutton.button == Button2)
      {
	switch (mode)
	{	    
	    case RM : fs_proc(atoi(XmTextGetString (
					    tab_widgets->FROM_TO_text[0])),
			      atoi(XmTextGetString (
					    tab_widgets->FROM_TO_text[1])), 
			      tab_widgets) ;
		      break ;

	    case HM : fs_proc(atoi(XmTextGetString (
					    tab_widgets->FROM_TO_text[0])),
			      atoi(XmTextGetString (
					    tab_widgets->FROM_TO_text[1])), 
			      tab_widgets) ;
		      break ;

	    case RO : of_proc(atoi(XmTextGetString (
			      tab_widgets->FROM_TO_text[0])), tab_widgets) ;
		      break ;

	    case HO : of_proc(atoi(XmTextGetString (
			      tab_widgets->FROM_TO_text[0])), tab_widgets) ;
		      break ;
	}
      }
    else
    {
	if (MULT_on(mode))
	{
	    x = (int) rint((double)xpos/2)  ;

	    xleft = atoi(XmTextGetString (tab_widgets->FROM_TO_text[0]));
	    xright = atoi(XmTextGetString (tab_widgets->FROM_TO_text[1]));

	    if ((xleft >= 0) && (xleft <= 255) && 
		(xright >= 0) && (xright <= 512))
	    {              
		if (event->xbutton.button == Button3)
		{
			 
		    if (x>= xleft)
		    {
			if (x > 255)
			    sprintf(buftemp,"255") ;
			else
			{
			    sprintf(buftemp,"%d",x) ;
			}

			XmTextSetString (tab_widgets->FROM_TO_text[1], 
					 buftemp);
		    }
		    else
		    {
			if (x < 0)
			    sprintf(buftemp, "0") ;
			else
			    sprintf(buftemp,"%d",x) ;

			XmTextSetString (tab_widgets->FROM_TO_text[0], 
					 buftemp);
			sprintf(buftemp,"%d",xleft) ;
			XmTextSetString (tab_widgets->FROM_TO_text[1], 
					 buftemp);
		    }

		    if (FREEZE_ON)
		    {
		      int xbisleft, xbisright;
		        xbisleft = atoi (XmTextGetString (
					   tab_widgets->FROM_TO_text[0]));
		        xbisright = atoi (XmTextGetString (
					   tab_widgets->FROM_TO_text[1]));
			arrows(xbisleft*2, xbisright*2) ;
		    }
		    
		    else
			fields_proc(atoi (XmTextGetString (
					     tab_widgets->FROM_TO_text[0])),
				    atoi (XmTextGetString (
					     tab_widgets->FROM_TO_text[1])),
				    tab_widgets) ;
		}
		else 
		if (event->xbutton.button == Button1)
		{
		    if (x<=xright)
		    {
			if (x < 0)
			    sprintf(buftemp, "0") ;
			else
			    sprintf(buftemp,"%d",x) ;

			XmTextSetString (tab_widgets->FROM_TO_text[0], 
					 buftemp);
		    }
		    else
		    {
			if (x > 255)
			    sprintf(buftemp,"255") ;
			else
			    sprintf(buftemp,"%d",x) ;

			XmTextSetString (tab_widgets->FROM_TO_text[1], 
					 buftemp);
			sprintf(buftemp,"%d",xright) ;
			XmTextSetString (tab_widgets->FROM_TO_text[0], 
					 buftemp);
		    }

		    if (FREEZE_ON)
		    {
		      int xbisleft, xbisright;
		        xbisleft = atoi (XmTextGetString (
					  tab_widgets->FROM_TO_text[0]));
		        xbisright = atoi (XmTextGetString (
					  tab_widgets->FROM_TO_text[1]));
			arrows(xbisleft*2, xbisright*2) ;
		    }

		    else
		       fields_proc(atoi (XmTextGetString (
					  tab_widgets->FROM_TO_text[0])), 
				   atoi (XmTextGetString (
					  tab_widgets->FROM_TO_text[1])), 
				   tab_widgets) ;
		}
	    }
	    else
		write_master(paneltabs[311]) ;
	}
	else  
	{	   
            x = (int) rint((double)xpos/2) ;

	    if (event->xbutton.button == Button3 || 
		event->xbutton.button == Button1)
	    {
		if (x < 0)
		    sprintf(buftemp, "0") ;
		else if (x > 255)
                    sprintf(buftemp, "255") ;
		else
		    sprintf(buftemp,"%3d",x) ; 

		XmTextSetString (tab_widgets->FROM_TO_text[0], buftemp);
		if (FREEZE_ON)
		{
		   int xbis;
		   xbis = atoi (XmTextGetString (tab_widgets->FROM_TO_text[0]));
		   one_arrow(xbis) ;
		}
		
		else
		    one_field_proc(atoi (XmTextGetString (tab_widgets->FROM_TO_text[0])), tab_widgets) ;
	    }
	}
      }
      
    } 
  free (buftemp);
}



/****************************************************************/
/*								*/
/* nom	    : arrows						*/   
/*								*/	          
/* fonction : dessine les fleches delimitant la zone de couleurs*/ 
/*							    	*/	 
/* entree   : ---						*/								
/*								*/								
/* globales : mult_number_item[]				*/								
/*							    	*/								
/* return   : ---						*/								
/*								*/								
/* routines : erase_arrows, draw_arrow				*/								
/*								*/								
/****************************************************************/

static void
arrows (xleft,xright)
    int	    xleft,xright;
{
    erase_arrows(XmDrawingAreafleche) ;
    draw_arrow(XmDrawingAreafleche, xright);  
    draw_arrow(XmDrawingAreafleche, xleft) ;
}


/****************************************************************/
/*								*/
/* nom	    : one_arrow						*/   
/*								*/								
/* fonction : dessine la fleche pointant sur un champ		*/ 
/*							    	*/								
/* entree   : ---						*/								
/*								*/								
/* globales : one_number_item					*/								
/*							    	*/								
/* return   : ---						*/								
/*								*/								
/* routines : erase_arrows, draw_arrow				*/								
/*								*/								
/****************************************************************/

static void 
one_arrow(num) 
{
  int	    xpos;

    if ((num >= 0) && (num <= 255))
    {    
	xpos = 2 * num ; 
	erase_arrows(XmDrawingAreafleche) ;
	draw_arrow(XmDrawingAreafleche, xpos);  	
    }
    else
	write_master(paneltabs[311]) ;
}


/****************************************************************/
/*								*/
/* nom	    : change_one_field					*/   
/*								*/								
/* fonction : change la table de couleur pointee par la fleche  */ 
/*	      selon la valeur des sliders			*/
/*								*/
/* entree   : ---						*/								
/*								*/								
/* globales : one_number_item,	one_red_H_slider,		*/
/*	      one_green_L_slider, one_blue_S_slider, mode	*/								
/*							    	*/								
/* return   : ---						*/								
/*								*/								
/* routines : fix_colourRGB, fix_colourHLS			*/								
/*	      freeze_on, RGB_on					*/								
/*								*/								
/****************************************************************/

static void
change_one_field(n,rh,gl,bs)
int	n,rh,gl,bs ;
{
    float h,l,s ;

    if ((n >= 0) && (n <= 255))
    { 	
 	if (RGB_on(mode))
	{

	    if (FREEZE_ON)
	    {
		one_cred = rh ; 
		one_cgreen = gl ;
		one_cblue = bs ;
	    }

	    fix_colourRGB(n, rh, gl, bs) ;	    
	}
	else
	{
	    h = (float) rh *1.0 ;
	    l = (float) gl/100 ;
	    s = (float) bs/100 ;	
	    fix_colourHLS(n,h,l,s) ;

	    if (FREEZE_ON)
	    {
		one_cred = mapedit_red[n] ;
		one_cblue = mapedit_blue[n] ;
		one_cgreen = mapedit_green[n] ;
	    }	    
	}

   }
    else
	write_master(paneltabs[311]) ;
}


/****************************************************************/
/*								*/
/* nom	    : change_multiple_field				*/   
/*								*/								
/* fonction : change la table de couleur entre les fleches	*/ 
/*	      selon la valeur des sliders			*/
/*								*/
/* entree   : ---						*/								
/*								*/								
/* globales : mult_number_item,	mult_red_H_slider,		*/
/*	      mult_green_L_slider, mult_blue_S_slider, mode	*/								
/*	      red[], green[], blue[],				*/								
/*	      cred[], cgreen[], cblue[],			*/								
/*							    	*/								
/* return   : ---						*/								
/*								*/								
/* routines : RGB_fix_mult_map, HLS_fix_mult_map		*/								
/*	      freeze_on,RGB_on					*/								
/*								*/								
/****************************************************************/

static void
change_multiple_field(n0,n1,rh0,rh1,gl0,gl1,bs0,bs1)
    int	    n0,n1,rh0,rh1,gl0,gl1,bs0,bs1;
{
    float   h0,h1,l0,l1,s0,s1 ;

    if ((n0 >= 0) && (n0 <= 255) && (n1 >= 0) && (n1 <= 255))
    {
	if (RGB_on(mode))
	{
	    if (n0 != n1)
	    RGB_fix_mult_map(n0,rh0,gl0,bs0,n1,rh1,gl1,bs1) ;

	    if (FREEZE_ON)
	    {
		cred[0] = rh0 ;
		cred[1] = rh1 ;
		cgreen[0] = gl0 ;
		cgreen[1] = gl1 ;
		cblue[0] = bs0 ;
		cblue[1] = bs1 ;
	    }
	}
	else
	{
	    h0 = (float) rh0 ; 
	    l0 = (float) gl0/100 ; 
	    s0 = (float) bs0/100 ; 

	    h1 = (float) rh1 ; 
	    l1 = (float) gl1/100 ; 
	    s1 = (float) bs1/100 ; 

	    if (n0 != n1)
	    HLS_fix_mult_map(n0,h0,l0,s0,n1,h1,l1,s1) ;

	    if (FREEZE_ON)
	    {
		cred[0] = mapedit_red[n0] ;
		cred[1] = mapedit_red[n1] ;
		cgreen[0] = mapedit_green[n0] ;
		cgreen[1] = mapedit_green[n1] ;
		cblue[0] = mapedit_blue[n0] ;
		cblue[1] = mapedit_blue[n1] ;    
	    }	    
	}
    }
    else
	write_master(paneltabs[311]) ;   
}



/****************************************************************/
/*								*/
/* nom	    : one_field_proc					*/   
/*								*/								
/* fonction : fait pointer la fleche sur le bon champ de la     */ 
/*	      table et met celle-ci a jour			*/								
/*								*/								
/* entree   : ---						*/								
/*								*/								
/* globales : one_number_item, one_red_H_slider,		*/
/*	      one_green_L_slider, one_blue_S_slider,		*/								
/*	      red[], green[], blue[],				*/								
/*	      mappw, mode					*/								
/*							    	*/								
/* return   : ---						*/								
/*								*/								
/* routines : RGB_on, one_arrow, RGB_to_HLS			*/								
/*								*/								
/****************************************************************/

static void 
one_field_proc(num, tab_widgets)
    int num;
    xs_struc_mapedit *tab_widgets;   
{
    int	    h, l, s;

    one_arrow(num) ;

    if ((num >= 0) && (num <= 255))
    {   
	if (RGB_on(mode))	
	  set_one_items(RGB,tab_widgets, num,mapedit_red[num],
		     mapedit_green[num],mapedit_blue[num]);
	else
	{    
	  RGB_to_HLS(mapedit_red[num], mapedit_green[num], mapedit_blue[num], &h, &l, &s) ;
	  set_one_items(HLS,tab_widgets, num , h, l, s);
	}
    }
    else
	write_master(paneltabs[311]) ;  
}


/****************************************************************/
/*								*/
/* nom	    : fields_proc					*/   
/*								*/								
/* fonction : fait pointer la fleche sur le bon champ de la     */ 
/*	      table et met celle-ci a jour			*/								
/*								*/								
/* entree   : ---						*/								
/*								*/								
/* globales : mult_number_item, mult_red_H_slider,		*/
/*	      mult_green_L_slider, mult_blue_S_slider,		*/								
/*	      red[], green[], blue[],				*/								
/*	      mappw, mode					*/								
/*							    	*/								
/* return   : ---						*/								
/*								*/								
/* routines : RGB_on, arrows, RGB_to_HLS			*/								
/*								*/								
/****************************************************************/

static void 
fields_proc(numl,numr, tab_widgets)
    int	    numl,numr;
    xs_struc_mapedit *tab_widgets;
{
    int	    h0,h1,l0,l1,s0,s1 ;

    arrows(numl*2, numr*2) ;

    if ((numl >= 0) && (numl <= 255) && (numr >= 0) && (numr <= 255))
    { 
	if (RGB_on(mode))
	    set_mult_items(RGB,tab_widgets, numl, mapedit_red[numl], 
			   mapedit_green[numl], mapedit_blue[numl], 
			   numr, mapedit_red[numr], mapedit_green[numr], 
			   mapedit_blue[numr]);
	else
	{
	    RGB_to_HLS(mapedit_red[numl], mapedit_green[numl], 
		       mapedit_blue[numl],&h0,&l0,&s0) ;
	    RGB_to_HLS(mapedit_red[numr], mapedit_green[numr], 
		       mapedit_blue[numr],&h1,&l1,&s1) ;

	    set_mult_items(HLS,tab_widgets, numl, h0, l0, s0, 
			   numr, h1, l1, s1);
	}
    }
    else
	write_master(paneltabs[311]) ;
 
}


/****************************************************************/
/*								*/
/* nom	    : of_proc()						*/   
/*								*/								
/* fonction : appelle les procedures de mise a jour d'un champ  */ 
/*								*/								
/* entree   : ---						*/								
/*								*/								
/* globales : one_number_item, one_cred, one_cgreen, one_cblue 	*/								
/*							    	*/								
/* return   : ---						*/								
/*								*/								
/* routines : one_field_proc, one_arrow,			*/								
/*	      change_one_field, fix_colourRGB, freeze_on	*/								
/*								*/								
/****************************************************************/

static void 
of_proc(n, tab_widgets) 
    int	n;
    xs_struc_mapedit *tab_widgets;
{

    if ((n >= 0) && (n <= 255))
    {		    
	one_arrow(n) ;

	if (FREEZE_ON)
	{
	    fix_colourRGB(n,one_cred, one_cgreen, one_cblue) ;
	    return ;
	}
	else
	    one_field_proc(n, tab_widgets) ;
    }   
    else
	write_master(paneltabs[311]) ;
}


/****************************************************************/
/*								*/
/* nom	    : fs_proc						*/   
/*								*/								
/* fonction : appelle les procedures de mise a jour des champs  */ 
/*								*/								
/* entree   : ---						*/								
/*								*/								
/* globales : mult_number_item[], cred[], cgreen[], cblue[] 	*/								
/*							    	*/								
/* return   : ---						*/								
/*								*/								
/* routines : fields_proc, arrows, freeze_on			*/								
/*	      change_multiple_field, RGB_fix_mult_map		*/								
/*								*/								
/****************************************************************/

static void 
fs_proc(n0,n1, tab_widgets) 
    int	    n0,n1;
    xs_struc_mapedit *tab_widgets;
{
    int	    temp ;
    char    *buftemp ;

    buftemp = (char *) calloc (3, sizeof *buftemp) ;

    if ((n0 >= 0) && (n0 <= 255) && (n1 >= 0) && (n1 <= 255))
    {
	arrows(n0*2, n1*2) ;
	if (n1 < n0)
	{
	    temp = n0 ;
	    n0 = n1 ;
	    n1 = temp ;
	    sprintf(buftemp,"%d",n0) ;
	    XmTextSetString (tab_widgets->FROM_TO_text[0], buftemp);
	    sprintf(buf,"%d",n1) ;
	    XmTextSetString (tab_widgets->FROM_TO_text[1], buftemp);
	}

	if (FREEZE_ON)
	{
	    if (n0 != n1)
		RGB_fix_mult_map(n0,cred[0],cgreen[0],cblue[0],
				 n1,cred[1],cgreen[1],cblue[1]) ;
	    return ;
	}    
	else
	{
	    fields_proc(atoi (XmTextGetString (tab_widgets->FROM_TO_text[0])),
			atoi (XmTextGetString (tab_widgets->FROM_TO_text[1])),
			tab_widgets);
	}
    }
    else
	write_master(paneltabs[311]) ;
    free (buftemp);
}






/*******************************************************************

	    procedures de gestion de couleurs RGB

*******************************************************************/


/****************************************************************/
/*								*/
/* nom	    : RGB_fix_mult_map					*/   
/*								*/								
/* fonction : change la table de couleur entre n1 et n2	en      */ 
/*	      interpolant lineairement ou logarithmiquement	*/
/*	      entre (r1,g1,b1) et (r2,g2,b2)			*/
/*								*/
/* entree   : int n1,n2,r1,g1,b1,r2,g2,b2			*/								
/*								*/								
/* globales : ---						*/								
/*							    	*/								
/* return   : ---						*/								
/*								*/								
/* routines : fix_colourRGB					*/								
/*								*/								
/****************************************************************/

static void
RGB_fix_mult_map(n1,r1,g1,b1,n2,r2,g2,b2)
int n1,n2,r1,r2,g1,g2,b1,b2 ;
{
    int	    i,u = 0, 
	    r,g,b,
            dr = r2 -r1 ,
	    dg = g2 -g1 ,
	    db = b2 -b1 ,
	    number_int = n2 - n1 ;

    float rvar, gvar, bvar, coeff ;

    if (LIN_ON)
    {
	rvar = (float) dr/number_int;
	gvar = (float) dg/number_int; 
	bvar = (float) db/number_int; 

    	for(i=n1 ; i<=n2 ; i++)
	{	      
	    r = r1 + (int) rint ((double) (u * rvar)) ;
	    g = g1 + (int) rint ((double) (u * gvar)) ;
	    b = b1 + (int) rint ((double) (u * bvar)) ;
	    fix_colourRGB(i,r,g,b) ;
	    u++ ;
	}
    }
    else
    {
    	for(i=n1 ; i<=n2 ; i++)
	{

	    coeff = (float) log ( 1 + ((float) u/number_int*(E - 1))) ;
	      
	    r = r1 + (int) rint ((double) ((float) dr*coeff)) ;
	    g = g1 + (int) rint ((double) ((float) dg*coeff)) ;
	    b = b1 + (int) rint ((double) ((float) db*coeff)) ;
	    fix_colourRGB(i,r,g,b) ;
	    u++ ;
	}
    }
}


/****************************************************************/
/*								*/								
/* nom	    : fix_colourRGB					*/								
/*							    	*/								
/* fonction : permet de gerer la table de couleur. "number"	*/ 
/*            designe le numero de la couleur dans la table.	*/
/*	      R,G,B sont les trois intensites de couleur qui	*/								
/*	      sont des entiers ( 0 - 255 )			*/								
/*								*/								
/* entree   : int number, R, G, B			    	*/								
/*								*/								
/* globales : ppw, spw, mappw, arrowpw  red[], green[], blue[]	*/								
/*								*/								
/* return   : ---						*/								
/*								*/								
/* routines : ---						*/
/*								*/								
/****************************************************************/

static void
fix_colourRGB(number,R,G,B) 
int number, R, G, B ;
{
  mapedit_red[number] = (unsigned char) R;
  mapedit_green[number] = (unsigned char) G;
  mapedit_blue[number] = (unsigned char) B;
}


/*******************************************************************

		procedures de gestion de couleurs HLS

********************************************************************/


/****************************************************************/
/*								*/
/* nom	    : HLS_fix_mult_map					*/   
/*								*/								
/* fonction : change la table de couleur entre n1 et n2	en      */ 
/*	      interpolant lineairement ou logarithmiquement	*/
/*	      entre (h1,l1,s1) et (h2,l2,s2)			*/
/*								*/
/* entree   : int n1,n2,h1,l1,s1,h2,l2,s2			*/								
/*								*/								
/* globales : ---						*/								
/*							    	*/								
/* return   : ---						*/								
/*								*/								
/* routines : fix_colourHLS					*/								
/*								*/								
/****************************************************************/

static void
HLS_fix_mult_map(n1,h1,l1,s1,n2,h2,l2,s2)
int n1,n2;
float h1,h2,l1,l2,s1,s2 ;
{
    int	    i,u = 0, 
	    number_int = n2 - n1;

    float   hvar, lvar, svar,
	    h,l,s, 
            dl = l2 -l1 ;

    hvar = (float) (h2 - h1)/number_int;
    svar = (float) (s2 - s1)/number_int;

    if (LIN_ON)
    {
	lvar = (float) dl/number_int; 
	for(i=n1 ; i<=n2 ; i++)
	{      
	    h = (float) h1 + u*hvar ;
	    l = (float) l1 + u*lvar ;
	    s = (float) s1 + u* svar ;
	    fix_colourHLS(i,h,l,s) ;
	    u++ ;
	}
    }
    else
    {
	for(i=n1 ; i<=n2 ; i++)
	{      
	    h = (float) h1 + u*hvar ;
	    l = (float) l1 + (dl*log(1 + ((float) u/number_int*(E - 1)))) ;
	    s = (float) s1 + u* svar ;		    
	    fix_colourHLS(i,h,l,s) ;
	    u++ ;
	}	
    }
}


/****************************************************************/
/*								*/
/* nom	    : fix_colourHLS					*/
/*							    	*/								
/* fonction : permet de gerer la table de couleur. "number"	*/ 
/*            designe le numero de la couleur dans la table et	*/
/*	      H, L, S sont les composantes (tous des reals)	*/								
/*	      H : 0.0 - 360.0					*/								
/*	      L : 0.0 - 1.0					*/								
/*	      S : 0.0 - 1.0					*/								
/*								*/								
/* entree   : int number : float H, L, S			*/								
/*								*/								
/* globales : ppw, , mappw, arrowpw, red[], green[], blue[]	*/								
/*								*/								
/* return   : ---						*/								
/*								*/								
/* routines : RGB						*/								
/*								*/								
/****************************************************************/

static void
fix_colourHLS(number,H,L,S) 
int number ;
float H,L,S ;
{
    register float  M1, M2; 
 
    float	    LS = L*S ;
                 
    if (L <= 0.5)
    {
	M2 = L + LS;
    }
    else
    {
	M2 = L + S - LS ;
    }

    M1 = 2*L - M2 ;

    mapedit_red[number] =  (unsigned char) rint ((double) RGBconv(H + 120,M1,M2) * 255);
    mapedit_green[number] = (unsigned char) rint ((double) RGBconv(H, M1,M2) * 255);
    mapedit_blue[number] = (unsigned char) rint ((double) RGBconv(H -120, M1, M2) * 255);
}


/****************************************************************/
/*								*/
/* nom	    : RGB_to_HLS					*/   
/*								*/								
/* fonction : converti une couleur donnee par RGB en couleur co-*/ 
/*	      dee selon HLS				        */								
/* entree   : unsigned char r,g,b				*/								
/*	      int h,l,s   : attention passage par reference !!	*/								
/*								*/								
/* globales : ---						*/								
/*							    	*/								
/* return   : ---						*/								
/*								*/								
/* routines : ---						*/								
/*								*/								
/****************************************************************/

static void
RGB_to_HLS(r,g,b,h,l,s) 
unsigned char r,g,b ;
int *h,*l,*s ;
{
    int	    m,m1,m2 ;
    float   M1,M2,
	    R,G,B,
	    H,L,S,
	    Cr,Cg,Cb ;

    m = max(r,g) ;
    m1 = max(m,b) ;
    M1 = (float) m1/255 ;

    m = min(r,g) ;
    m2 = min(m,b) ;
    M2 = (float) m2/255 ;

    L = (float) (M1 + M2)/2 ;

     /* determine the saturation */

    if (m1 == m2)    /* achromatic case */
    {
	S = 0 ;
	H = 0 ;
    }
    else	    /* chromatic case */
    {
	if (L <= 0.5)
	{
	    S = (float) (M1 - M2)/(M1 + M2);
	}
        else
	{
	    S = (float) (M1 - M2)/(2 - M1 - M2) ;
	}

        R = (float) r/255 ;
        G = (float) g/255 ;
        B = (float) b/255 ;

        Cr = (float)(M1 - R)/(M1 - M2) ;
        Cg = (float)(M1 - G)/(M1 - M2) ;
        Cb = (float)(M1 - B)/(M1 - M2) ;

	if (r == m1)
	    H = Cb - Cg ;
        else if (g == m1)
	    H = 2.0 + Cr - Cb ;
	else 
	    H = 4.0 + Cg -Cr ;

	H = (float) H*60.0 ;

	if (H < 0)
	    H = H + 360.0 ;
    }
    
    *h = (int) rint ((double) H * 1.0 ) ;
    *l = (int) rint ((double) L*100) ;
    *s = (int) rint ((double) S*100) ;
	
}


/*********************************************************************/
/*								     */
/* nom	    : RGBconv			  			     */
/*								     */
/* fonction : retouner une valeur dependant de H                     */
/*								     */
/* entree   : float H, M1, M2					     */
/*								     */
/* globales : ---					             */
/*								     */
/* return   : float Value				             */
/*								     */
/* routines : ---				          	     */
/*								     */
/*********************************************************************/

static float
RGBconv(H,M1,M2)

float H, M1, M2 ;

{
    float Value ;

    /* adjust correct range */

    if (H < 0) H = H + 360 ;
    if (H > 360) H = H - 360 ;

    /* determine the Value */

    if (H < 60) Value = M1 + (M2-M1)*H/60 ;
    if (H >= 60 && H < 180) Value = M2 ;
    if (H >= 180 && H < 240) Value = M1 + (M2 - M1)*(240 - H)/60 ;
    if (H >= 240 && H <= 360) Value = M1;

    return Value; 
}


/*******************************************************************

	    procedures de test de variables globales

*******************************************************************/


/****************************************************************/
/*								*/
/* nom	    : RGB_on						*/   
/*								*/								
/* fonction : test la variable d'environnement			*/ 
/*								*/								
/* entree   : int mode						*/								
/*								*/								
/* globales : ---						*/
/*							    	*/								
/* return   : TRUE si mode RGB, FALSE si mode HLS		*/								
/*								*/								
/* routines : ---						*/
/*								*/
/****************************************************************/

static int
RGB_on(mode)
int mode ;
{
    if ((mode % 2) == 0 )
        return(FALSE) ;
    else 
	return(TRUE) ;
}


/****************************************************************/
/*								*/
/* nom	    : MULT_on						*/   
/*								*/								
/* fonction : test la variable d'environnemnt			*/ 
/*								*/								
/* entree   : int mode						*/								
/*								*/								
/* globales : ---						*/
/*							    	*/								
/* return   : TRUE si mode multiple, FALSE si mode unique	*/								
/*								*/								
/* routines : ---						*/
/*								*/
/****************************************************************/

static int
MULT_on(mode)
int mode ;
{
    if (mode <= 2)
        return(TRUE) ;
    else 
    return(FALSE) ;
    
}

/******************************************************
/   activateCallback for Widget  QUIT_help
/*****************************************************/

void
QUIT_help_actcall(QUIT, Help_Mapedit, callData)
        Widget QUIT;
        Widget Help_Mapedit;
        caddr_t callData;
{
XtUnmanageChild (Help_Mapedit);
}

