/* SCCS @(#)descTOOL.callback.c	1.1  12/2/92 */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/*                      descTOOL.callback.c                             */
/*                                                                      */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/* FILENAME     :   descTOOL.callback.c                                 */
/*                                                                      */
/* DESCRIPTION  :   LaboImage (Desctool)                                */
/*                                                                      */
/* AUTHORS      :   Marianne Logean                                     */
/*                                                                      */
/* VERSION      :   1.0                                                 */
/*                                                                      */
/* HISTORY      :   1.12.92                                             */
/*                  MAL         Created    version: 1.0                 */
/*                                                                      */
/* Copyright  1992 by CUI/UIN/HCUG, All rights reserved.                */
/*                                                                      */
/************************************************************************/
/************************************************************************/

#include <stdlib.h>
#include "libwidgets/widgetstructure.h"
#include "descTOOL.layout.h"
#include <Xm/Text.h>


/******************************************************
/   activateCallback for Widget  desctool_OK 
/*****************************************************/

void
Choose_type(typewidget, tab_widgets, callData)
	Widget typewidget;
        xs_struc_desctool *tab_widgets;
	caddr_t callData;
{
  int i,j, k;
  Widget ChildrenToManage[8];

  for (k=0;k < 8 ; k++)
    if (typewidget == tab_widgets->tabtype[k])
      {
	desc.type = k-1;
	j = 0;
        switch (k)
	  { 
	  case 0:
	  case 1:
	  case 2:
	  case 3:
	  case 4:
	    for (i=1;i < 3 ; i++)
	      {
                ChildrenToManage[j] = tab_widgets->Min[i];j++;
                ChildrenToManage[j] = tab_widgets->Max[i];j++;
                ChildrenToManage[j] = tab_widgets->Avg_Value[i];j++;
                ChildrenToManage[j] = tab_widgets->Std_Deviation[i];j++;  
	      }  
	    XtUnmanageChildren(ChildrenToManage, j);
	    break;
	  case 5:
	  case 6:
	    ChildrenToManage[j] = tab_widgets->Min[1];j++;
	    ChildrenToManage[j] = tab_widgets->Max[1];j++;
	    ChildrenToManage[j] = tab_widgets->Avg_Value[1];j++;
	    ChildrenToManage[j] = tab_widgets->Std_Deviation[1];j++;  
	    XtManageChildren(ChildrenToManage, j);
	    j = 0;
	    ChildrenToManage[j] = tab_widgets->Min[2];j++;
	    ChildrenToManage[j] = tab_widgets->Max[2];j++;
	    ChildrenToManage[j] = tab_widgets->Avg_Value[2];j++;
	    ChildrenToManage[j] = tab_widgets->Std_Deviation[2];j++;  
	    XtUnmanageChildren(ChildrenToManage, j);
	    break;
	  case 7:
	    for (i=1;i < 3 ; i++)
	      {
                ChildrenToManage[j] = tab_widgets->Min[i];j++;
                ChildrenToManage[j] = tab_widgets->Max[i];j++;
                ChildrenToManage[j] = tab_widgets->Avg_Value[i];j++;
                ChildrenToManage[j] = tab_widgets->Std_Deviation[i];j++;  
	      }  
	    XtManageChildren(ChildrenToManage, j);
	    break;
	  default:
	    break;
	  }
      }
}


/******************************************************
/   activateCallback for Widget  desctool_OK 
/*****************************************************/

void
desctool_SAVE_callb(OK, tab_widgets, callData)
	Widget OK;
        xs_struc_desctool *tab_widgets;
	caddr_t callData;
{
  FILE *fp;
  char *nomfile;

  if (nomfile != NULL) free (nomfile);

  nomfile = XmTextGetString (tab_widgets->File);

  /* we dont accept an empty label */
  if (strlen (nomfile) == 0) 
    sprintf (nomfile, "%s/descriptor", getenv("HOME"));
  else Ote_ima_des(&nomfile);


  if (strcmp (nomfile, "") != 0)
    {
      strcat(nomfile, ".des");
      if ((fp = fopen(nomfile, "r")) != NULL) { 
	fclose (fp); 
	sprintf (buf, mastertabs[123], nomfile);
	write_master(buf);
	write_erreur(984);
      }  
      else if ((fp = fopen(nomfile, "w")) != NULL) 
      {
	switch (desc.type) 
	{
	case 6 :
	  desc.mini[2] = (float)atof (XmTextGetString (tab_widgets->Min[2]));
	  desc.maxi[2] = (float)atof (XmTextGetString (tab_widgets->Max[2]));
	  desc.mu[2] = (float)atof (XmTextGetString (tab_widgets->Avg_Value[2]));
	  desc.ecart[2] = (float)atof (XmTextGetString (tab_widgets->Std_Deviation[2]));
	case 4 : 
	case 5 :
	  desc.mini[1] = (float)atof (XmTextGetString (tab_widgets->Min[1]));
	  desc.maxi[1] = (float)atof (XmTextGetString (tab_widgets->Max[1]));
	  desc.mu[1] = (float)atof (XmTextGetString (tab_widgets->Avg_Value[1]));
	  desc.ecart[1] = (float)atof (XmTextGetString (tab_widgets->Std_Deviation[1]));
	case -1: 
	case 0 :
	case 1 :
	case 2 :
	case 3 :
	  desc.mini[0] = (float)atof (XmTextGetString (tab_widgets->Min[0]));
	  desc.maxi[0] = (float)atof (XmTextGetString (tab_widgets->Max[0]));
	  desc.mu[0] = (float)atof (XmTextGetString (tab_widgets->Avg_Value[0]));
	  desc.ecart[0] = (float)atof (XmTextGetString (tab_widgets->Std_Deviation[0]));
	  break;
	default:
	  break;
	}

	desc.nligne = atoi (XmTextGetString (tab_widgets->Row_Count));
	desc.ncolonne = atoi (XmTextGetString (tab_widgets->Column_Count));
	strcpy (desc.date, (char *)get_time());
	strcpy (desc.comment, XmTextGetString (tab_widgets->Comments));
	write_desc (fp, desc);
	fclose(fp);
	sprintf (buf, mastertabs[123], nomfile);
	write_master(buf);
      }
      else 
	write_erreur(986);
    }
  XtFree (nomfile);
}


/******************************************************
/   activateCallback for Widget  desctool_SHOW
/*****************************************************/

void
desctool_SHOW_callb(SHOW, tab_widgets, callData)
	Widget SHOW;
        xs_struc_desctool *tab_widgets;
	caddr_t callData;
{
  FILE *fp;
  Arg args[MAX_ARGS];
  int n, k;
  char repfloat[20];

  char * nomfile;

  if (nomfile != NULL) free(nomfile);
  
  nomfile = XmTextGetString (tab_widgets->File);

  if (strcmp (nomfile, "") != 0)
    {
    strcat(nomfile, ".des");
    if ((fp = fopen(nomfile, "r")) != NULL) 
    {
      k = read_desc(fp, &desc);
      fclose(fp);
      sprintf (buf, mastertabs[122], nomfile);
      write_master(buf);
      switch (k){
      case -1: write_erreur(104);
	return;
      case 0: write_erreur(103);
	return;
      }
      /* Remplissage des differents widgets: */
      n = 0;
      XtSetArg(args[n],XmNset,False); n++;
      for (k=0;k < 8 ; k++)
	XtSetValues(tab_widgets->tabtype[k],args,n);	  
      n = 0;
      XtSetArg(args[n],XmNset,True); n++;
      XtSetValues(tab_widgets->tabtype[desc.type+1],args,n);
      Choose_type(tab_widgets->tabtype[desc.type+1], tab_widgets, NULL);

      switch (desc.type) {
      case 6 :
	sprintf (repfloat, "%8f", desc.mini[2]);  
	XmTextSetString (tab_widgets->Min[2], repfloat);
	sprintf (repfloat, "%8f", desc.maxi[2]);  
	XmTextSetString (tab_widgets->Max[2],repfloat);
	sprintf (repfloat, "%8f", desc.mu[2]);  
	XmTextSetString (tab_widgets->Avg_Value[2],repfloat);
	sprintf (repfloat, "%8f", desc.ecart[2]);  
	XmTextSetString (tab_widgets->Std_Deviation[2],repfloat);
      case 4 : 
      case 5 :
	sprintf (repfloat, "%8f", desc.mini[1]);  
	XmTextSetString (tab_widgets->Min[1],repfloat);
	sprintf (repfloat, "%8f", desc.maxi[1]);  
	XmTextSetString (tab_widgets->Max[1],repfloat);
	sprintf (repfloat, "%8f", desc.mu[1]);  
	XmTextSetString (tab_widgets->Avg_Value[1],repfloat);
	sprintf (repfloat, "%8f", desc.ecart[1]);  
	XmTextSetString (tab_widgets->Std_Deviation[1],repfloat);
      case -1: 
      case 0 :
      case 1 :
      case 2 :
      case 3 :
	sprintf (repfloat, "%8f", desc.mini[0]);  
	XmTextSetString (tab_widgets->Min[0],repfloat);
	sprintf (repfloat, "%8f", desc.maxi[0]);  
	XmTextSetString (tab_widgets->Max[0],repfloat);
	sprintf (repfloat, "%8f", desc.mu[0]);  
	XmTextSetString (tab_widgets->Avg_Value[0],repfloat);
	sprintf (repfloat, "%8f", desc.ecart[0]);  
	XmTextSetString (tab_widgets->Std_Deviation[0],repfloat);
	break;
      default:
	break;
      }
      sprintf (repfloat, "%d", desc.nligne);  
      XmTextSetString (tab_widgets->Row_Count,repfloat);
      sprintf (repfloat, "%d", desc.ncolonne);  
      XmTextSetString (tab_widgets->Column_Count,repfloat);
      sprintf (repfloat, "%s", desc.comment);  
      XmTextSetString (tab_widgets->Comments,repfloat);
    }
  }
 XtFree (nomfile);
}


/******************************************************
/   activateCallback for Widget  desctool_HELP
/*****************************************************/

void
desctool_HELP_callb(HELP, desctool_mainwidget, callData)
	Widget HELP;
        Widget desctool_mainwidget;
	caddr_t callData;
{
	/* ADD CALLBACK CODE HERE */
}


/******************************************************
/   activateCallback for Widget  desctool_QUIT
/*****************************************************/

void
desctool_QUIT_callb(QUIT, desctool_mainwidget, callData)
	Widget QUIT;
        Widget desctool_mainwidget;
	caddr_t callData;
{
  XtUnmanageChild (desctool_mainwidget);
}


