/* SCCS @(#)RegionInterestmenu.callback.c	1.2  12/3/92 */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/*                   RegionInterestmenu.callback.c                      */
/*                                                                      */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/* FILENAME     :   RegionInterestmenu.callback.c                       */
/*                                                                      */
/* DESCRIPTION  :   LaboImage (Display ROI)                             */
/*                                                                      */
/* AUTHORS      :   Marianne Logean                                     */
/*                                                                      */
/* VERSION      :   1.0                                                 */
/*                                                                      */
/* HISTORY      :   1.12.92                                             */
/*                  MAL         Created    version: 1.0                 */
/*                                                                      */
/* Copyright  1992 by CUI/UIN/HCUG, All rights reserved.                */
/*                                                                      */
/************************************************************************/
/************************************************************************/

#include "../libwidgets/widgetstructure.h"
#include "../pre_pro.layout.h"
#include "RegionInterestmenu.layout.h"
#include "statistics.layout.h"
#include <X11/StringDefs.h>
#include <X11/Intrinsic.h> 
#include <X11/cursorfont.h>
#include <math.h>



#define	    BORD      0
#define	    ZONE      1
#define	    IMAGE     2
#define	    MASQUE    3
#define	    TWO	      4

extern GC 	default_gc, gc_xor, gc_and, gc_notand;
extern Widget   gLabowidget;
extern Display *gDisplay;
extern Visual  *gVisual;


/* Affichage de l'histogramme d'une region d'interet sur le pixmap de mapedit */

extern void Build_mapedit();
extern void free_liste_pts();  /* win4.c*/

extern Pixmap 		    mapeditpixmap;
extern Widget 		    XmDrawingAreamapedit;
extern XImage 		    *ximage_mapedit;

ptr_point   pt_debut, pt_courant;

int	    WLnbr_pts = 0;

int	    WLcontrainte = 0;	/* Si 1 on force les droites a etre */
				/* horizontales ou verticales*/
int 	    Histo_selected = 0;
int  	    Stat_selected = 0;
int  	    Save_selected = 0;
int  	    Show_selected = IMAGE;

static int		    width_save, height_save;
static char   		    *masque_save;
static ptr_zone    	     pt_zone_save;
static xs_struc_display_menu * data_display_read;
static Pixmap 		    pixmap_save;


static begintrack = FALSE;

/****************************************************************

	    procedure de gestion de liste de points

****************************************************************/

/****************************************************************/
/*								*/
/*  nom	    :	reset_zone					*/
/*								*/
/*  fonction:	libere la zone memoire alouee pour le polygone	*/
/*								*/
/*  entrees :	---						*/
/*								*/
/*  return  :	---						*/
/*								*/
/*  routines:	free_liste_pts					*/
/*								*/
/****************************************************************/

static void
reset_zone(data_display) 
  xs_struc_display_menu * data_display;
{
    if (data_display->im_desc->pt_zone != NULL)
    {
	free_liste_pts(&(data_display->im_desc->pt_zone -> pts));
	cfree(data_display->im_desc->pt_zone) ;
	data_display->im_desc->pt_zone = NULL ;
    }
}


static void
efface_points(zptr, Drawing_Area, data_display)
  ptr_zone zptr;
  Widget Drawing_Area;
  xs_struc_display_menu * data_display;
{
    ptr_point	temp;

    if (zptr != NULL)
    {
	temp = zptr -> pts;

	while (temp != NULL)
	{         
	    XSetForeground(gDisplay, gc_xor, 128);

	    XDrawLine (gDisplay, XtWindow(Drawing_Area), 
		     gc_xor, temp -> x,temp -> y,temp -> x,(temp -> y)+1);
	    XDrawLine (gDisplay, XtWindow(Drawing_Area), 
	      gc_xor, (temp -> x)+1,temp -> y,(temp -> x)+1,(temp -> y)+1);
	    temp = temp -> next;
	}
    }
}


/****************************************************************/
/*								*/
/*  nom	    :	dessine_zone					*/
/*								*/
/*  fonction:	relie successivement les points stockes dans    */
/*		la liste par des segments de droite bicolores	*/
/*								*/
/****************************************************************/

void 
dessine_zone(zptr, Drawing_Area, data_display)
  ptr_zone zptr;
  Drawable Drawing_Area;
  xs_struc_display_menu * data_display;
{
    ptr_point	temp, oldtemp;
    int nbr;

    nbr = zptr -> nbr_pts;
    
    if (zptr != NULL)
    {
	oldtemp = zptr -> pts;
	temp = oldtemp -> next;

	while (temp != NULL && nbr != 0)
	{         
	    XSetForeground(gDisplay, default_gc, 255);
	    XDrawLine (gDisplay, Drawing_Area, 
		       default_gc, oldtemp -> x,(oldtemp -> y)+1,
		                   temp -> x,(temp -> y)+1);
	    XSetForeground(gDisplay, default_gc, 0);
	    XDrawLine (gDisplay, Drawing_Area, 
		       default_gc, oldtemp -> x,oldtemp -> y,
		                   temp -> x,temp -> y);
	    oldtemp = temp;
	    temp = temp -> next;
	    nbr--;
	}
    }
}


/****************************************************************/
/*								*/
/*  nom	    :	creer_masque       				*/
/*								*/
/*  fonction:	creation du masque binaire a partir de la zone	*/
/*								*/
/****************************************************************/

static void 
creer_masque(zptr, data_display)
ptr_zone zptr;
xs_struc_display_menu * data_display;
{
    struct pr_pos    *tab;
    ptr_point	    pos;
    int		    n, i, j, nbds = 1; 
    XPoint    *Xpt;
    XImage *ximage_masque;
    
    /* Number of points for defining the polygonal area */
    n = zptr->nbr_pts ;
    pos = zptr->pts;

    data_display->masque_width = data_display->im_desc->ncolonne;
    data_display->masque_height = data_display->im_desc->nligne;

    if (data_display->masque)
    {
      /* destruction de l'ancien masque */
      free(data_display->masque);
    }

    /* creation du masque */
    if ((data_display->masque = (char *) malloc (data_display->masque_width*data_display->masque_height)) == NULL)
    {
	write_erreur(3) ;
	return ;
    }

    if (data_display->MaskPix)
    {
      XFreePixmap(gDisplay, data_display->MaskPix);
      data_display->MaskPix = NULL;
    }
    
    /* Create pixmap which will contain the drawing representation of 
       the mask */
    data_display->MaskPix = XCreatePixmap(gDisplay,
					  DefaultRootWindow(gDisplay),
					  data_display->masque_width, 
					  data_display->masque_height, 8);

    if (!data_display->MaskPix) return ;

    /* Clear pixmap */
    XSetForeground(gDisplay, default_gc, 0);
    XFillRectangle(gDisplay, data_display->MaskPix, 
		   default_gc, 0, 0, data_display->masque_width, 
		   data_display->masque_height);

    /* Set foreground and background value */
    XSetForeground(gDisplay, default_gc, 255);
    XSetBackground(gDisplay, default_gc, 0);

    /* structure XPoint contain points for defining the polygonal mask */
    Xpt = (XPoint *) malloc (n * sizeof(* Xpt));
    for (i=0; i<n; i++)
    {
      Xpt[i].x = pos -> x;
      Xpt[i].y = pos -> y;
      pos = pos -> next;
    }

    /* Draw the image corresponding to polygonal roi on pixmap */
    XFillPolygon(gDisplay, data_display->MaskPix, 
		 default_gc, Xpt, n, Complex, CoordModeOrigin);

    /* Store data corresponding to the area of the pixmap */
    ximage_masque = XGetImage(gDisplay, 
			      data_display->MaskPix, 0, 0, 
			      data_display->masque_width, 
			      data_display->masque_height, 
			      AllPlanes, ZPixmap);

    /* Set mask corresponding to data get before */
    for (i=0; i< data_display->masque_width; i++)
     for (j=0; j< data_display->masque_height; j++)
     {
       if (XGetPixel(ximage_masque, i, j)) 
            data_display->masque[data_display->masque_height*i + j] = 255;
       else data_display->masque[data_display->masque_height*i + j] = 0;
     }

    /* Reset foreground and background value */
    XSetForeground(gDisplay, default_gc, 0);
    XSetBackground(gDisplay, default_gc, 255);

    XDestroyImage(ximage_masque);
}



/****************************************************************/
/*								*/
/*  nom	    :	track_position       				*/
/*								*/
/*  callback:	get the position of the mouse and interactively	*/
/*              draw the current region                         */
/*								*/
/****************************************************************/

void track_position(w, data_display, event)
    Widget          w;
    xs_struc_display_menu * data_display;
    XEvent         *event;
{
  static int X;
  static int Xold;
  static int Y;
  static int Yold;

  XSetForeground(gDisplay, gc_xor, 128);
  if (begintrack)
      XDrawLine(gDisplay, 
		XtWindow(data_display->Drawing_Area), 
		gc_xor, pt_courant->x, pt_courant->y, Xold, Yold);

  /*
   * Extract the position of the sprite from the event
   * and display it in the widgets. 
   */

  X = event->xmotion.x;
  Y = event->xmotion.y;

  if (pt_courant)
  {
    if (WLcontrainte)
    {
      if (abs((pt_courant -> x) - X) < abs((pt_courant -> y) - Y))
      {	
	X = pt_courant -> x;
	Y = Y;
      }
      else
      {
	X = X;
	Y = pt_courant -> y;
      }
    }

    XDrawLine(gDisplay, 
	      XtWindow(data_display->Drawing_Area), 
	      gc_xor, pt_courant->x, pt_courant->y, X, Y);

    Xold = X;
    Yold = Y;
    begintrack = TRUE;
  }
}


/****************************************************************/
/*								*/
/*  nom	    :	do_zone       				        */
/*								*/
/*  callback:	define and draw the region of interest          */
/*								*/
/****************************************************************/

void
do_zone(Drawing_Area, data_display, event)
	Widget Drawing_Area;
	xs_struc_display_menu * data_display;
        XEvent    *event;
{
  int X, Y;
  Arg args[MAX_ARGS];
  int n;

  switch (event->type){
    case ButtonPress:
    {
      switch (event->xbutton.button){
        case Button1:
        case Button3:
	  X = event->xmotion.x;
	  Y = event->xmotion.y;
	  if (pt_debut == NULL)
	  {
	    pt_debut = (ptr_point) calloc (1,sizeof (struct coords));
	    pt_courant = pt_debut ;

	    pt_courant -> next = NULL;
	    pt_courant -> x = X;
	    pt_courant -> y = Y;
	  }
	  else
	  switch (WLcontrainte) 
	  {
	    case 0 : 
	      pt_courant -> next = 
	                (ptr_point) calloc (1,sizeof (struct coords));
	      pt_courant = pt_courant -> next;

	      pt_courant -> next = NULL;
	      pt_courant -> x = X;
	      pt_courant -> y = Y;
	      break;

	    case 1 : 
	      if (abs((pt_courant -> x) - X) < abs((pt_courant -> y) - Y))
	      {
		X = pt_courant -> x;
		Y = Y;
	      }
	      else
	      {
		X = X;
		Y = pt_courant -> y;
	      }
	      pt_courant -> next = 
	           (ptr_point) calloc (1,sizeof (struct coords));
	      pt_courant = pt_courant -> next;
	      pt_courant -> next = NULL;
	
	      pt_courant -> x = X;
	      pt_courant -> y = Y;
	      break;
	  }
          XSetForeground(gDisplay, gc_xor, 128);
	  XDrawLine (gDisplay, XtWindow(Drawing_Area), 
		     gc_xor, X,Y,X,Y+1);
	  XDrawLine (gDisplay, XtWindow(Drawing_Area), 
		     gc_xor, X+1,Y,X+1,Y+1);
	  WLnbr_pts++;
	  break;

        case Button2:
	  if (pt_debut != NULL)
	  {
	    /* On ferme le polygone */
	    switch (WLcontrainte)
	    {
	      case 0 :
	        pt_courant -> next = 
		   (ptr_point) calloc (1,sizeof (struct coords));
		pt_courant =  pt_courant -> next;
		pt_courant -> next = NULL;
		pt_courant -> x = pt_debut -> x;
		pt_courant -> y = pt_debut -> y;
		WLnbr_pts++;
		break;

	      case 1 :
	      /* Si on a la contrainte hv il faut rajouter un point  */ 
	      /* (en plus de celui pour fermer la figure) afin que   */
	      /* le dernier segment soit bien vertical ou horizontal */

	        if ((pt_courant -> x) - (pt_debut -> x) < 0)
		{
		  pt_courant -> next = 
			  (ptr_point) calloc (1,sizeof (struct coords));
		  X = pt_courant -> x;
		  Y = pt_debut -> y;
		  pt_courant =  pt_courant -> next;
		  pt_courant -> next = NULL;
		  pt_courant -> x = X;
		  pt_courant -> y = Y;
		  WLnbr_pts++;
		}
		else
		if ((pt_courant -> x) - (pt_debut -> x) > 0)
		{
		  pt_courant -> next = 
		      (ptr_point) calloc (1,sizeof (struct coords));
		  X = pt_debut -> x;
		  Y = pt_courant -> y;
		  pt_courant =  pt_courant -> next;
		  pt_courant -> next = NULL;
		  pt_courant -> x = X;
		  pt_courant -> y = Y;
		  WLnbr_pts++;
		}

		pt_courant -> next =
			     (ptr_point) calloc (1,sizeof (struct coords));
		pt_courant =  pt_courant -> next;
		pt_courant -> next = NULL;
		pt_courant -> x = pt_debut -> x;
		pt_courant -> y = pt_debut -> y;
		WLnbr_pts++;
		break;

	      }	/* switch */

	    reset_zone(data_display) ;

	    data_display->im_desc->pt_zone = (ptr_zone) calloc (1, sizeof(struct str_zone)) ;

	    data_display->im_desc->pt_zone -> pts = pt_debut ;
	    data_display->im_desc->pt_zone -> nbr_pts = WLnbr_pts ;
	    WLnbr_pts = 0 ;

	    pt_debut = NULL ;
	    pt_courant = NULL ; 

	    XCopyArea (gDisplay, data_display->ret->pixmap, 
		       XtWindow(Drawing_Area), default_gc, 0, 0,
		       data_display->im_desc->ncolonne, 
		       data_display->im_desc->nligne, 0, 0);

	    dessine_zone(data_display->im_desc->pt_zone, 
			 XtWindow(Drawing_Area), data_display) ;
	    efface_points(data_display->im_desc->pt_zone, 
			  Drawing_Area, data_display) ;
	    creer_masque(data_display->im_desc->pt_zone, data_display) ;

	  }
	  XtRemoveEventHandler(data_display->Drawing_Area, 
				  ButtonPressMask, FALSE,
				  do_zone, data_display);
	  XtRemoveEventHandler(data_display->Drawing_Area, 
				  PointerMotionMask, FALSE,
				  track_position, 
				  data_display);

	  begintrack = FALSE;

	  XSetForeground(gDisplay, default_gc, 0);

	  XUndefineCursor(gDisplay, XtWindow(data_display->Drawing_Area));
        
	}
      
    }/* case ButtonPress */

  }/* switch */
}


/****************************************************************/
/*								*/
/*  nom	    :	stat_zone					*/
/*								*/
/*  fonction:	calcule les statistiques de la zone et affiche	*/
/*		les resultats					*/
/*                                                              */
/****************************************************************/

static struct image_ecran *
stat_zone(pix, data_display)
 int pix ;
 xs_struc_display_menu * data_display;
{
    register int  i, j, nb,f;
    float  t,q,r, mu, mmin, mmax, ecart ;
    XImage *ximage;
    struct image_ecran * zone_desc;
    
    if (!data_display->masque) return NULL;
    
    zone_desc = (struct image_ecran *) malloc (sizeof (struct image_ecran));

    if (data_display->masque_height == data_display->im_desc->nligne && 
	data_display->masque_width == data_display->im_desc->ncolonne)
    {
	nb = 1 ;
	t = 0.0 ;
	mu = 0 ;

        mmin = 255 ;
        mmax = 0 ;

	ximage = XGetImage(gDisplay, 
			   data_display->ret->pixmap, 0, 0,
			   data_display->im_desc->ncolonne, 
			   data_display->im_desc->nligne, AllPlanes, 
			   ZPixmap);

        if (pix == ZONE)
	{
	  for (i=0; i< data_display->masque_width; i++)
	    for (j=0; j< data_display->masque_height; j++)
	    {
	      if (data_display->masque[data_display->masque_height*i + j] != 0)
	      {
		f = XGetPixel(ximage, i, j);

		if (f > mmax) 
		   mmax = f ;  
		else if (f < mmin)
		   mmin = f ;

		q = f - mu ;
		r = q/nb ;
		mu = mu + r ;
		t = t + ( nb - 1 ) * q * r ;
		nb++ ;
	      }
	  }
	  nb = nb - 1 ;

	  ecart = (float)sqrt( t / nb ) ;
	}
	else    
	{
	  for (i=0; i < data_display->masque_width; i++)
	    for (j=0; j < data_display->masque_height; j++)
	    {
	      if (data_display->masque[data_display->masque_height*i + j] == 0)
	      {
		f = XGetPixel(ximage, i, j);

		if (f > mmax) 
		    mmax = f ;  
		else if (f < mmin)
		    mmin  = f ;

		q = f - mu ;
		r = q/nb ;
		mu = mu + r ;
		t = t + ( nb - 1 ) * q * r ;
		nb++ ;
	      }
	  }
	  nb = nb - 1 ;
	  ecart = (float) sqrt( t /  nb ) ;
	}

	XDestroyImage(ximage);
	
	if (nb > 0)
	{
	    zone_desc->nbr_plan = 0;
	    zone_desc->npixels = nb;
	    zone_desc->maxi[0] = mmax;
	    zone_desc->mini[0] = mmin;
	    zone_desc->mu[0] = mu;
	    zone_desc->ecart[0] = ecart;
	}
    }
    return(zone_desc);
}



/****************************************************************/
/*								*/
/*  nom	    :	zone_proc					*/
/*								*/
/*  fonction:	affiche la partie delimitee par la zone		*/
/*								*/
/****************************************************************/


static void
zone_proc(drawing, data_display)
 Drawable drawing;
 xs_struc_display_menu * data_display;
{
  if (data_display->ret->pixmap && data_display->MaskPix)
  {
    XCopyArea (gDisplay, data_display->ret->pixmap, 
	       drawing, default_gc, 0, 0,
	       data_display->im_desc->ncolonne, 
	       data_display->im_desc->nligne, 0, 0);
    XCopyArea (gDisplay, data_display->MaskPix, 
	       drawing, gc_and, 0, 0,
	       data_display->im_desc->ncolonne, 
	       data_display->im_desc->nligne, 0, 0);
  }
}


/****************************************************************/
/*								*/
/*  nom	    :	bord_proc					*/
/*								*/
/*  fonction:	affiche l'original avec un trou			*/
/*		correspondant a la zone				*/
/*								*/
/****************************************************************/

static void
bord_proc(drawing, data_display)
 Drawable drawing;
 xs_struc_display_menu * data_display;
{
  if (data_display->ret->pixmap && data_display->MaskPix)
  {
    XCopyArea (gDisplay, data_display->MaskPix, 
	       drawing, default_gc, 0, 0,
	       data_display->im_desc->ncolonne, 
	       data_display->im_desc->nligne, 0, 0);
    XCopyArea (gDisplay, data_display->ret->pixmap, 
	       drawing, gc_notand, 0, 0,
	       data_display->im_desc->ncolonne, 
	       data_display->im_desc->nligne, 0, 0);
  }
}


/****************************************************************/
/*								*/
/*  nom	    :	image_proc					*/
/*								*/
/*  fonction:	affiche l'image					*/
/*								*/
/****************************************************************/


static void
image_proc(drawing, data_display)
 Drawable drawing;
 xs_struc_display_menu * data_display;
{
  if (data_display->ret->pixmap)
  {
    XCopyArea (gDisplay, data_display->ret->pixmap, 
	       drawing, default_gc, 0, 0,
	       data_display->im_desc->ncolonne, 
	       data_display->im_desc->nligne, 0, 0);
  }
}

/****************************************************************/
/*								*/
/*  nom	    :	mask_proc					*/
/*								*/
/*  fonction:	affiche le masque		       		*/
/*								*/
/****************************************************************/


static void
mask_proc(drawing, data_display)
 Drawable drawing;
 xs_struc_display_menu * data_display;
{
  if (data_display->MaskPix)
     XCopyArea (gDisplay, data_display->MaskPix, 
		drawing, default_gc, 0, 0,
		data_display->im_desc->ncolonne, 
		data_display->im_desc->nligne, 0, 0);
}


/****************************************************************/
/*								*/
/*  nom	    :	two_proc					*/
/*								*/
/*  fonction:	affiche l'image original avec sa region 	*/
/*		d'interet.		       			*/
/*								*/
/****************************************************************/


static void
two_proc(drawing, data_display)
 Drawable drawing;
 xs_struc_display_menu * data_display;
{
  if (data_display->ret->pixmap && data_display->im_desc->pt_zone)
  {
    XCopyArea (gDisplay, data_display->ret->pixmap, 
	       drawing, default_gc, 0, 0,
	       data_display->im_desc->ncolonne, 
	       data_display->im_desc->nligne, 0, 0);
    dessine_zone(data_display->im_desc->pt_zone, 
		 drawing, data_display);
  }
}


/****************************************************************/
/*								*/
/*  nom	:	afficher_histo					*/
/*								*/
/*  fonction:	dessine l'histogramme sur la table de couleur	*/
/*								*/
/****************************************************************/

static void
afficher_histo(pix, data_display)
 int pix;
 xs_struc_display_menu * data_display;
{
    int		i, j, pixel, c[256];
 
    register int    x,y,posx,
		    y1,y0,
		    maxcol ;

    register unsigned	char col ;
    register float	dec, coeff ;

    XImage *ximage;
    
    if (!flag_mapedit_open) {
      Build_mapedit(gLabowidget);
      flag_mapedit_open = true;
    }
    
    if ((data_display->MaskPix || pix == IMAGE) && data_display->ret->pixmap)
    {
        ximage = XGetImage(gDisplay, 
			   data_display->ret->pixmap, 0, 0,
			   data_display->im_desc->ncolonne, 
			   data_display->im_desc->nligne, AllPlanes, 
			   ZPixmap);

	for(i=0; i <= 255 ; i++) c[i] = 0;

        XPutImage(gDisplay, mapeditpixmap, default_gc,
		  ximage_mapedit, 0, 0, 0, 0, 512, 50);

	switch(pix)
	{
	  case ZONE :       
	  if (data_display->masque_height == data_display->im_desc->nligne && 
	      data_display->masque_width == data_display->im_desc->ncolonne)
	  {
	    for (i=0; i < data_display->masque_width; i++)
	      for (j=0; j < data_display->masque_height; j++)
		if (data_display->masque[data_display->masque_height*i + j] != 0) 
		{
		  pixel = XGetPixel(ximage, i, j);
		  c[pixel]++ ;
		}
	    zone_proc(XtWindow(data_display->Drawing_Area), data_display) ;
	  }
	  break ;

	  case BORD :       
	  if (data_display->masque_height == data_display->im_desc->nligne &&
	      data_display->masque_width == data_display->im_desc->ncolonne)
	  {
	    for (i=0; i< data_display->masque_width; i++)
	      for (j=0; j< data_display->masque_height; j++)
		if (data_display->masque[data_display->masque_height*i + j] == 0) 
		{
		  pixel = XGetPixel(ximage, i, j);
		  c[pixel]++ ;
		}
	    bord_proc(XtWindow(data_display->Drawing_Area), data_display) ;
	  }
	  break ;

	  case IMAGE :       
	  for (i=0; i < data_display->im_desc->ncolonne; i++)
	  for (j=0; j < data_display->im_desc->nligne; j++)
	  {
	    pixel = XGetPixel(ximage, i, j);
	    c[pixel]++ ;
	  }
	  image_proc(XtWindow(data_display->Drawing_Area), data_display) ;

	  break ;

	}

	maxcol = c[0] ;

	for(i=1; i <= 255 ; i++) 
	{
	    if (c[i] > maxcol)
	    maxcol = c[i] ;
	}
	dec = 95 ;
	coeff = (float) 95/maxcol ;
	y0 = (int) rint((double) dec - (double) c[0]*coeff) ;

	/* Clear pixmap */

	XSetForeground(gDisplay, default_gc, 0);

	for(i=0 ; i < 255 ; i++) 
	{
	    posx = 2*i ;
	    y1 = (int) rint((double) dec - (double) c[i]*coeff) ;

	    XDrawLine (gDisplay, 
		       mapeditpixmap, default_gc, 
		       posx, y0, posx+2, y1);
	    XDrawLine (gDisplay, 
		       mapeditpixmap, default_gc, 
		       posx, y0+1, posx+2, y1+1);
	    y0 = y1;
	}
	XCopyArea (gDisplay, mapeditpixmap, 
		   XtWindow(XmDrawingAreamapedit), default_gc, 0, 0,
		   512, 50, 0, 0);
	XDestroyImage(ximage);
    }
}


static 
void copy_pt_zone (pt_zoneA, pt_zoneD) 
  ptr_zone  *pt_zoneA, pt_zoneD;
{
  ptr_zone  pt_zonea, pt_zoned;
  ptr_point pt_courantA, pt_courantD;

  *pt_zoneA = (ptr_zone) calloc (1, sizeof(struct str_zone)) ;
  pt_zonea = *pt_zoneA;
  pt_zoned = pt_zoneD;

  pt_zonea -> nbr_pts = pt_zoned -> nbr_pts;

  pt_zonea -> pts = (ptr_point) calloc (1,sizeof (struct coords));
  pt_courantA = pt_zonea -> pts;
  pt_courantD = pt_zoned -> pts;

  pt_courantA -> x = pt_courantD -> x;
  pt_courantA -> y = pt_courantD -> y;

  pt_courantD = pt_courantD -> next;

  while (pt_courantD)
  {
    pt_courantA -> next = (ptr_point) calloc (1,sizeof (struct coords));
    pt_courantA = pt_courantA -> next;
    pt_courantA -> next = NULL;
    pt_courantA -> x = pt_courantD -> x;
    pt_courantA -> y = pt_courantD -> y;
    pt_courantD = pt_courantD->next;
  }
}


      
static 
void get_borne (pt_zone, x1, x2, y1, y2)
  ptr_zone  pt_zone;
  int *x1, *x2, *y1, *y2;   
{
  ptr_zone  pt_zone_temp;
  ptr_point pt_courant;
  int i, nbr_pts;

  pt_zone_temp = pt_zone;
  
  nbr_pts = pt_zone_temp -> nbr_pts;
  pt_courant = pt_zone_temp -> pts;

  *x1 = *x2 = pt_courant -> x;
  *y1 = *y2 = pt_courant -> y;
    
  for (i=1; i < nbr_pts; i++)
    {
      pt_courant = pt_courant->next;
      if (!pt_courant) return;
      else 
	{
	  if (pt_courant->x > *x2) *x2 = pt_courant -> x;
	  else if (pt_courant->x < *x1) *x1 = pt_courant -> x;
	  if (pt_courant->y > *y2) *y2 = pt_courant -> y;
	  else if (pt_courant->y < *y1) *y1 = pt_courant -> y;
	}
    }
}


/****************************************************************/
/*								*/
/*  nom	    :	sauver_image					*/
/*								*/
/*  fonction:	ecrit le masque dans un plan memoire		*/
/*								*/
/****************************************************************/

void
sauver_image()
{
    int x, y, plan, pix, x1, x2, y1, y2;
    unsigned char *image_temp ;
    char buf[100] ;
    XImage *ximage;
    
    pix = Show_selected;
    
    if (pix == MASQUE && masque_save != NULL)
    {
      write_master(panel_titres[26]);

      plan = index_image[1] ;

      if (dir_image[plan].image != NULL)
      free(dir_image[plan].image) ;

      dir_image[plan].image = (unsigned char *) malloc (width_save * height_save);
      dir_desc[plan].nligne = height_save ;
      dir_desc[plan].ncolonne = width_save ;
      dir_desc[plan].type = -1;
	    
      image_temp = dir_image[plan].image ;

      for (x = 0 ; x < height_save ; x++)
        for (y = 0 ; y < width_save ; y++) 
	{
	  *image_temp = masque_save[height_save*y + x] ;
	  image_temp++ ;
	}

      /* sauvegarde des points de la region d'interet */

      if (dir_desc[plan].pt_zone != NULL)    
      {
	free_liste_pts(&(dir_desc[plan].pt_zone -> pts));
	cfree(dir_desc[plan].pt_zone) ;
	dir_desc[plan].pt_zone = NULL ;
      }

      copy_pt_zone (&dir_desc[plan].pt_zone, pt_zone_save);

      sprintf(buf,paneltabs[560],plan) ;
      write_master(buf) ;
    }

    else if (pix == ZONE && masque_save != NULL)
    {
      int width_zone, height_zone;

      write_master(panel_titres[26]);
      plan = index_image[1] ;

      if (dir_image[plan].image != NULL)
      free(dir_image[plan].image) ;

      get_borne (pt_zone_save, &x1, &x2, &y1, &y2);

      height_zone = y2 - y1 + 1;
      width_zone = x2 - x1 + 1;

      dir_image[plan].image = (unsigned char *) malloc (width_zone * height_zone);
      dir_desc[plan].nligne = height_zone;
      dir_desc[plan].ncolonne = width_zone;
      dir_desc[plan].type = 0;
	    
      image_temp = dir_image[plan].image ;

      ximage = XGetImage(gDisplay, pixmap_save, 0, 0,
			 width_save, height_save, AllPlanes, 
			 ZPixmap);
 
      for (y =  y1; y <= y2 ; y++) 
         for (x = x1 ; x <= x2; x++)
	 {
	   *image_temp = XGetPixel(ximage, x, y) ;
	   image_temp++ ;
	 }


      /* sauvegarde des points de la region d'interet */

      if (dir_desc[plan].pt_zone != NULL)    
      {
	free_liste_pts(&(dir_desc[plan].pt_zone -> pts));
	cfree(dir_desc[plan].pt_zone) ;
	dir_desc[plan].pt_zone = NULL ;
      }

      sprintf(buf,paneltabs[560],plan) ;
      write_master(buf) ;      
    }
    else
    {
      write_master(panel_titres[26]);

      plan = index_image[1] ;
      if (dir_image[plan].image != NULL)
      free(dir_image[plan].image) ;

      dir_image[plan].image = (unsigned char *) malloc (width_save * height_save);
      dir_desc[plan].nligne = height_save ;
      dir_desc[plan].ncolonne = width_save ;
      dir_desc[plan].type = 0 ;	
	
      image_temp = dir_image[plan].image ;

      ximage = XGetImage(gDisplay, pixmap_save, 0, 0,
			 width_save, height_save, AllPlanes, 
			 ZPixmap);
 
      for (y = 0 ; y < height_save ; y++) 
         for (x = 0 ; x < width_save ; x++)
	 {
	   *image_temp = XGetPixel(ximage, x, y) ;
	   image_temp++ ;
	 }

      XDestroyImage(ximage);

      if (dir_desc[plan].pt_zone != NULL)    
      {
	free_liste_pts(&(dir_desc[plan].pt_zone -> pts));
	cfree(dir_desc[plan].pt_zone) ;
	dir_desc[plan].pt_zone = NULL ;
      }

      sprintf(buf, paneltabs[561],plan) ;
      write_master(buf) ;
    }

    statis(dir_image[plan].image,
	   dir_desc[plan].type,
	   dir_desc[plan].nligne,
	   dir_desc[plan].ncolonne,
	   &(dir_desc[plan].mmin),  
	   &(dir_desc[plan].mmax),  
	   &(dir_desc[plan].mu),  
	   &(dir_desc[plan].ecart)) ; 
}


/****************************************************************/
/*  nom	    :	lire_zone					*/
/*								*/
/*  fonction:	lecture d'un masque binaire			*/
/*								*/
/****************************************************************/

void
lire_zone()
{
    int plan, i,j;
    unsigned char *d, *temp;
    char buf[50] ;
    XImage *ximage_masque;
    
    write_master(panel_titres[27]) ;

    plan = index_image[0] ;

    if ((data_display_read->im_desc->ncolonne != dir_desc[plan].ncolonne) ||
	(data_display_read->im_desc->nligne != dir_desc[plan].nligne))	
    {
      sprintf(buf,paneltabs[558],plan) ;
      write_master(buf) ;
      return; 
    }
    
    if ((dir_desc[plan].type == -1) && (dir_image[plan].image != NULL))
    {
      reset_zone(data_display_read);
      
      if (dir_desc[plan].pt_zone)
      {
	copy_pt_zone (&data_display_read->im_desc->pt_zone, dir_desc[plan].pt_zone);
/*      data_display_read->im_desc->pt_zone = dir_desc[plan].pt_zone;*/
      
	dessine_zone(data_display_read->im_desc->pt_zone, 
		     XtWindow(data_display_read->Drawing_Area), 
		     data_display_read) ;
	creer_masque(data_display_read->im_desc->pt_zone, data_display_read);

	sprintf(buf,paneltabs[559],plan) ;
	write_master(buf) ;
      }
      else 
      {
	sprintf(buf,paneltabs[563],plan) ;
	write_master(buf) ;
      }
    }
    else
    {
      sprintf(buf,paneltabs[562],plan) ;
      write_master(buf) ;
    }
}


/******************************************************
/   activateCallback for Widget  Create_zone_button 
/*****************************************************/


void
Create_zone(Create_zone_button, data_display)
	Widget Create_zone_button;
        xs_struc_display_menu * data_display;
{
  Cursor pencil;

  WLnbr_pts = 0;
  begintrack = FALSE;

  if (data_display->MaskPix) 
  {
    XFreePixmap(gDisplay, data_display->MaskPix);
    data_display->MaskPix = NULL;
  }

  if (data_display->masque)
  {
    free(data_display->masque);
    data_display->masque = NULL;
  }
  
  pencil = XCreateFontCursor(gDisplay, XC_pencil);

  XDefineCursor(gDisplay, XtWindow(data_display->Drawing_Area), pencil);

  XCopyArea (gDisplay, data_display->ret->pixmap, 
	     XtWindow(data_display->Drawing_Area), default_gc, 0, 0,
	     data_display->im_desc->ncolonne, 
	     data_display->im_desc->nligne, 0, 0);

  XtAddEventHandler(data_display->Drawing_Area, ButtonPressMask, FALSE,
 		      do_zone, data_display);
  XtAddEventHandler(data_display->Drawing_Area, PointerMotionMask, FALSE,
                      track_position, data_display);
}


void
Create_with_zone(Create_zone_button, client_data, callData)
	Widget Create_zone_button;
	caddr_t client_data;
        caddr_t callData;
{
  WLcontrainte = 1;
}


void
Create_without_zone(Create_zone_button, client_data, callData)
	Widget Create_zone_button;
	caddr_t client_data;
	caddr_t callData;
{
  WLcontrainte = 0;
}


void
Create_zone_actcall(Create_zone_button, data_display, callData)
	Widget Create_zone_button;
        xs_struc_display_menu * data_display;
	caddr_t callData;
{
  Create_zone(Create_zone_button, data_display);
}

/******************************************************
/   activateCallback for Widget  Read_zone_button 
/*****************************************************/

void
Read_zone_actcall(Read_zone_button, data_display, callData)
	Widget Read_zone_button;
        xs_struc_display_menu * data_display;
	caddr_t callData;
{
  Widget PRE_PRO_options_widget;

  if (data_display->masque)
  {
    /* destruction de l'ancien masque */
    free(data_display->masque);
    data_display->masque = NULL;
  }
  
  data_display_read = data_display;

  PRE_PRO_options_widget =
    build_PRE_PRO_options_widget(Read_zone_button, 320, "");
  XtManageChild(PRE_PRO_options_widget);

}



/******************************************************
/   activateCallback for Widget  Save_display
/*****************************************************/

void
Save_display_actcall(Save, data_display, callData)
	Widget Save;
        xs_struc_display_menu * data_display;
	caddr_t callData;
{
  Widget PRE_PRO_options_widget;

  masque_save = data_display->masque;
  width_save = data_display->im_desc->ncolonne;
  height_save = data_display->im_desc->nligne;
	    
  copy_pt_zone (&pt_zone_save, data_display->im_desc->pt_zone); 

  if (pixmap_save) 
  {
    XFreePixmap(gDisplay, pixmap_save);
    pixmap_save = NULL;
  }
  pixmap_save = XCreatePixmap(gDisplay,
			      DefaultRootWindow(gDisplay),
			      width_save, height_save, 8);
  if (!pixmap_save) return ;

  switch (Show_selected) 
  {
    case BORD: bord_proc(pixmap_save, data_display);
               break;
    case ZONE: zone_proc(pixmap_save, data_display);
               break;
    case IMAGE: image_proc(pixmap_save, data_display);
               break; 
    case MASQUE: mask_proc(pixmap_save, data_display);
               break;
    case TWO:  two_proc(pixmap_save, data_display);
               break;
  }

  PRE_PRO_options_widget =
     build_PRE_PRO_options_widget(Save, 310, "");
  XtManageChild(PRE_PRO_options_widget);
}



/******************************************************
/   activateCallback for Widget  Show_original
/*****************************************************/

void
Show_original_actcall(Show_button, data_display, callData)
	Widget Show_button;
        xs_struc_display_menu * data_display;
	caddr_t callData;
{
  image_proc(XtWindow(data_display->Drawing_Area), data_display);
  Show_selected = IMAGE;
}


/******************************************************
/   activateCallback for Widget  Show_mask
/*****************************************************/

void
Show_mask_actcall(Show_button, data_display, callData)
	Widget Show_button;
        xs_struc_display_menu * data_display;
	caddr_t callData;
{
  mask_proc(XtWindow(data_display->Drawing_Area), data_display);
  Show_selected = MASQUE;
}


/******************************************************
/   activateCallback for Widget  Show_two
/*****************************************************/

void
Show_two_actcall(Show_button, data_display, callData)
	Widget Show_button;
        xs_struc_display_menu * data_display;
	caddr_t callData;
{
  two_proc(XtWindow(data_display->Drawing_Area), data_display);
  Show_selected = TWO;
}


/******************************************************
/   activateCallback for Widget  Show_image_mask
/*****************************************************/


void
Show_image_mask_actcall(Show_button, data_display, callData)
	Widget Show_button;
        xs_struc_display_menu * data_display;
	caddr_t callData;
{
  zone_proc(XtWindow(data_display->Drawing_Area), data_display);
  Show_selected = ZONE;
}




/******************************************************
/   activateCallback for Widget  Show_image
/*****************************************************/


void
Show_image_actcall(Show_button, data_display, callData)
	Widget Show_button;
        xs_struc_display_menu * data_display;
	caddr_t callData;
{
  bord_proc(XtWindow(data_display->Drawing_Area), data_display);
  Show_selected = BORD;
}



/******************************************************
/   activateCallback for Widget  Show_histo_region
/*****************************************************/

void
Show_histo_actcall(Show_histo, data_display, callData)
	Widget Show_histo;
        xs_struc_display_menu * data_display;
	caddr_t callData;
{
  afficher_histo (Histo_selected, data_display);
}

void
Show_histo_region_actcall(Show_histo, client_data, callData)
	Widget Show_histo;
	caddr_t client_data;
	caddr_t callData;
{
  Histo_selected = ZONE;
}

void
Show_histo_border_actcall(Show_histo, client_data, callData)
	Widget Show_histo;
	caddr_t client_data;
	caddr_t callData;
{
  Histo_selected = BORD; 
}

void
Show_histo_image_actcall(Show_histo, client_data, callData)
	Widget Show_histo;
	caddr_t client_data;
	caddr_t callData;
{
  Histo_selected = IMAGE; 
}


/******************************************************
/   activateCallback for Widget  Pixrect_stat_region 
/*****************************************************/

void
Pixrect_stat_actcall(Pixrect_stat, data_display, callData)
	Widget Pixrect_stat;
        xs_struc_display_menu * data_display;
	caddr_t callData;
{
  Widget Statistic_display;
  struct image_ecran * zone_desc;
  char    titre[25];

  if (Stat_selected == BORD) 
  {
    zone_desc = stat_zone(BORD, data_display);
    if (zone_desc)
    {
      bord_proc(XtWindow(data_display->Drawing_Area), data_display);
      strcpy (titre, paneltabs[52]);
    }
  }
  else 
  {
    zone_desc = stat_zone(ZONE, data_display);
    if (zone_desc)
    {
      zone_proc(XtWindow(data_display->Drawing_Area), data_display);
      strcpy (titre, paneltabs[53]);
    }
  }	
  Statistic_display = build_statistics_widget (Pixrect_stat, 
					       zone_desc, titre);
  XtManageChild(Statistic_display);
  free(zone_desc);
}


void
Pixrect_stat_region_actcall(Pixrect_stat, client_data, callData)
	Widget Pixrect_stat;
    	caddr_t client_data;
	caddr_t callData;
{
  Stat_selected = ZONE;
}


/******************************************************
/   activateCallback for Widget  Pixrect_stat_border
/*****************************************************/

void
Pixrect_stat_border_actcall(Pixrect_stat, client_data, callData)
	Widget Pixrect_stat;
    	caddr_t client_data;
	caddr_t callData;
{
  Stat_selected = BORD;
}


/******************************************************
/   activateCallback for Widget  QUIT 
/*****************************************************/

void
QUIT_region_actcall(QUIT, data_display, callData)
	Widget QUIT;
        xs_struc_display_menu * data_display;
	caddr_t callData;
{
  if (data_display->MaskPix) {
    XFreePixmap(gDisplay, data_display->MaskPix);
    data_display->MaskPix = NULL;
  }
  if (data_display->masque)
  {
    free(data_display->masque);
    data_display->masque = NULL;
  }

  if (data_display->ret->pixmap)
  {
    XCopyArea (gDisplay, data_display->ret->pixmap, 
	       XtWindow(data_display->Drawing_Area), default_gc, 0, 0,
	       data_display->im_desc->ncolonne, 
	       data_display->im_desc->nligne, 0, 0);
  }

  XtUnmanageChild (XtParent(XtParent(QUIT)));
}


void
keep_sensitive_button(QUIT, unsensitive_button, callData)
	Widget QUIT;
        Widget unsensitive_button;
	caddr_t callData;
{
  Arg args[MAX_ARGS];
  int n;

  n = 0;
  XtSetArg(args[n],XmNsensitive, True); n++;
  XtSetValues(unsensitive_button,args,n);
}
