/* Control consisting of several other controls
   Copyright (C) 2005 Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
02110-1301 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */


package javax.sound.sampled;

/**
 * A compound control provides control over several other controls.
 * @since 1.3
 */
public class CompoundControl extends Control
{
  /**
   * This describes a single compound control.
   * @since 1.3
   */
  public static class Type extends Control.Type
  {
    /**
     * Create a new Type given its name.
     * @param name the name of the type
     */
    protected Type(String name)
    {
      super(name);
    }
  }

  private Control[] memberControls;

  /**
   * Create a new compound control given its type and members.
   * @param type the type of the compound control
   * @param members the members of the compound control
   */
  protected CompoundControl(Type type, Control[] members)
  {
    super(type);
    // FIXME: clone?
    this.memberControls = members;
  }

  /**
   * Return the members of this compound control.
   */
  public Control[] getMemberControls()
  {
    // FIXME: clone?
    return memberControls;
  }

  /**
   * Return a string description of this compound control.
   */
  public String toString()
  {
    StringBuffer result = new StringBuffer();
    result.append(super.toString());
    result.append(": ");
    for (int i = 0; i < memberControls.length; ++i)
      {
	if (i > 0)
	  result.append(", ");
	result.append(memberControls[i].toString());
      }
    return result.toString();
  }
}
