
/* Generated by Interface Builder */

#import <objc/Object.h>
#import <appkit/nextstd.h>	/* gets stdio */
#import <appkit/Form.h>		/* for NXCoord, etc. */

typedef struct _datahunk {
    char  *filename;
    float *x;
    float **y;
    int   npoints;
    int   ncurves;
    NXPoint datamin;
    NXPoint datamax;
    BOOL    xaxislin;
    BOOL    yaxislin;
} datahunk;

@interface Plot:Object
{
    id  datahunkList;		/* list of datahunk structures */
    id	mainTitle;		/* the main title object */
    id	yMax;			/* the yMax object */
    id	xMax;			/* the xMax object */
    id	canvas;			/* the PlotView object */
    id	yMin;			/* the yMin object */
    id	xMin;			/* the xMin object */
    id	yInc;			/* the yInc object */
    id	xInc;			/* the xInc object */
    id	yTitle;			/* the yTitle object */
    id	xTitle;			/* the xTitle object */
    id  lineText;		/* the lineText object */
    id  symbolText;		/* the symbolText object */
    id  lineMatrix;		/* the lineMatrix object */
    id  lineThickness;		/* the lineThickness object */
    id  symbolMatrix;		/* the symbolMatrix object */
    id  symbolSize;		/* the symbolSize object */
    id  legendTitle;		/* the legend title object */
    id  legendForm;		/* the legend form object */
    id  legendOnOff;		/* the legend on/off button */
    id  legendBoxOnOff;		/* the legend Box on/off button */
    id  gridOnOff;		/* the grid on/off button */
    id  borderBoxThickness;	/* the border box thickness slider */
    id  legendMove;		/* the legend Move button */
    id  zoomOnOff;		/* the zoom on/off button */
    id  plotButton;		/* the plot Button object */
    id  xLinLog;		/* the x-axis linear/logarithmic button */
    id  yLinLog;		/* the y-axis linear/logarithmic button */
    id  changeLegendFont;	/* the change legend font on/off button */
    id  changeLegendTitleFont;	/* the change leg. title font on/off button */
    id  changeXTitleFont;	/* the change x title font on/off button */
    id  changeYTitleFont;	/* the change y title font on/off button */
    id  changeMainTitleFont;	/* the change main title font on/off button */
    id  changeTicLabelFont;	/* the change tic label font on/off button */
    id  axesOnOff;		/* the axes on/off button */
    id  minorTicMarksOnOff;	/* the minor tic marks on/off button */
    id  ticMarksOutInOff;	/* the tic marks out/in/off button */

    const char * maintitle;
    const char * xtitle;
    const char * ytitle;

    int ncurvestotal;		/* total number of curves  */

    int nfilestotal;		/* total no. of files "open" */

    NXPoint globaldatamin;	/* xmin and ymin from the data */
    NXPoint globaldatamax;	/* xmax and ymax from the data */

    int ticmarkdir;		/* 1=out, -1=in, 0=none */
}

/* class methods */
+ new;

/* instance methods */

- (NXCoord *)xdata:(int)n;
- (NXCoord **)ydata:(int)n;

- (int) nPoints:(int)n;
- (int) nCurves:(int)n;
- (int) nCurvesTotal;
- (int) nFiles;

- (const char *) provideXTitle;
- (const char *) provideYTitle;
- (const char *) provideMainTitle;
- (const char *) provideCurveTitle:(int)aCurve;
- (const char *) provideLegendTitle;

- makeXTitle:(char *)title;
- makeYTitle:(char *)title;
- makeMainTitle:(char *)title;
- makeCurveTitle:(int)aCurve :(char *)title;
- makeLegendTitle:(char *)title;

- makeLineStyle:(int)aCurve :(int)lineStyle;
- makeSymbolType:(int)aCurve :(int)symType;
- makeLineThickness:(int)choice;
- makeSymbolSize:(int)choice;

- (BOOL) shouldDrawLegendBox;
- (BOOL) shouldDrawLegend;
- (BOOL) shouldDrawGrid;
- (float) provideBorderBoxThickness;
- forceBorderBoxThickness:(float)t;
- (BOOL) shouldMoveLegend;
- (BOOL) doZoom;
- (BOOL) xaxisLog;
- (BOOL) yaxisLog;
- forceXaxisLinear;
- forceYaxisLinear;
- forceXaxisLog;
- forceYaxisLog;
- maybeDrawLegend:(int) i;
- maybeDrawLegendBox:(int) i;
- maybeDrawGrid:(int) i;
- maybeDrawAxes:(int) i;
- maybeDrawMinorTicMarks:(int) i;
- (BOOL) shouldChangeLegendFont;
- (BOOL) shouldChangeLegendTitleFont;
- (BOOL) shouldChangeXTitleFont;
- (BOOL) shouldChangeYTitleFont;
- (BOOL) shouldChangeMainTitleFont;
- (BOOL) shouldChangeTicLabelFont;
- (BOOL) shouldDrawMinorTicMarks;
- forceTicMarksOut:sender;
- forceTicMarksIn:sender;
- forceNoTicMarks:sender;
- (int) provideTicMarkDir;
- changeTicMarksButton: (int)i;
- (BOOL) shouldDrawAxes;

- (int)providelinestyle: (int)aCurve;
				/* 0=solid, 1=dash, 2=dot, 3=chain dash */
				/* 4=chain dot, 5=none */
- (int)providesymbolstyle: (int)aCurve;
				/* 0=none, 1=circle, 2=x, 3=up triangle */
				/* 4=down triangle, 5=diamond, 6=square  */
				/* 7=plus */

- (int)providelinethickness;    /* 0=thin, 1=medium, 2=thick */

- (int)providesymbolsize;       /* 0=pixel, 1=small, 2=medium, 3=large */

- (float)provideXmin;
- (float)provideXmax;
- (float)provideXinc;
- (float)provideYmin;
- (float)provideYmax;
- (float)provideYinc;

- (float)provideGlobalXmin;
- (float)provideGlobalYmin;

- resetXmin:(float)x;
- resetXmax:(float)x;
- resetXinc:(float)x;
- resetYmin:(float)x;
- resetYmax:(float)x;
- resetYinc:(float)x;

- resetMinMax:sender;

- drawPlotButton:(int)state;

- drawPlot:sender;

- (int) readData:(NXStream *)aDataStream :(char *)dataFile;

- checkLinLog:(datahunk *)pdh;
- checkGlobalLinLog;

- findMinMax:(datahunk *)pdh;
- findGlobalMinMax;
- niceMinMaxInc;

- adjustLineStyleMatrix:(int)column :(int)row;
- adjustSymbolTypeMatrix:(int)column :(int)row;
- redisplayLineStyleMatrix;
- redisplaySymbolTypeMatrix;
- adjustPanels:(int)oldn :(int)newn;

- open:sender;

- openFile:(char *)dataFile;

- plotPrepAndDraw;

- removeAllFiles:sender;

- removeAndOpen:sender;

- saveEPS:sender;

- sanityCheck;

@end
