#import <objc/Object.h>

@interface PerspMat : Object	// Perspective projections of 3-d coordinates
{
  float mat[16];
}

/* Factory methods */

+new;				// as identity matrix
+newCenter:(float)cx :(float)cy :(float)cz ;  // centered at (cx,cy,cz)

/* Public methods */

-reset;
-(float **)render:(int)n :(float *)x :(float *)y :(float *)z :(float **)results;
-(float *)as_DPSpath:(int)n :(float *)x :(float *)y :(float *)z :(float *)results;
-(float *)as_DPSpath:(int)n :(float *)x :(float *)y :(float *)z
  :(float *)results offset:(float *) o_set;
-translate:(float)dx :(float)dy :(float)dz;
-scale:(float)sx :(float)sy :(float)sz;
-x_rotation:(float)radians;
-x_rotation_cs:(float)cos_angle :(float)sin_angle;
-y_rotation:(float)radians;
-y_rotation_cs:(float)cos_angle :(float)sin_angle;
-z_rotation:(float)radians;
-y_rotation_cs:(float)cos_angle :(float)sin_angle;
-perspective:(float)distance;
-perspective_inv:(float)invdistance;

@end
