/* Misc3DDeviceServer m				 
 *
 * This is the basic server of the App. It manages all big abstraction
 * and manages the loading, initializing and serving.
 *
 * For interface-info see the header file. The comments in this file mostly
 * cover only the real implementation details.
 *
 * Written by: 		Thomas Engel
 * Created:    		07.04.1994 (Copyleft)
 * Last modified: 	11.04.1994
 */


#import "Misc3DDeviceServer.h"
#import "Misc3DMetaDriver.h"
#import <misckit/MiscSwapView.h>

@implementation Misc3DDeviceServer

- appWillInit:sender
{
	return self;
}

- appDidInit:sender
{
	// Let's predefine the metadevices will be followed by 
	// setting up the PDO port!
	// Or PDO server has to run at high priority because we need to receive
	// the sync messages even when we are using the AppKit controls etc.
	// It might be set to 10...30. They all work fine at this time.
	
	id	myServer;
	
	mouse = [Misc3DMetaDriver new];
	glove = [Misc3DMetaDriver new];
	
	myServer = [NXConnection registerRoot:self 
							 withName:"localhost/3DDeviceServer"];
	[myServer runFromAppKitWithPriority:NX_MODALRESPTHRESHOLD];

	// Ensure that our device panel shows the right views.
	// We will do this by fooling it with a none existent swap-action.
	
	[mainSwapView swapContentView:deviceMatrix];
	[[mainSwapView window] makeKeyAndOrderFront:self];
	
    return self;
}

- setMouse:aDriver
{
	[mouse setRealDriver:aDriver];
	return self;
}

- setGlove:aDriver
{
	[glove setRealDriver:aDriver];
	return self;
}

- setDisplay:aDriver
{
	[display setRealDriver:aDriver];
	return self;
}

- setScanner:aDriver
{
	[scanner setRealDriver:aDriver];
	return self;
}

- setMotionTracker:aDriver
{
	[motionTracker setRealDriver:aDriver];
	return self;
}

- mouse
{
	return mouse;
}

- glove
{
	return glove;
}

- display
{
	return display;
}

- scanner
{
	return scanner;
}

- motionTracker
{
	return motionTracker;
}

@end

/*
 * History: 11.04.94 Included the meta drivers.
 *
 *			09.04.94 Added the PDO port and some more device methods.
 *
 *			07.04.94 My first try. Just to get it running.
 *
 *
 * Bugs: - See the H.file right now.
 */