#import "InfoController.h"
#import "StringStorage.h"
#import "MailSpeaker.h"
#import "version.h"
#import <appkit/appkit.h>

@implementation InfoController

- init
{
   [super init];
   [self setDocType: "info"];
   return self;
}

- awakeFromNib
{
   [versionText setStringValue: version];
   [maintainerText setStringValue: maintainer];
   return self;
}

- sendComments: sender;
{
   char subject[1024];
   port_t port;

   port = NXPortFromName("Mail", NULL);
   if(!port)
       return nil;

   port_deallocate(task_self(),port);
   port = NXPortFromName("MailSendDemo", NULL);

   sprintf(subject,"Re: %s %s", [NXApp appName], version);

   if (port != PORT_NULL) 
   {
      MailSpeaker *mail = [[MailSpeaker alloc] init];
      int winNum;

      [mail setSendPort: port];
      [mail openSend: &winNum];
      [mail setTo: maintainer inWindow: winNum];
      [mail setSubject: subject inWindow: winNum];
		
      [mail free];
      port_deallocate(task_self(),port);
   }

   return self;
}

@end
