/*
** TokenString.h,v 1.2 1992/05/21 22:47:25 nwc Exp
**
** Copyright (c) 1991 Ronin Consulting, Inc.
*/

#import "StringStorage.h"

/*
** TokenString is a subclass of StringStorage which allows tokens, i.e. character
** sequences separated by a separator to be pulled from the string.
*/ 

@interface TokenString : StringStorage
{
   char separator;
   char *start;
   char lastEnd;
   BOOL nullTokens;
}

- setSeparator: (char) aChar;		     /* set the separator, a space ' ' is the default */
- (char) separator;			     /* return current separator */

/* 
 * do two separators in a row indicate a null token? If nullTokens is set to YES and
 * the string contains two separators in a row then the -pop method will return a NULL.
 * If nullTokens is set to NO (the default) then multiple sequential separators are treated
 * as a single separator and the next non-null token is returned.
 */
- setNullTokens: (BOOL) toggle;
- (BOOL) nullTokens;


- (const char *) popStringValue;	     /* return the TokenString's next token */

@end
