/*

  Ronin Consulting, Inc.
    Copyright (C) 1992, Nicholas Christopher (nwc@gun.com)

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/
#import "EnhancedText.h"
#import <appkit/nextstd.h>
#import <string.h>

static char *returnBuffer = (char *)0;

@implementation Text (EnhancedText)

- appendString: (const char *) str
{
   int len;

   len = [self textLength];
   [self setSel: len : len];
   [self replaceSel: str];
   [self scrollSelToVisible];
   
   return self;
}

- empty: sender
{
   int x;
   BOOL editable, selectable;

   x = [self textLength] + 1;
   [self setSel: 0 : x + 1];		     /* select the entire text */

   /*
    * To delete the text must be editable so copy aside the current
    * editable and selectable settings, set the text editable, delete
    * and then restore the copied aside values.
    */
   editable = [self isEditable];
   selectable = [self isSelectable];

   [self setEditable: YES];
   [self delete: sender];

   [self setEditable: editable];
   [self setSelectable: selectable];

   return self;
}

- (const char *) selectedText
{
   NXSelPt start, end;
   int numChars;

   [self getSel: &start : &end];
   numChars = end.cp - start.cp;

   if(returnBuffer)
   {
      NX_FREE(returnBuffer);
      returnBuffer = (char *)0;
   }
   
   NX_MALLOC(returnBuffer, char, numChars + 1);

   [self getSubstring: returnBuffer start: start.cp length: numChars];
   returnBuffer[numChars] = (char)0;
   
   return (const char *)returnBuffer;
}


@end
