/*
** Defaults.m,v 1.2 1992/08/17 19:13:26 nwc Exp
**
** Copyright (c) 1991 Ronin Consulting, Inc.
*/

#import "Defaults.h"
#import <appkit/Application.h>

@implementation Defaults

static id  theOnlyOne = nil;
static NXDefaultsVector noDefs = {{NULL}};

+ new
{
   if(!theOnlyOne)
   {
      theOnlyOne = self = [super new];
      appName = [NXApp appName];
      registered = NO;
   }
   else
       self = theOnlyOne;
   
   return self;
}


- regDefaults:(NXDefaultsVector) defaultsVector
{
   int x = 0;

   if(!registered)
   {
      NXRegisterDefaults(appName,noDefs);
      registered = YES;
   }

   /*
    * I use NXSetDefault instead of NXRegisterDefaults becuase this make regDefaults
    * calls cumulative... i.e. if called multiple times the union of the vectors will
    * be in affect.
    */

   while(defaultsVector[x].name)
   {
      if(!NXGetDefaultValue(appName,defaultsVector[x].name))
	  NXSetDefault(appName, defaultsVector[x].name, defaultsVector[x].value);
      x++;
   }

   return self;
}


- (const char *)get: (const char *) aDefault
{
   if(!registered)
       [self regDefaults: noDefs];

   return NXGetDefaultValue(appName, aDefault);
}

- set: (const char *) aDefault to: (const char *)aValue
{
   if(!registered)
       [self regDefaults: noDefs];

   NXSetDefault(appName, aDefault, aValue);
   return self;
}

- (const char *) readDB: (const char *) aDefault
{
   if(!registered)
       [self regDefaults: noDefs];

   return NXReadDefault(appName, aDefault);
}

- writeDB: (const char *) aDefault as: (const char *)aValue
{
   if(!registered)
       [self regDefaults: noDefs];

   NXWriteDefault(appName, aDefault, aValue);
   return self;
}


- removeDB: (const char *) aDefault
{
   if(!registered)
       [self regDefaults: noDefs];

   NXRemoveDefault(appName, aDefault);
   return self;
}

- update
{
   if(!registered)
       [self regDefaults: noDefs];

   NXUpdateDefaults();
   return self;
}


@end


