/*	
**    Copyright (C) 1992  Ronin Consulting, Inc.
**
**    This program is free software; you can redistribute it and/or modify
**    it under the terms of the GNU General Public License as published by
**    the Free Software Foundation; version 1.
**
**    This program is distributed in the hope that it will be useful,
**    but WITHOUT ANY WARRANTY; without even the implied warranty of
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**    GNU General Public License for more details.
**
**    You should have received a copy of the GNU General Public License
**    along with this program; if not, write to the Free Software
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#import "GISOPrefPanel.h"
#import "Defaults.h"
#import "StringStorage.h"
#import <appkit/appkit.h>
#import <libc.h>
#import <string.h>
#include <sys/types.h>
#include <sys/stat.h>


static NXDefaultsVector appDefs =  
{
{ "StoreDirectory", "./English.lproj" },
{ "TmpDirectory", "/tmp"},
{ "SaveDir", "~/" },
{ "OpenDir", "~/" },
{ "AutoPlay","Yes"},
{ "AutoConvert","Yes"},
{NULL}
};

@implementation GISOPrefPanel

- init
{
   [super init];

   [defaults regDefaults: appDefs];
   return self;
}

- setTemp: sender
{
   id op = [OpenPanel new];

   [op chooseDirectories: YES];

   if([op runModalForDirectory: [defaults get: "TmpDirectory"] file: (char *)0 ] == NX_OKTAG)
      [tmpDirectory setStringValue: [op filename]];

   [op chooseDirectories: NO];
   return self;
}

- setMenus: sender
{
   id op = [OpenPanel new];

   [op chooseDirectories: YES];

   if([op runModalForDirectory: [defaults get: "StoreDirectory"] file: (char *)0 ] == NX_OKTAG)
      [storeDirectory setStringValue: [op filename]];
   
   [op chooseDirectories: NO];
   return self;
}


- save: sender
{
   struct stat buf;
   char *ndir;
   id buffer = [[StringStorage alloc] init];

   if([[sender window] makeFirstResponder: [sender window]])
       [[sender window] endEditingFor: nil];
   else
   {
      NXBeep();
      return self;
   }
   
   ndir = (char *)[storeDirectory stringValue];
   
   if(ndir && *ndir && strcmp(ndir,[defaults get: "StoreDirectory"]))
   {
   
      if(stat(ndir, &buf) || !(buf.st_mode & S_IFDIR))
      {
	 NXBeep();
	 return self;
      }

      [defaults writeDB: "StoreDirectory" as: ndir];
   
   
      [buffer setStringValue: "cp English.lproj/inHotList.strings "];
      [buffer appendStringValue: ndir];
      [buffer appendStringValue: "/inHotList.strings"];
      system([buffer stringValue]);
      [buffer setStringValue: "cp English.lproj/inHotListConfig.strings "];
      [buffer appendStringValue: ndir];
      [buffer appendStringValue: "/inHotListConfig.strings"];
      system([buffer stringValue]);
      [buffer setStringValue: "cp English.lproj/outHotList.strings "];
      [buffer appendStringValue: ndir];
      [buffer appendStringValue: "/outHotList.strings"];
      system([buffer stringValue]);
      [buffer setStringValue: "cp English.lproj/outHotListConfig.strings "];
      [buffer appendStringValue: ndir];
      [buffer appendStringValue: "/outHotListConfig.strings"];
      system([buffer stringValue]);
   }
   

   ndir = (char *)[tmpDirectory stringValue];
   
   if(ndir && *ndir && strcmp(ndir,[defaults get:"TmpDirectory"]))
   {
      if(stat(ndir, &buf) || !(buf.st_mode & S_IFDIR))
      {
	 NXBeep();
	 return self;
      }

      [defaults writeDB: "TmpDirectory" as: ndir];
   }
   
   [defaults writeDB: "AutoPlay" as: ([autoPlay state] ? "YES" : "NO")];
   [defaults writeDB: "AutoConvert" as: ([autoConvert state] ? "YES" : "NO")];

   return [[sender window] performClose: sender];
}

- windowDidBecomeKey:sender
{
   [storeDirectory setStringValue: [defaults get: "StoreDirectory"]];
   [tmpDirectory setStringValue: [defaults get: "TmpDirectory"]];
   [autoPlay setState: (*[defaults get: "AutoPlay"] == 'Y')];
   [autoConvert setState: (*[defaults get: "AutoConvert"] == 'Y')];
   return self;
}
@end
