#import "FileName.h"
#include <string.h>
#include <libc.h>

@implementation StringStorage (FileName)

- (const char *) basename
{
   char *ptr = rindex((char *)dataPtr,'/');

   return ((ptr && ptr[1])? (const char *)(ptr + 1) : (const char *)dataPtr);
}

- (const char *) fileType
{
   char *ptr = rindex((char *)dataPtr,'.');

   return ((ptr && ptr[1])? (const char *)(ptr + 1) : "");
}

- mktemp
{
   static char extraChar = 'a';
   static short calls = 0;

   if(calls > 25)
   {
      calls = 0;
      extraChar++;
      if(extraChar > 'z')
	  return nil;
   }

   [self appendCharValue: extraChar];
   [self appendStringValue: "XXXXXX"];
   mktemp((char *)[self stringValue]);
   calls++;
   return self;
}


@end
