/*
** Defaults.h,v 1.3 1992/09/24 03:34:29 nwc Exp
**
** Copyright (c) 1991 Ronin Consulting, Inc.
** 
** This object is designed to simplyfy the use of the NeXT defaults facilities.
**
*/

#import <objc/Object.h>
#import <defaults/defaults.h>

@interface Defaults : Object
{
   const char *appName;
   BOOL registered;
}

/*
** This is a shared object so allocate it with new.
*/
+ new;

/*
** Register a defaults vector. If no vector is registered before a get/set (or any other) call is
** used then an empty vector is used. UNLIKE NXRegisterDefaults repeated calls to this result
** in a union of the vectors, not replacement!
*/
- regDefaults: (NXDefaultsVector) defaultsVector; 

/*
** Get/Set a default.
*/
- (const char *) get: (const char *) aDefault;
- set: (const char *) aDefault to: (const char *)aValue;

/*
** Get/Set that Ignore the cached values and use the actual database.
*/
- (const char *) readDB: (const char *) aDefault;
- writeDB: (const char *) aValue as: (const char *)aValue;

/*
** Remove a default from the database.
*/
- removeDB: (const char *) aDefault;

/*
** Update ALL cached values from the database.
*/
- update;

@end


