/*	
**    Copyright (C) 1992  Ronin Consulting, Inc.
**
**    This program is free software; you can redistribute it and/or modify
**    it under the terms of the GNU General Public License as published by
**    the Free Software Foundation; version 1.
**
**    This program is distributed in the hope that it will be useful,
**    but WITHOUT ANY WARRANTY; without even the implied warranty of
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**    GNU General Public License for more details.
**
**    You should have received a copy of the GNU General Public License
**    along with this program; if not, write to the Free Software
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#import <objc/Object.h>

@interface Controller:Object
{
    id inType;
    id outType;
    id inRate;
    id outRate;
    id inRateText;
    id outRateText;
    id inDataForm;
    id outDataForm;
    id inDataSize;
    id outDataSize;
    id inChannels;
    id outChannels;
    id inHotList;
    id outHotList;
    id volume;
    id dialog;
    id swapBytes;
    id effect;
    id effectArgText;
    id playButton;
    id whichRadio;
    id entryName;

    id panel;
    id openPanel;
    id inFile;
    id savePanel;
    id outFile;
    id dataFormSwitches;
    id dataSizeSwitches;
    id inHotListStr;
    id inHotListConfig;
    id outHotListStr;
    id outHotListConfig;
    id strings;
    id theSound;
    id soundMeter;
    id convert;
    id defaults;
    id subprocess;
    char **fileTypes;

    BOOL _waiting;
}

- init;
- convert:sender;
- openFile:sender;
- saveFile:sender;
- saveToHotList: sender;
- loadFromHotList: sender;
- loadType: (BOOL) inputOrOutput fromString: (const char *)str;
- playIt: sender;
- stopPlay: sender;

- copyValue: sender;

- (int)loadPopUpList: button with: strings from: (int) count;

/* Application Delegate */

- appDidInit: sender;
- cleanKill: sender;			     /* not a delegate but App related */
- (BOOL)appAcceptsAnotherFile:sender;
- (int)app:sender openFile:(const char *)filename type:(const char *)aType;

/* Sound Delegates */

- willPlay: sender;
- didPlay: sender;
- hadError: sender;

/* Subprocess Delegates */

- subprocess:sender done:(int)exitStatus;
- subprocess:sender output:(char *)buffer;
- subprocess:sender stderrOutput:(char *)buffer;
- subprocess:sender error:(const char *)errorString;

/* Service messages */
- convertSound: (id)pasteboard userData:(const char *)userData error:(char **)msg;

@end
