#include <stdio.h>
#include <vga.h>
#include <vgamouse.h>

unsigned char cursor[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x03, 0x03, 0x03, 0x03, 0x00, 0x00, 0x00,
	0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x03, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

unsigned char mcursor[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01,
	0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
};

unsigned char tmp[64];
static int ostatus, orow = 0, ocol = 0;


/****************************************************************************
** Returns a -1 if mouse IS installed					   **
****************************************************************************/
int mouse_installed(void)
{
int r;
unsigned char *d, *s;

	r = mouse_init("/dev/mouse", MOUSE_MICROSOFT, MOUSE_DEFAULTSAMPLERATE);
	if (r != 0)
		return -1;
	mouse_setxrange(0, 319);
	mouse_setyrange(0, 199);
	mouse_setwrap(MOUSE_NOWRAP);

	return 0;
}

/****************************************************************************
** Shows the mouse cursor						   **
****************************************************************************/
void mouse_show_cursor(void)
{
}

/****************************************************************************
** Turns mouse cursor o02						   **
****************************************************************************/
void mouse_hide_cursor(void)
{
}

static int __mouse_on = 0;

/****************************************************************************
** Returns button status, mouse row and column (passed by &mrow,&mcol)	   **
****************************************************************************/
void mouse_read_cursor(int *bstatus,int *mrow,int *mcol)
{
unsigned char *d, *s;
int i, j;

	mouse_update();
	*bstatus = mouse_getbutton();
	*mrow = mouse_gety();
	*mcol = mouse_getx();

	if ((*mcol != ocol) || (*mrow != orow) ||(__mouse_on == 0)) {
		if (__mouse_on == 0) {
			s = graph_mem;
			d = tmp;
			for (i = 0; i < 8; i++) {
				memcpy(d, s, 8);
				s += 320;
				d += 8;
			}
			__mouse_on = 1;
		}

		/* restore old image*/
		s = tmp;
		d = graph_mem + (orow * 320) + ocol;
		for (i = 0; i < 8; i++) {
			memcpy(d, s, 8);
			d += 320;
			s += 8;
		}
		/* save new area */
		s = graph_mem + (*mrow * 320) + *mcol;
		d = tmp;
		for (i = 0; i < 8; i++) {
			memcpy(d, s, 8);
			s += 320;
			d += 8;
		}
#if 1
		/* paint cursor */		
		s = graph_mem + (*mrow * 320) + *mcol;
		d = mcursor;
		for (i = 0; i < 8; i++) {
			for (j = 0; j < 8; j++, d++, s++) {
				if (*d == 0x00)
					*s = (*d)&(*s);
			}
			s += 320 - 8;
		}

		s = graph_mem + (*mrow * 320) + *mcol;
		d = cursor;
		for (i = 0; i < 8; i++) {
			for (j = 0; j < 8; j++, d++, s++)  {
					*s = (*d)|(*s);
			}
			s += 320 - 8;
		}
#endif
		orow = *mrow; ocol = *mcol;
	}
}

/****************************************************************************
** Sets mouse cursor to desired row, column				   **
****************************************************************************/
void mouse_set_cursor(int mrow,int mcol)
{
}

/****************************************************************************
** Returns button status for desired button (in bstatus)		   **
** column is modified for current vga video mode			   **
****************************************************************************/
void mouse_press_info(int *bstatus,int *bcount,int *mrow,int *mcol)
{

}

/****************************************************************************
** Returns button release status for desired button (in bstatus)	   **
** column is modified for current vga video mode			   **
****************************************************************************/
void mouse_release_info(int *bstatus,int *bcount,int *mrow,int *mcol)
{

}

/****************************************************************************
** Defines left and right columns for mouse to travel in.		   **
** Uses mouse coordinates 0-639						   **
****************************************************************************/
void mouse_set_minmax_columns(int mincol,int maxcol)
{
}

/****************************************************************************
** Defines top and bottom rows for mouse to travel in.			   **
** Uses mouse coordinates 0-349						   **
****************************************************************************/
void mouse_set_minmax_rows(int minrow,int maxrow)
{
}

/****************************************************************************
** Set shape of graphics mouse cursor.	8 byte mask, Hot Spot row, col.	   **
****************************************************************************/
void mouse_set_graphics_cursor(int hsrow,int hscol,char *mask)
{
}

/****************************************************************************
** Set mickey to pixel ratio. Default ratio is 8 mickeys to 8 pixels for   **
** columns and 16 mickeys to 8 pixels for rows.				   **
** ratcol = ratio for columns (8/8 = 1)					   **
** ratrow = ratio for rows (16/8 = 2)					   **
** This routine controls speed at which cursor moves per mouse movement.   **
**									   **
**									   **
****************************************************************************/
void mouse_set_mickey_pixel_ratio(int ratrow,int ratcol)
{
}

