/******************************************************************************
*									      *
*	(C) 1993 by K. Ballueder					      *
*									      *
*	See README and COPYING for details.				      *
*									      *
*	Please feel free to contact me:					      *
*		kballued@charon.physik.uni-osnabrueck.de		      *
*		kballued@jupiter.rz.uni-osnabrueck.de			      *
*									      *
******************************************************************************/


/******

  SOUND.c  : Soundroutinen fuer BDASH

******/

enum soundfx
{ SND_TOD,
  SND_EXPLODE,
  SND_BUMP,
  SND_PING,
  SND_DOOR,
  SND_WATER
};
#define NUM_OF_SOUNDFX 6
#define SND_DESCR_FILE "bdash.snd"


#define SPEAKER     4
#define LPT1        0
#define LPT2        1
/** NOSOUND fuer RESPLAY nicht definiert, nur als interne Kennung fuer BDASH */
#define NOSOUND     999


struct sound
{ 
#ifdef OS_DOS
	unsigned seg, off;
	unsigned len_msw, len_lsw;
#else
	void *bufstart;
	unsigned len;
#endif
	unsigned rate;
} sounds[NUM_OF_SOUNDFX];

#ifdef OS_DOS
#	define PLAY 0
#	define SND_CALL(nr)  do_it(PLAY,globale_flags.soundport,sounds[(nr)].rate,\
			sounds[(nr)].seg,sounds[(nr)].off,\
                        sounds[(nr)].len_msw,sounds[(nr)].len_lsw)
	int do_it (int,int,int,unsigned int,unsigned int,unsigned int,unsigned int);
	 
#else
#	define SND_CALL(nr)  do_it(nr)
	void do_it(int nr);
#	ifdef OS_LINUX
#	endif
#endif

extern int sounds_ready;

void load_sounds(void);
void soundeffect(enum soundfx  nr);
