/******************************************************************************
*									      *
*	(C) 1993 by K. Ballueder					      *
*									      *
*	See README and COPYING for details.				      *
*									      *
*	Please feel free to contact me:					      *
*		kballued@charon.physik.uni-osnabrueck.de		      *
*		kballued@jupiter.rz.uni-osnabrueck.de			      *
*									      *
******************************************************************************/

/***********************************************************************

bdash.h:  Allgemeine Definitionen

*****************************************************end of header*****/

#ifndef _BDASH_H
#define _BDASH_H

#include "config.h"

#define NUM_OF_FIGURS 41
        /* Anzahl der definierten Bildelemente */
enum{	FELD_LEER,
	FELD_SPIELER_1,
	FELD_SPIELER_2,
	FELD_ERDE,
	FELD_DIAMANT_1,
	FELD_DIAMANT_2,
	FELD_DIAMANT_3,
	FELD_DIAMANT_4,
	FELD_STEIN,
	FELD_STEIN_2,
	FELD_BOMBE,
	FELD_BOMBE_2,
	FELD_EXPLODE,
	FELD_MAUER,
	FELD_KAEFER_1,
	FELD_KAEFER_1a,
	FELD_KAEFER_1b,
	FELD_KAEFER_1c,
	FELD_KAEFER_2,
	FELD_KAEFER_2a,
	FELD_KAEFER_2b,
	FELD_KAEFER_2c,
	FELD_KAEFER_3,
	FELD_KAEFER_3a,
	FELD_KAEFER_3b,
	FELD_KAEFER_3c,
	FELD_KAEFER_4,
	FELD_KAEFER_4a,
	FELD_KAEFER_5,
	FELD_KAEFER_5a,
	FELD_KEY_1,
	FELD_KEY_2,
	FELD_KEY_3,
	FELD_KEY_4,
	FELD_TOR_1,
	FELD_TOR_2,
	FELD_TOR_3,
	FELD_TOR_4,
	FELD_CHEESE_1,
	FELD_CHEESE_2,
	FELD_WATER
};

#define SHORT_BREAK	1
#define LONG_BREAK	2

#define CAN_FALL(object) (((object) >FELD_ERDE && (object) < FELD_EXPLODE)||((object)==FELD_CHEESE_2))
#ifdef __TURBOC__
int bioskey(int);

#define CLEAR_KEY_BUF while(bioskey(1)) bioskey(0);
#else
#	define CLEAR_KEY_BUF
#endif
extern unsigned char **level_table;
extern void *figur[NUM_OF_FIGURS];


extern
struct flagstype { 	int 	monochrome;
		   	int 	twoplayer;
		   	int 	slavemode;
		   	int 	comport;
		   	int 	soundport;
		   	char	*snd_dev;
		   	int 	son_pid;
   		   	int 	dead;
#ifdef ENABLE_CHEATING
			int 	cheating;
#endif
                 }
                 globale_flags;
#define LEVEL_NAME_MAXLEN	30
extern void fatal_error(char *err);

extern long bdash_speed;
extern unsigned char player_x[2], player_y[2];
extern unsigned level_x_size, level_y_size;
extern char level_name[LEVEL_NAME_MAXLEN+1];
extern unsigned act_level;
extern unsigned long points_required;
extern unsigned char keys[2][4];

  struct memlist_node
  { void *address;
    struct memlist_node *next;
  };

#define __malloc(size) malloc(size)

#ifdef K_ALLOC
  extern struct memlist_node *mem_first_block;

  extern void *k_alloc(size_t n, size_t size);

  #define malloc(size) k_alloc(1,size)
  #define calloc(n,size) k_alloc(n,size)
#endif
#endif
