/*
 *  debug.c - Global functions for printing debug/error/warning/info-messages.
 *
 *  (C) 1994 Mikael Nordqvist (d91mn@efd.lth.se, mech@df.lth.se)
 */

#include <stdio.h>
#include <stdarg.h>

#include "mod.h"

extern struct options opt;

void debug(char *s, ...)
{
    va_list args;

    if(1) {
	va_start(args, s);
	vprintf(s, args);
	fflush(stdout);
	va_end(args);
    }
}

void error(char *s, ...)
{
    va_list args;

    va_start(args, s);
    vprintf(s, args);
    fflush(stdout);
    va_end(args);

    exit(1);
}

void warning(char *s, ...)
{
    va_list args;

    va_start(args, s);
    vprintf(s, args);
    fflush(stdout);
    va_end(args);
}

void info(char *s, ...)
{
    va_list args;

    if(opt.verbose) {
	va_start(args, s);
	vprintf(s, args);
	fflush(stdout);
	va_end(args);
    }
}
