/* itemInfo.c
   collect for display information about a gopher item or directory */

     /*---------------------------------------------------------------*/
     /* Xgopher        version 1.2     20 November 1991               */
     /*                version 1.1     20 April 1991                  */
     /*                version 1.0     04 March 1991                  */
     /* X window system client for the University of Minnesota        */
     /*                                Internet Gopher System.        */
     /* Allan Tuchman, University of Illinois at Urbana-Champaign     */
     /*                Computing and Communications Services Office   */
     /* Copyright 1992 by                                             */
     /*           the Board of Trustees of the University of Illinois */
     /* Permission is granted to freely copy and redistribute this    */
     /* software with the copyright notice intact.                    */
     /*---------------------------------------------------------------*/


#include <stdio.h>

#include "gopher.h"

typedef struct gopherTypeIDStruct {
	char	typeID;
	char	*typeName;
   } gopherTypeID;

static gopherTypeID	types[] = {
	{'0', "text file"},
	{'1', "directory"},
	{'2', "CSO name server"},
	{'3', "error"},
	{'4', "Mac binhex"},
	{'5', "DOS binhex"},
	{'6', "uuencoded Unix"},
	{'7', "index search"},
	{'8', "telnet session"},
	{'I', "image file"},
	{'T', "tn3270 session"},
	{'s', "sound file"},
	{'+', "duplicate server"},
	{'\0', "unknown"}
   };

/* getTypeName
   return a printable type name for a gopher item type */

char *
getTypeName(t)
char	t;
{
	gopherTypeID	*tID;

	for (tID = types; tID->typeID != t  &&  tID->typeID != '\0'; tID++) ;

	return tID->typeName;
}


/* showItemInfo
   Show information associated with a gopher item (or directory) */

char *
getItemInfoText(gi, level)
gopherItemP	gi;
int		level;
{
	static char	infoString[1024];
	char	temp[256];

	*infoString = '\0';

	sprintf(temp, "          Gopher Item Information\n");
	strcat(infoString, temp);
	sprintf(temp, "          -----------------------\n\n");
	strcat(infoString, temp);

	sprintf(temp, "Name:  \'%s\'\n", USER_STRING(gi));
	strcat(infoString, temp);

	sprintf(temp, "Type:  %c (%s)\n",
				gi->type, getTypeName(gi->type));
	strcat(infoString, temp);

	sprintf(temp, "\n");
	strcat(infoString, temp);

	sprintf(temp, "Host:  \'%s\'\n", gi->host);
	strcat(infoString, temp);
	sprintf(temp, "       (Computer where information is maintained)\n");
	strcat(infoString, temp);

	sprintf(temp, "Port:  %d\n", gi->port);
	strcat(infoString, temp);
	sprintf(temp, "       (Network connection port)\n");
	strcat(infoString, temp);

	sprintf(temp, "\n");
	strcat(infoString, temp);

	sprintf(temp, "Path:  ");
	strcat(infoString, temp);
	sprintf(temp, "\'%s\'\n", vStringValue(&(gi->selector)));
	strcat(infoString, temp);
	sprintf(temp, "       (Tells host where to find the information)");
	strcat(infoString, temp);

	return infoString;
}
