/*
    Configuration management header file
    Copyright (c) 1993, 1994 Tudor Hulubei & Andrei Pitis

This file is part of UIT (UNIX Interactive Tools)

UIT is free software; you can redistribute it and/or modify it under the
terms of the GNU General Public License as published by the Free Software
Foundation; either version 2, or (at your option) any later version.

UIT is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
details .

You should have received a copy of the GNU General Public License along with
UIT; see the file COPYING.  If not, write to the Free Software Foundation,
675 Mass Ave, Cambridge, MA 02139, USA.  */


#ifndef _CONFIG_H
#define _CONFIG_H


#include <stdio.h>


#define MAXLINE		1024	/* change this to get more directory entries */
#define NO_SEEK		0
#define DO_SEEK		1

#define STATUS_BAD	0
#define STATUS_OK	1

#define IFS  		';'	/* internal field separator */
#define ICS		'#'	/* internal comment separator */
#define IAS		'='	/* internal assignment separator */


typedef struct
{
    FILE *file;
    int status;
    char line[MAXLINE];
} configuration;


int  configuration_getline(configuration *this);
configuration *configuration_init(char *filename);
void configuration_end(configuration *this);
int  configuration_getsectionptr(configuration *this, char *section_name);
int  configuration_getstatus(configuration *this);
void configuration_getfielddata(configuration *this, int sectionptr,
				char *field_name, char **dest,
				int fields, int seek);


#endif	/* _CONFIG_H */
