/*
    Mamory management file
    Copyright (c) 1993, 1994 Tudor Hulubei & Andrei Pitis

This file is part of UIT (UNIX Interactive Tools)

UIT is free software; you can redistribute it and/or modify it under the
terms of the GNU General Public License as published by the Free Software
Foundation; either version 2, or (at your option) any later version.

UIT is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
details.

You should have received a copy of the GNU General Public License along with
UIT; see the file COPYING.  If not, write to the Free Software Foundation,
675 Mass Ave, Cambridge, MA 02139, USA.  */


#include <stdlib.h>

#include "xmalloc.h"


void fatal(char *);


char *xmalloc(size_t size)
{
    void *pointer = malloc(size);

    if (pointer == NULL)
	fatal("xmalloc: virtual memory exhausted");

    return (char *)pointer;
}


char *xcalloc(size_t count, size_t itemsize)
{
    void *pointer = calloc(count, itemsize);

    if (pointer == NULL)
	fatal("xcalloc: virtual memory exhausted");

    return (char *)pointer;
}


char *xrealloc(void *pointer, size_t size)
{
    void *new_pointer = realloc(pointer, size);

    if (new_pointer == NULL)
	fatal("xrealloc: virtual memory exhausted");
    
    return (char *)new_pointer;
}
