#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <termios.h>
#include <string.h>
#include <signal.h>


#define TTY_OUTPUT 1


static struct termios old_term;
static struct termios new_term;


void do_exit(int);


void tty_init(void)
{    
    tcgetattr(TTY_OUTPUT, &old_term);

    signal(SIGTERM, do_exit);
    signal(SIGQUIT, do_exit);
    signal(SIGINT,  do_exit);

    new_term = old_term;
    new_term.c_iflag &= ~(ICRNL | IGNCR | INLCR | IGNBRK | BRKINT);
    new_term.c_oflag &= ~OPOST;
    new_term.c_lflag |= ISIG | NOFLSH;
    new_term.c_lflag &= ~(ICANON | ECHO);
    new_term.c_cc[VMIN]  = 1;
    new_term.c_cc[VTIME] = 0;
    tcsetattr(TTY_OUTPUT, TCSADRAIN, &new_term);
}


void tty_end(void)
{
    tcsetattr(TTY_OUTPUT, TCSADRAIN, &old_term);
}


void do_exit(int signum)
{
    tty_end();
    exit(1);
}


int main(void)
{
    char c;

    printf("UNIX Interactive Tools 4.3.1 - Display key sequence utility\n");
    printf("Copyright (c) 1993, 1994 Tudor Hulubei & Andrei Pitis\n");

    printf("\nPress space when done.\n\n");

    tty_init();

    for (;;)
    {
        read(0, &c, 1);
        if (c == ' ') break;
        printf("%x ", c);
        fflush(NULL);
    }

    tty_end();

    return 0;
}
