/*
    Configuration file management
    Copyright (c) 1993, 1994 Tudor Hulubei & Andrei Pitis

This file is part of UIT (UNIX Interactive Tools)

UIT is free software; you can redistribute it and/or modify it under the 
terms of the GNU General Public License as published by the Free Software 
Foundation; either version 2, or (at your option) any later version.  

UIT is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS 
FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more 
details.  

You should have received a copy of the GNU General Public License along with 
UIT; see the file COPYING.  If not, write to the Free Software Foundation, 
675 Mass Ave, Cambridge, MA 02139, USA.  */ 


#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <unistd.h>

#include "tty.h"
#include "config.h"
#include "misc.h"


static FILE *fileptr;
static int   sectionptr;
static char  line[MAXLINE];


int configuration_init(char *file_name)
{
    if (file_name == NULL) return 0;

    fileptr = fopen(file_name, "r");

    if (fileptr == NULL) return 0;

    sectionptr = -1;
    return 1;
}


void configuration_end(void)
{
    if (fileptr) fclose(fileptr);
}


static int configuration_getline(void)
{
    int len, c;
    char *comment;

    if (fgets(line, MAXLINE, fileptr) == NULL)
	return 0;

    if ((len = strlen(line)) == MAXLINE - 1)
    {
	fprintf(stderr, "%s: configuration: line too long. Truncated.\n",
		program);
	/* search the end of this big line */
	for (;;)
	{
	    c = fgetc(fileptr);
	    if (c == '\n' || c == EOF) break;
	}
    }

    if (comment = strchr(line, ICS))
	*comment = 0;
    else
	if (line[len - 1] == '\n')
	    line[len - 1] = 0;

    return 1;
}


int configuration_section(char *section_name)
{
    fseek(fileptr, 0, SEEK_SET);

    while (configuration_getline())
	if (strcmp(section_name, line) == 0)
	    return sectionptr = ftell(fileptr);

    return sectionptr = -1;
}


void configuration_getvarinfo(char *var_name, char **dest,
			      int fields, int seek)
{
    int fld;
    char buf[MAXLINE], *ptr, *tmp;

    if (seek) fseek(fileptr, sectionptr, SEEK_SET);

    if (fields == 1)
	*dest = 0;
    else
	memset(dest, 0, fields * sizeof(char *));

    while (configuration_getline() && *line)
    {
	*buf = 0;
	sscanf(line, "%s", buf);
	if (seek == NO_SEEK) buf[15] = 0;	/* just in case */

	if (!is_print(*buf)) return;

	if (seek == NO_SEEK || strcmp(var_name, buf) == 0)
	{
	    if ((ptr = strchr(line, IAS)) && *++ptr)
	    {
		for (dest[0] = ptr, fld = 1; *ptr && fld < fields; ptr++)
		    if (*ptr == IFS)
		    {
			*ptr = 0;
			if (*(ptr + 1) && *(ptr + 1) != IFS)
			    dest[fld] = ptr + 1;
			fld++;
		    }
		if (ptr = strchr(ptr, IFS)) *ptr = 0;
	    }

	    for (fld = 0; fld < fields; fld++)
		if (dest[fld])
		{
		    while (isspace(*dest[fld])) dest[fld]++;
		    tmp = dest[fld] + strlen(dest[fld]) - 1;
		    while (isspace(*tmp) && tmp >= dest[fld]) tmp--;
		    *(tmp + 1) = 0;
		    if (dest[fld][0] == 0) dest[fld] = NULL;
		}

	    if (seek == NO_SEEK) strcpy(var_name, buf);
	    return;
	}
    }

    if (seek == NO_SEEK) *var_name = 0;
}
