/* Keyboard support routines.
   Copyright (C) 1994 Miguel de Icaza.
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */
#include <ncurses.h>
#include "global.h"
#include "main.h"

static char rcsid [] = "$Header: /usr/users/miguel/c/CVS/nc/key.c,v 1.2 1994/05/10 20:49:04 miguel Exp $";

void init_key ()
{
}

int mi_getch ()
{
    int c;
    static int d;
    static int pending;

    if (pending){
	pending = 0;
	return d;
    }
    c = getch ();
    if (c != '\e')
	return c;
    nodelay (stdscr, TRUE);
    d = getch ();
    nodelay (stdscr, FALSE);
    if (d == ERR){
	pending = 0;
	return c;
    }
    switch (d){
    case '0':
	return KEY_F(10);
    case '1':
	return KEY_F(1);
    case '2':
	return KEY_F(2);
    case '3':
	return KEY_F(3);
    case '4':
	return KEY_F(4);
    case '5':
	return KEY_F(5);
    case '6':
	return KEY_F(6);
    case '7':
	return KEY_F(7);
    case '8':
	return KEY_F(8);
    case '9':
	return KEY_F(9);
    default:
	if (d >= 'a' && d <= 'z' || d == '\n')
	    return 0x80 | d;
	else
	    return d;
    }
    return d;
}
